/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.OutputPrinterToNull;
import net.sf.jabref.imports.BiblioscapeImporter;
import net.sf.jabref.imports.BibteXMLImporter;
import net.sf.jabref.imports.BibtexImporter;
import net.sf.jabref.imports.BiomailImporter;
import net.sf.jabref.imports.CopacImporter;
import net.sf.jabref.imports.CsaImporter;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.EndnoteImporter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.InspecImporter;
import net.sf.jabref.imports.IsiImporter;
import net.sf.jabref.imports.JstorImporter;
import net.sf.jabref.imports.MsBibImporter;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.OvidImporter;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PdfXmpImporter;
import net.sf.jabref.imports.RepecNepImporter;
import net.sf.jabref.imports.RisImporter;
import net.sf.jabref.imports.ScifinderImporter;
import net.sf.jabref.imports.SilverPlatterImporter;
import net.sf.jabref.imports.SixpackImporter;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportFormatReader {
    public static final String BIBTEX_FORMAT = "BibTeX";
    private final SortedSet<ImportFormat> formats = new TreeSet<ImportFormat>();
    private static final Log LOGGER = LogFactory.getLog(ImportFormatReader.class);

    public void resetImportFormats() {
        ImportFormat importFormat;
        this.formats.clear();
        this.formats.add(new CsaImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new EndnoteImporter());
        this.formats.add(new BibteXMLImporter());
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new SixpackImporter());
        this.formats.add(new InspecImporter());
        this.formats.add(new ScifinderImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new RisImporter());
        this.formats.add(new JstorImporter());
        this.formats.add(new SilverPlatterImporter());
        this.formats.add(new BiomailImporter());
        this.formats.add(new RepecNepImporter());
        this.formats.add(new PdfXmpImporter());
        this.formats.add(new CopacImporter());
        this.formats.add(new MsBibImporter());
        this.formats.add(new BibtexImporter());
        JabRefPlugin jabRefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabRefPlugin != null) {
            for (_JabRefPlugin.ImportFormatExtension object : jabRefPlugin.getImportFormatExtensions()) {
                importFormat = object.getImportFormat();
                if (importFormat == null) continue;
                this.formats.add(importFormat);
            }
        }
        for (CustomImportList.Importer importer : Globals.prefs.customImports) {
            try {
                importFormat = importer.getInstance();
                this.formats.add(importFormat);
            }
            catch (Exception exception) {
                System.err.println("Could not instantiate " + importer.getName() + " importer, will ignore it. Please check if the class is still available.");
                exception.printStackTrace();
            }
        }
    }

    private ImportFormat getByCliId(String string) {
        for (ImportFormat importFormat : this.formats) {
            if (!importFormat.getCLIId().equals(string)) continue;
            return importFormat;
        }
        return null;
    }

    public List<BibtexEntry> importFromStream(String string, InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        ImportFormat importFormat = this.getByCliId(string);
        if (importFormat == null) {
            throw new IllegalArgumentException("Unknown import format: " + string);
        }
        List<BibtexEntry> list = importFormat.importEntries(inputStream, outputPrinter);
        if (list != null) {
            ImportFormatReader.purgeEmptyEntries(list);
        }
        return list;
    }

    public List<BibtexEntry> importFromFile(String string, String string2, OutputPrinter outputPrinter) throws IOException {
        ImportFormat importFormat = this.getByCliId(string);
        if (importFormat == null) {
            throw new IllegalArgumentException("Unknown import format: " + string);
        }
        return this.importFromFile(importFormat, string2, outputPrinter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BibtexEntry> importFromFile(ImportFormat importFormat, String string, OutputPrinter outputPrinter) throws IOException {
        List<BibtexEntry> list = null;
        InputStream inputStream = null;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            if (!importFormat.isRecognizedFormat(inputStream)) {
                throw new IOException(Globals.lang("Wrong file format"));
            }
            inputStream = new FileInputStream(file);
            list = importFormat.importEntries(inputStream, outputPrinter);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return list;
    }

    public static BibtexDatabase createDatabase(Collection<BibtexEntry> collection) {
        ImportFormatReader.purgeEmptyEntries(collection);
        BibtexDatabase bibtexDatabase = new BibtexDatabase();
        for (BibtexEntry bibtexEntry : collection) {
            try {
                bibtexEntry.setId(IdGenerator.next());
                bibtexDatabase.insertEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                System.err.println("KeyCollisionException [ addBibEntries(...) ]");
            }
        }
        return bibtexDatabase;
    }

    public SortedSet<ImportFormat> getCustomImportFormats() {
        TreeSet<ImportFormat> treeSet = new TreeSet<ImportFormat>();
        for (ImportFormat importFormat : this.formats) {
            if (!importFormat.getIsCustomImporter()) continue;
            treeSet.add(importFormat);
        }
        return treeSet;
    }

    public SortedSet<ImportFormat> getBuiltInInputFormats() {
        TreeSet<ImportFormat> treeSet = new TreeSet<ImportFormat>();
        for (ImportFormat importFormat : this.formats) {
            if (importFormat.getIsCustomImporter()) continue;
            treeSet.add(importFormat);
        }
        return treeSet;
    }

    public SortedSet<ImportFormat> getImportFormats() {
        return this.formats;
    }

    public String getImportFormatList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ImportFormat importFormat : this.formats) {
            int n = Math.max(0, 14 - importFormat.getFormatName().length());
            stringBuilder.append("  ");
            stringBuilder.append(importFormat.getFormatName());
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(" : ");
            stringBuilder.append(importFormat.getCLIId());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String expandAuthorInitials(String string) {
        String[] stringArray = string.split(" and ");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            if (stringArray[i].contains(", ")) {
                stringArray2 = stringArray[i].split(", ");
                if (stringArray2.length > 0) {
                    stringBuilder.append(stringArray2[0]);
                    if (stringArray2.length > 1) {
                        stringBuilder.append(", ");
                    }
                }
                for (n = 1; n < stringArray2.length; ++n) {
                    if (n == 1) {
                        stringBuilder.append(ImportFormatReader.expandAll(stringArray2[n]));
                    } else {
                        stringBuilder.append(stringArray2[n]);
                    }
                    if (n >= stringArray2.length - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                stringArray2 = stringArray[i].split(" ");
                if (stringArray2.length > 0) {
                    stringBuilder.append(ImportFormatReader.expandAll(stringArray2[0]));
                }
                for (n = 1; n < stringArray2.length; ++n) {
                    stringBuilder.append(" ");
                    stringBuilder.append(stringArray2[n]);
                }
            }
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(" and ");
        }
        return stringBuilder.toString().trim();
    }

    private static String expandAll(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1 && Character.isLetter(string.charAt(0)) && Character.isUpperCase(string.charAt(0))) {
            return string + ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = string.charAt(0);
        char c2 = '\u0000';
        for (int i = 1; i < string.length(); ++i) {
            c2 = string.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(c2) && Character.isUpperCase(c2)) {
                stringBuilder.append(c);
                stringBuilder.append(". ");
            } else {
                stringBuilder.append(c);
            }
            c = c2;
        }
        if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(c2) && Character.isUpperCase(c2)) {
            stringBuilder.append(c);
            stringBuilder.append(". ");
        } else {
            stringBuilder.append(c);
        }
        return stringBuilder.toString().trim();
    }

    static File checkAndCreateFile(String string) {
        File file = new File(string);
        if (!(file.exists() || file.canRead() || file.isFile())) {
            LOGGER.info("Error " + string + " is not a valid file and|or is not readable.");
            return null;
        }
        return file;
    }

    public static void setIfNecessary(BibtexEntry bibtexEntry, String string, String string2) {
        if (!string2.equals("")) {
            bibtexEntry.setField(string, string2);
        }
    }

    public static Reader getUTF8Reader(File file) throws IOException {
        return ImportFormatReader.getReader(file, "UTF8");
    }

    public static Reader getUTF16Reader(File file) throws IOException {
        return ImportFormatReader.getReader(file, "UTF-16");
    }

    public static Reader getReader(File file, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
        return inputStreamReader;
    }

    public static Reader getReaderDefaultEncoding(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Globals.prefs.get("defaultEncoding"));
        return inputStreamReader;
    }

    private static void purgeEmptyEntries(Collection<BibtexEntry> collection) {
        Iterator<BibtexEntry> iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = iterator.next();
            if (bibtexEntry.getAllFields().size() != 0) continue;
            iterator.remove();
        }
    }

    public UnknownFormatImport importUnknownFormat(String string) {
        Object object;
        OutputPrinterToNull outputPrinterToNull = new OutputPrinterToNull();
        List<BibtexEntry> list = null;
        int n = 0;
        String string2 = null;
        for (ImportFormat importFormat : this.getImportFormats()) {
            try {
                int n2;
                List<BibtexEntry> list2 = this.importFromFile(importFormat, string, (OutputPrinter)outputPrinterToNull);
                if (list2 == null) {
                    n2 = 0;
                } else {
                    ImportFormatReader.purgeEmptyEntries(list2);
                    n2 = list2.size();
                }
                if (n2 <= n) continue;
                list = list2;
                n = list.size();
                string2 = importFormat.getFormatName();
            }
            catch (IOException iOException) {}
        }
        if (list != null) {
            object = new ParserResult(list);
            return new UnknownFormatImport(string2, (ParserResult)object);
        }
        try {
            object = OpenDatabaseAction.loadDatabase(new File(string), Globals.prefs.get("defaultEncoding"));
            if (((ParserResult)object).getDatabase().getEntryCount() > 0 || ((ParserResult)object).getDatabase().getStringCount() > 0) {
                ((ParserResult)object).setFile(new File(string));
                return new UnknownFormatImport(BIBTEX_FORMAT, (ParserResult)object);
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    public static class UnknownFormatImport {
        public final String format;
        public final ParserResult parserResult;

        public UnknownFormatImport(String string, ParserResult parserResult) {
            this.format = string;
            this.parserResult = parserResult;
        }
    }
}

