/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JPanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.INSPIREBibtexFilterReader;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

public class INSPIREFetcher
implements EntryFetcher {
    private static final String INSPIRE_HOST = "inspirehep.net";

    private String constructUrl(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("http://").append(INSPIRE_HOST).append("/");
        stringBuilder.append("/search?ln=en&ln=en&p=find+");
        stringBuilder.append(string2);
        stringBuilder.append("&action_search=Search&sf=&so=d&rm=&rg=1000&sc=0&of=hx");
        System.out.print("Inspire URL: " + stringBuilder.toString() + "\n");
        return stringBuilder.toString();
    }

    private BibtexDatabase importInspireEntries(String string, OutputPrinter outputPrinter) {
        String string2 = this.constructUrl(string);
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream inputStream = httpURLConnection.getInputStream();
            INSPIREBibtexFilterReader iNSPIREBibtexFilterReader = new INSPIREBibtexFilterReader(new InputStreamReader(inputStream));
            ParserResult parserResult = BibtexParser.parse(iNSPIREBibtexFilterReader);
            return parserResult.getDatabase();
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            outputPrinter.showMessage(Globals.lang("An Error occurred while fetching from INSPIRE source (%0):", new String[]{string2}) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    @Override
    public String getHelpPage() {
        return "Spires.html";
    }

    @Override
    public String getKeyName() {
        return "INSPIRE";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    public void cancelled() {
    }

    public void done(int n) {
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        try {
            outputPrinter.setStatus("Fetching entries from Inspire");
            BibtexDatabase bibtexDatabase = this.importInspireEntries(string, outputPrinter);
            outputPrinter.setStatus("Adding fetched entries");
            if (bibtexDatabase.getEntryCount() > 0) {
                for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
                    importInspector.addEntry(bibtexEntry);
                }
            }
        }
        catch (Exception exception) {
            outputPrinter.showMessage(Globals.lang("Error while fetching from Inspire: ") + exception.getMessage());
            exception.printStackTrace();
        }
        return true;
    }
}

