/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.CaseKeeperList;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.UnitFormatter;

public class IEEEXploreFetcher
implements EntryFetcher {
    final CaseKeeperList caseKeeperList = new CaseKeeperList();
    private final CaseKeeper caseKeeper = new CaseKeeper();
    private final UnitFormatter unitFormatter = new UnitFormatter();
    private final HTMLConverter htmlConverter = new HTMLConverter();
    private final JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private final JRadioButton htmlButton = new JRadioButton(Globals.lang("HTML parser"));
    private final JRadioButton bibButton = new JRadioButton(Globals.lang("BibTeX importer"));
    private static final int MAX_FETCH = 100;
    private final int perPage = 100;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private int piv = 0;
    private boolean shouldContinue = false;
    private boolean includeAbstract = false;
    private boolean importBibtex = false;
    private String terms;
    private final String endUrl = "&rowsPerPage=" + Integer.toString(100) + "&pageNumber=";
    private String searchUrl;
    private final Pattern hitsPattern = Pattern.compile("([0-9,]+) Results");
    private final Pattern idPattern = Pattern.compile("<input name='' title='.*' type='checkbox'value=''\\s*id='([0-9]+)'/>");
    private final Pattern typePattern = Pattern.compile("<span class=\"type\">\\s*(.+)");
    private final HashMap<String, String> fieldPatterns = new HashMap();
    private final Pattern absPattern = Pattern.compile("<p>\\s*(.+)");
    Pattern stdEntryPattern = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)");
    private final Pattern publicationPattern = Pattern.compile("(.*), \\d*\\.*\\s?(.*)");
    private final Pattern proceedingPattern = Pattern.compile("(.*?)\\.?\\s?Proceedings\\s?(.*)");
    Pattern abstractLinkPattern = Pattern.compile("<a href='(.+)'>\\s*<span class=\"more\">View full.*</span> </a>");
    Pattern ieeeArticleNumberPattern = Pattern.compile("<a href=\".*arnumber=(\\d+).*\">");
    private final Pattern authorPattern = Pattern.compile("<span id=\"preferredName\" class=\"(.*)\">");
    private static final String IMPORT_URL = "http://ieeexplore.ieee.org/xpls/downloadCitations";
    private static final String START_URL = "http://ieeexplore.ieee.org/search/freesearchresult.jsp?queryText=";

    public IEEEXploreFetcher() {
        CookieHandler.setDefault(new CookieManager());
        this.fieldPatterns.put("title", "<a\\s*href=[^<]+>\\s*(.+)\\s*</a>");
        this.fieldPatterns.put("volume", "Volume:\\s*([A-Za-z-]*\\d+)");
        this.fieldPatterns.put("number", "Issue:\\s*(\\d+)");
        this.fieldPatterns.put("year", "(?:Copyright|Publication) Year:\\s*(\\d{4})");
        this.fieldPatterns.put("pages", "Page\\(s\\):\\s*(\\d+)\\s*-\\s*(\\d*)");
        this.fieldPatterns.put("doi", "<a href=\"http://dx.doi.org/(.+)\" target");
        this.fieldPatterns.put("url", "<a href=\"(/stamp/stamp[^\"]+)");
    }

    @Override
    public JPanel getOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.htmlButton.setSelected(true);
        this.htmlButton.setEnabled(false);
        this.bibButton.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.htmlButton);
        buttonGroup.add(this.bibButton);
        jPanel.add((Component)this.absCheckBox, "North");
        jPanel.add((Component)this.htmlButton, "Center");
        jPanel.add((Component)this.bibButton, "East");
        return jPanel;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.terms = string;
        this.piv = 0;
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        int n = 1;
        this.searchUrl = this.makeUrl(n);
        try {
            URL uRL = new URL(this.searchUrl);
            String string2 = this.getResults(uRL);
            if (string2.contains("You have entered an invalid search")) {
                outputPrinter.showMessage(Globals.lang("You have entered an invalid search '%0'.", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            if (string2.contains("Bad request")) {
                outputPrinter.showMessage(Globals.lang("Bad Request '%0'.", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            if (string2.contains("No results were found.")) {
                outputPrinter.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            if (string2.contains("Error Page")) {
                outputPrinter.showMessage(Globals.lang("Intermittent errors on the IEEE Xplore server. Please try again in a while."), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            this.hits = this.getNumberOfHits(string2, "display-status", this.hitsPattern);
            this.includeAbstract = this.absCheckBox.isSelected();
            this.importBibtex = this.bibButton.isSelected();
            if (this.hits > 100) {
                outputPrinter.showMessage(Globals.lang("%0 entries found. To reduce server load, only %1 will be downloaded.", new String[]{String.valueOf(this.hits), String.valueOf(100)}), Globals.lang("Search IEEEXplore"), 1);
                this.hits = 100;
            }
            this.parse(importInspector, string2, 0, 1);
            for (int i = 100; this.shouldContinue && i < this.hits; i += 100) {
                this.searchUrl = this.makeUrl(++n);
                string2 = this.getResults(new URL(this.searchUrl));
                if (!this.shouldContinue) break;
                this.parse(importInspector, string2, 0, i + 1);
            }
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (ConnectException connectException) {
            outputPrinter.showMessage(Globals.lang("Connection to IEEEXplore failed"), Globals.lang("Search IEEEXplore"), 0);
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang(iOException.getMessage()), Globals.lang("Search IEEEXplore"), 0);
            iOException.printStackTrace();
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "IEEEXplore";
    }

    @Override
    public String getHelpPage() {
        return "IEEEXploreHelp.html";
    }

    @Override
    public String getKeyName() {
        return "IEEEXplore";
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    private String makeUrl(int n) {
        return START_URL + this.terms.replaceAll(" ", "+") + this.endUrl + String.valueOf(n);
    }

    private void parse(ImportInspector importInspector, String string, int n, int n2) {
        this.piv = n;
        int n3 = n2;
        if (this.importBibtex) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = this.parseNextEntryId(string, this.piv)) != null && this.shouldContinue) {
                arrayList.add(string2);
                ++n3;
            }
            try {
                BibtexDatabase bibtexDatabase = this.parseBibtexDatabase(arrayList, this.includeAbstract);
                Collection<BibtexEntry> collection = bibtexDatabase.getEntries();
                for (BibtexEntry bibtexEntry : collection) {
                    importInspector.addEntry(this.cleanup(bibtexEntry));
                    importInspector.setProgress(this.parsed + this.unparseable, this.hits);
                    ++this.parsed;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            BibtexEntry bibtexEntry;
            while ((bibtexEntry = this.parseNextEntry(string, this.piv)) != null && this.shouldContinue) {
                if (bibtexEntry.getField("title") != null) {
                    importInspector.addEntry(bibtexEntry);
                    importInspector.setProgress(this.parsed + this.unparseable, this.hits);
                    ++this.parsed;
                }
                ++n3;
            }
        }
    }

    private BibtexDatabase parseBibtexDatabase(List<String> list, boolean bl) throws IOException {
        int n;
        String string3;
        URLConnection uRLConnection;
        if (list.isEmpty()) {
            return null;
        }
        try {
            uRLConnection = new URL(IMPORT_URL).openConnection();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        uRLConnection.setRequestProperty("Referer", this.searchUrl);
        PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
        String string2 = "";
        for (String string3 : list) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2.trim();
        String string4 = bl ? "citation-abstract" : "citation-only";
        string3 = "recordIds=" + string2.replaceAll(" ", "%20") + "&fromPageName=&citations-format=" + (String)string4 + "&download-format=download-bibtex";
        System.out.println(string3);
        printWriter.write(string3);
        printWriter.flush();
        printWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[256];
        while ((n = bufferedReader.read(cArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(cArray[i]);
            }
        }
        System.out.println(stringBuilder.toString());
        ParserResult parserResult = new BibtexParser(bufferedReader).parse();
        bufferedReader.close();
        return parserResult.getDatabase();
    }

    private BibtexEntry cleanup(BibtexEntry bibtexEntry) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        if (bibtexEntry == null) {
            return null;
        }
        String string2 = bibtexEntry.getField("title");
        if (string2 != null) {
            string2 = string2.replaceAll("[ ]?img src=[^ ]+ alt=\"([^\"]+)\">[ ]?", "\\$$1\\$");
            string2 = string2.replaceAll("/sub /spl infin//", "\\$_\\\\infty\\$");
            string2 = string2.replaceAll("/sup /spl infin//", "\\$\\^\\\\infty\\$");
            string2 = string2.replaceAll("/[sS]pl ([^/]+)/", "\\$\\\\$1\\$");
            if (Globals.prefs.getBoolean("useConvertToEquation")) {
                string2 = string2.replaceAll("/sup ([^/]+)/", "\\$\\^\\{$1\\}\\$");
                string2 = string2.replaceAll("/sub ([^/]+)/", "\\$_\\{$1\\}\\$");
                string2 = string2.replaceAll("\\(sup\\)([^(]+)\\(/sup\\)", "\\$\\^\\{$1\\}\\$");
                string2 = string2.replaceAll("\\(sub\\)([^(]+)\\(/sub\\)", "\\_\\{$1\\}\\$");
            } else {
                string2 = string2.replaceAll("/sup ([^/]+)/", "\\\\textsuperscript\\{$1\\}");
                string2 = string2.replaceAll("/sub ([^/]+)/", "\\\\textsubscript\\{$1\\}");
                string2 = string2.replaceAll("\\(sup\\)([^(]+)\\(/sup\\)", "\\\\textsuperscript\\{$1\\}");
                string2 = string2.replaceAll("\\(sub\\)([^(]+)\\(/sub\\)", "\\\\textsubscript\\{$1\\}");
            }
            string2 = string2.replaceAll("\\\\infin", "\\\\infty");
            if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                string2 = this.unitFormatter.format(string2);
            }
            if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                string2 = this.caseKeeper.format(string2);
            }
            bibtexEntry.setField("title", string2);
        }
        if ((string = bibtexEntry.getField("month")) != null && string.length() > 0) {
            string = string.replaceAll("\\.", "");
            string = string.toLowerCase();
            object5 = Pattern.compile("(\\d*+)\\s*([a-z]*+)-*(\\d*+)\\s*([a-z]*+)");
            object4 = ((Pattern)object5).matcher(string);
            object3 = string;
            if (((Matcher)object4).find()) {
                if (((Matcher)object4).group(3).length() == 0) {
                    if (((Matcher)object4).group(2).length() > 0) {
                        object3 = "#" + ((Matcher)object4).group(2).substring(0, 3) + "#";
                        if (((Matcher)object4).group(1).length() > 0) {
                            object3 = (String)object3 + " " + ((Matcher)object4).group(1) + ",";
                        }
                    } else {
                        object3 = ((Matcher)object4).group(1) + ",";
                    }
                } else {
                    object3 = ((Matcher)object4).group(2).length() == 0 ? (((Matcher)object4).group(4).length() > 0 ? "#" + ((Matcher)object4).group(4).substring(0, 3) + "# " + ((Matcher)object4).group(1) + "--" + ((Matcher)object4).group(3) + "," : (String)object3 + ",") : "#" + ((Matcher)object4).group(2).substring(0, 3) + "# " + ((Matcher)object4).group(1) + "--#" + ((Matcher)object4).group(4).substring(0, 3) + "# " + ((Matcher)object4).group(3) + ",";
                }
            }
            bibtexEntry.setField("month", (String)object3);
        }
        if ((object4 = bibtexEntry.getField((String)(object5 = "pages"))) != null && ((String[])(object3 = ((String)object4).split("-"))).length == 2) {
            if (object3[0].equals(object3[1])) {
                bibtexEntry.setField((String)object5, object3[0]);
            } else {
                bibtexEntry.setField((String)object5, ((String)object4).replaceAll("-", "--"));
            }
        }
        object3 = bibtexEntry.getType();
        String string3 = "";
        if (((BibtexEntryType)object3).getName().equals("Article")) {
            string3 = "journal";
            bibtexEntry.clearField("booktitle");
        } else if (((BibtexEntryType)object3).getName().equals("Inproceedings")) {
            string3 = "booktitle";
        }
        String string4 = bibtexEntry.getField(string3);
        if (string4 != null) {
            Object object6;
            String string5;
            String string6;
            Object object7;
            if (((BibtexEntryType)object3).getName().equals("Article")) {
                int n = string4.indexOf(": Accepted for future publication");
                if (n > 0) {
                    string4 = string4.substring(0, n);
                    bibtexEntry.setField("year", "to be published");
                    bibtexEntry.clearField("month");
                    bibtexEntry.clearField("pages");
                    bibtexEntry.clearField("number");
                }
                object2 = string4.split("[\\[\\]]");
                string4 = object2[0];
                if (((String[])object2).length == 3) {
                    string4 = string4 + object2[2];
                }
                if ((object7 = bibtexEntry.getField("note")) != null && ((String)object7).equals("Early Access")) {
                    bibtexEntry.setField("year", "to be published");
                    bibtexEntry.clearField("month");
                    bibtexEntry.clearField("pages");
                    bibtexEntry.clearField("number");
                }
            } else {
                string4 = string4.replace("Conference Proceedings", "Proceedings").replace("Proceedings of", "Proceedings").replace("Proceedings.", "Proceedings");
                string4 = string4.replaceAll("International", "Int.");
                string4 = string4.replaceAll("Symposium", "Symp.");
                string4 = string4.replaceAll("Conference", "Conf.");
                string4 = string4.replaceAll(" on", " ").replace("  ", " ");
            }
            object = this.publicationPattern.matcher(string4);
            object2 = ".*[^,] '?\\d+\\)?";
            if (((Matcher)object).find()) {
                object7 = ((Matcher)object).group(2).trim();
                string6 = ((Matcher)object).group(1).trim();
                string5 = "";
                object6 = ((String)object7).split("\\. ", 2);
                if (((String[])object6).length == 2) {
                    if (object6[0].matches((String)object2)) {
                        object7 = object6[1];
                        string5 = object6[0];
                    } else {
                        object7 = object6[0];
                        string5 = object6[1];
                    }
                }
                if (!((String)object7).matches((String)object2)) {
                    string4 = (String)object7 + " " + string6 + " " + string5;
                    string4 = string4.trim();
                } else {
                    string4 = string6 + " " + (String)object7;
                }
            }
            if (((BibtexEntryType)object3).getName().equals("Article")) {
                string4 = string4.replace(" - ", "-");
                string4 = string4.trim();
                if (Globals.prefs.getBoolean("useIEEEAbrv")) {
                    string4 = Globals.journalAbbrev.getMedlineAbbreviation(string4).or(string4);
                }
            }
            if (((BibtexEntryType)object3).getName().equals("Inproceedings")) {
                object7 = this.proceedingPattern.matcher(string4);
                if (((Matcher)object7).find()) {
                    string6 = ((Matcher)object7).group(2);
                    string5 = ((Matcher)object7).group(1).replaceAll("\\.$", "");
                    if (!string6.matches((String)object2)) {
                        object6 = "";
                        String[] stringArray = string5.split("\\. ", 2);
                        if (stringArray.length == 2) {
                            if (stringArray[0].matches((String)object2)) {
                                string5 = stringArray[1];
                                object6 = stringArray[0];
                            } else {
                                string5 = stringArray[0];
                                object6 = stringArray[1];
                            }
                        }
                        string4 = string6.trim() + " " + string5.trim() + " " + (String)object6;
                    } else {
                        string4 = string5.trim() + " " + string6.trim();
                    }
                }
                string4 = string4.trim();
                string4 = string4.replaceAll("^[tT]he ", "").replaceAll("^\\d{4} ", "").replaceAll("[,.]$", "");
                string6 = bibtexEntry.getField("year");
                if (!((string4 = string4.replaceAll(", " + string6 + "\\.?", "")).contains("Abstract") || string4.contains("Summaries") || string4.contains("Conference Record"))) {
                    string4 = "Proc. " + string4;
                }
            }
            bibtexEntry.setField(string3, string4);
        }
        if ((object = bibtexEntry.getField("abstract")) != null) {
            object = ((String)object).replaceAll("/sub /spl infin//", "\\$_\\\\infty\\$");
            object = ((String)object).replaceAll("/sup /spl infin//", "\\$\\^\\\\infty\\$");
            object = ((String)object).replaceAll("/[sS]pl ([^/]+)/", "\\$\\\\$1\\$");
            if (Globals.prefs.getBoolean("useConvertToEquation")) {
                object = ((String)object).replaceAll("/sup ([^/]+)/", "\\$\\^\\{$1\\}\\$");
                object = ((String)object).replaceAll("/sub ([^/]+)/", "\\$_\\{$1\\}\\$");
                object = ((String)object).replaceAll("\\(sup\\)([^(]+)\\(/sup\\)", "\\$\\^\\{$1\\}\\$");
                object = ((String)object).replaceAll("\\(sub\\)([^(]+)\\(/sub\\)", "\\_\\{$1\\}\\$");
            } else {
                object = ((String)object).replaceAll("/sup ([^/]+)/", "\\\\textsuperscript\\{$1\\}");
                object = ((String)object).replaceAll("/sub ([^/]+)/", "\\\\textsubscript\\{$1\\}");
                object = ((String)object).replaceAll("\\(sup\\)([^(]+)\\(/sup\\)", "\\\\textsuperscript\\{$1\\}");
                object = ((String)object).replaceAll("\\(sub\\)([^(]+)\\(/sub\\)", "\\\\textsubscript\\{$1\\}");
            }
            object = ((String)object).replaceAll("\\\\infin", "\\\\infty");
            bibtexEntry.setField("abstract", (String)object);
        }
        if ((object2 = bibtexEntry.getField("url")) != null) {
            bibtexEntry.setField("url", "http://ieeexplore.ieee.org" + object2.replace("tp=&", ""));
        }
        return bibtexEntry;
    }

    private String parseNextEntryId(String string, int n) {
        int n2 = string.indexOf("<div class=\"select", n);
        int n3 = string.indexOf("</div>", n2);
        if (n2 >= 0 && n3 > 0) {
            String string2 = string.substring(n2, n3);
            this.piv = n3 += 6;
            Matcher matcher = this.idPattern.matcher(string2);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    private BibtexEntry parseNextEntry(String string, int n) {
        BibtexEntry bibtexEntry = null;
        int n2 = string.indexOf("<div class=\"detail", this.piv);
        int n3 = string.indexOf("</div>", n2);
        if (n2 >= 0 && n3 > 0) {
            Object object;
            this.piv = n3 += 6;
            String string2 = string.substring(n2, n3);
            BibtexEntryType bibtexEntryType = null;
            String string3 = null;
            String string4 = "";
            Matcher matcher = this.typePattern.matcher(string2);
            if (matcher.find()) {
                string4 = matcher.group(1);
                if (string4.equalsIgnoreCase("IEEE Journals &amp; Magazines") || string4.equalsIgnoreCase("IEEE Early Access Articles") || string4.equalsIgnoreCase("IET Journals &amp; Magazines") || string4.equalsIgnoreCase("AIP Journals &amp; Magazines") || string4.equalsIgnoreCase("AVS Journals &amp; Magazines") || string4.equalsIgnoreCase("IBM Journals &amp; Magazines") || string4.equalsIgnoreCase("TUP Journals &amp; Magazines") || string4.equalsIgnoreCase("BIAI Journals &amp; Magazines")) {
                    bibtexEntryType = BibtexEntryType.getType("article");
                    string3 = "journal";
                } else if (string4.equalsIgnoreCase("IEEE Conference Publications") || string4.equalsIgnoreCase("IET Conference Publications") || string4.equalsIgnoreCase("VDE Conference Publications")) {
                    bibtexEntryType = BibtexEntryType.getType("inproceedings");
                    string3 = "booktitle";
                } else if (string4.equalsIgnoreCase("IEEE Standards") || string4.equalsIgnoreCase("Standards")) {
                    bibtexEntryType = BibtexEntryType.getType("standard");
                    string3 = "number";
                } else if (string4.equalsIgnoreCase("IEEE eLearning Library Courses")) {
                    bibtexEntryType = BibtexEntryType.getType("electronic");
                    string3 = "note";
                } else if (string4.equalsIgnoreCase("Wiley-IEEE Press eBook Chapters") || string4.equalsIgnoreCase("MIT Press eBook Chapters") || string4.equalsIgnoreCase("IEEE USA Books &amp; eBooks")) {
                    bibtexEntryType = BibtexEntryType.getType("incollection");
                    string3 = "booktitle";
                }
            }
            if (bibtexEntryType == null) {
                bibtexEntryType = BibtexEntryType.getType("misc");
                string3 = "note";
                System.err.println("Type detection failed. Use MISC instead.");
                ++this.unparseable;
                System.err.println(string2);
            }
            bibtexEntry = new BibtexEntry(IdGenerator.next(), bibtexEntryType);
            if (string4.equalsIgnoreCase("IEEE Standards")) {
                bibtexEntry.setField("organization", "IEEE");
            }
            if (string4.equalsIgnoreCase("Wiley-IEEE Press eBook Chapters")) {
                bibtexEntry.setField("publisher", "Wiley-IEEE Press");
            } else if (string4.equalsIgnoreCase("MIT Press eBook Chapters")) {
                bibtexEntry.setField("publisher", "MIT Press");
            } else if (string4.equalsIgnoreCase("IEEE USA Books &amp; eBooks")) {
                bibtexEntry.setField("publisher", "IEEE USA");
            }
            if (string4.equalsIgnoreCase("IEEE Early Access Articles")) {
                bibtexEntry.setField("note", "Early Access");
            }
            Set<String> set = this.fieldPatterns.keySet();
            for (String charSequence2 : set) {
                Matcher n4 = Pattern.compile(this.fieldPatterns.get(charSequence2)).matcher(string2);
                if (!n4.find()) continue;
                bibtexEntry.setField(charSequence2, this.htmlConverter.format(n4.group(1)));
                if (charSequence2.equals("title") && n4.find()) {
                    object = this.htmlConverter.format(n4.group(1));
                    if (bibtexEntry.getType() == BibtexEntryType.getStandardType("standard")) {
                        object = ((String)object).replaceAll("IEEE Std ", "");
                    }
                    bibtexEntry.setField(string3, (String)object);
                }
                if (!charSequence2.equals("pages") || n4.groupCount() != 2) continue;
                bibtexEntry.setField(charSequence2, n4.group(1) + "-" + n4.group(2));
            }
            Matcher matcher3 = this.authorPattern.matcher(string2);
            StringBuilder stringBuilder = new StringBuilder("");
            int n4 = 0;
            while (matcher3.find()) {
                if (n4 >= 1) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(this.htmlConverter.format(matcher3.group(1)));
                ++n4;
            }
            bibtexEntry.setField("author", stringBuilder.toString());
            if (bibtexEntry.getField("author") == null || bibtexEntry.getField("author").startsWith("a href") || bibtexEntry.getField("author").startsWith("Topic(s)")) {
                bibtexEntry.setField("author", "");
            }
            if (bibtexEntry.getType() == BibtexEntryType.getStandardType("inproceedings") && bibtexEntry.getField("author").equals("")) {
                bibtexEntry.setType(BibtexEntryType.getStandardType("proceedings"));
            }
            if (this.includeAbstract && (n2 = string2.indexOf("id=\"abstract")) >= 0 && ((Matcher)(object = this.absPattern.matcher(string2 = string2.substring(n2, n3 = string2.indexOf("</div>", n2) + 6)))).find()) {
                String string5 = ((Matcher)object).group(1);
                string5 = string5.replaceAll("<span class='snippet'>([\\w]+)</span>", "$1");
                bibtexEntry.setField("abstract", this.htmlConverter.format(string5));
            }
        }
        if (bibtexEntry == null) {
            return null;
        }
        return this.cleanup(bibtexEntry);
    }

    private int getNumberOfHits(String string, String string2, Pattern pattern) throws IOException {
        int n = string.indexOf(string2);
        if (n < 0) {
            System.out.println(string);
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String string3 = string.substring(n, string.length());
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    private String getResults(URL uRL) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String getResultsFromFile(File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[256];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
        }
        return stringBuilder.toString();
    }
}

