/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;

public abstract class EntryFromFileCreator
implements FileFilter {
    final ExternalFileType externalFileType;

    EntryFromFileCreator(ExternalFileType externalFileType) {
        this.externalFileType = externalFileType;
    }

    protected abstract BibtexEntry createBibtexEntry(File var1);

    @Override
    public abstract boolean accept(File var1);

    public abstract String getFormatName();

    public BibtexEntry createEntry(File file, boolean bl) {
        if (file == null || !file.exists()) {
            return null;
        }
        BibtexEntry bibtexEntry = this.createBibtexEntry(file);
        if (bibtexEntry == null) {
            return null;
        }
        if (bl) {
            this.appendToField(bibtexEntry, "keywords", this.extractPathesToKeyWordsfield(file.getAbsolutePath()));
        }
        if (bibtexEntry.getField("title") == null) {
            bibtexEntry.setField("title", file.getName());
        }
        this.addFileInfo(bibtexEntry, file);
        return bibtexEntry;
    }

    public ExternalFileType getExternalFileType() {
        return this.externalFileType;
    }

    private String extractPathesToKeyWordsfield(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + File.separatorChar);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) break;
            if (string2.length() < 4) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void addFileInfo(BibtexEntry bibtexEntry, File file) {
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        ExternalFileType externalFileType = jabRefPreferences.getExternalFileTypeByExt(this.externalFileType.getFieldName());
        String[] stringArray = JabRef.jrf.basePanel().metaData().getFileDirectory("file");
        File file2 = FileUtil.shortenFileName(file, stringArray);
        FileListEntry fileListEntry = new FileListEntry("", file2.getPath(), externalFileType);
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.addEntry(0, fileListEntry);
        bibtexEntry.setField("file", fileListTableModel.getStringRepresentation());
    }

    void appendToField(BibtexEntry bibtexEntry, String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            return;
        }
        String string3 = bibtexEntry.getField(string);
        if (string3 == null) {
            bibtexEntry.setField(string, string2);
        } else if (!string3.contains(string2)) {
            bibtexEntry.setField(string, string3 + "," + string2);
        }
    }

    void addEntrysToEntry(BibtexEntry bibtexEntry, List<BibtexEntry> list) {
        if (list != null) {
            for (BibtexEntry bibtexEntry2 : list) {
                this.addEntryDataToEntry(bibtexEntry, bibtexEntry2);
            }
        }
    }

    void addEntryDataToEntry(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        for (String string : bibtexEntry2.getAllFields()) {
            this.appendToField(bibtexEntry, string, bibtexEntry2.getField(string));
        }
    }

    public String toString() {
        if (this.externalFileType == null) {
            return "(undefined)";
        }
        return this.externalFileType.getName() + " (." + this.externalFileType.getExtension() + ")";
    }
}

