/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.UnitFormatter;
import net.sf.jabref.util.Util;

public class DiVAtoBibTeXFetcher
implements EntryFetcher {
    private static final String URL_PATTERN = "http://www.diva-portal.org/smash/getreferences?referenceFormat=BibTex&pids=%s";
    private static final String ABSTRACT_URL_PATTERN = "http://www.diva-portal.org/smash/record.jsf?pid=%s";
    private final CaseKeeper caseKeeper = new CaseKeeper();
    private final UnitFormatter unitFormatter = new UnitFormatter();
    private final HTMLConverter htmlConverter = new HTMLConverter();

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        String string2;
        URLConnection uRLConnection;
        URL uRL;
        String string3;
        try {
            string3 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputPrinter.setStatus(Globals.lang("Error"));
            unsupportedEncodingException.printStackTrace();
            return false;
        }
        String string4 = String.format(URL_PATTERN, string3);
        try {
            uRL = new URL(string4);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        try {
            string2 = Util.getResultsWithEncoding(uRLConnection, "UTF-8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            outputPrinter.showMessage(Globals.lang("Unknown DiVA entry: '%0'.", string), Globals.lang("Get BibTeX entry from DiVA"), 1);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        BibtexEntry bibtexEntry = BibtexParser.singleFromString(string2);
        if (bibtexEntry != null) {
            String string5;
            String string6 = bibtexEntry.getField("title");
            if (string6 != null) {
                if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                    string6 = this.unitFormatter.format(string6);
                }
                if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                    string6 = this.caseKeeper.format(string6);
                }
                bibtexEntry.setField("title", string6);
            }
            if ((string5 = bibtexEntry.getField("institution")) != null) {
                string5 = this.htmlConverter.formatUnicode(string5);
                bibtexEntry.setField("institution", string5);
            }
            importInspector.addEntry(bibtexEntry);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "DiVA";
    }

    @Override
    public String getKeyName() {
        return "DiVAtoBibTeX";
    }

    @Override
    public String getHelpPage() {
        return "DiVAtoBibTeXHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

