/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.net.URLDownload;

class BibsonomyScraper {
    private static final String BIBSONOMY_SCRAPER = "http://scraper.bibsonomy.org/service?url=";
    private static final String BIBSONOMY_SCRAPER_POST = "&format=bibtex";

    BibsonomyScraper() {
    }

    public static BibtexEntry getEntry(String string) {
        try {
            string = string.replaceAll("%", "%25").replaceAll(":", "%3A").replaceAll("/", "%2F").replaceAll("\\?", "%3F").replaceAll("&", "%26").replaceAll("=", "%3D");
            URL uRL = new URL(BIBSONOMY_SCRAPER + string + BIBSONOMY_SCRAPER_POST);
            String string2 = new URLDownload(uRL).downloadToString("UTF8");
            BibtexParser bibtexParser = new BibtexParser(new StringReader(string2));
            ParserResult parserResult = bibtexParser.parse();
            if (parserResult != null && parserResult.getDatabase().getEntryCount() > 0) {
                return parserResult.getDatabase().getEntries().iterator().next();
            }
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
    }
}

