/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class BiblioscapeImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Biblioscape";
    }

    @Override
    public String getCLIId() {
        return "biblioscape";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, StringBuffer> hashMap2 = new HashMap<String, StringBuffer>();
        StringBuffer stringBuffer = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0) continue;
            if (string.equals("------")) {
                Map.Entry entry2;
                String[] stringArray = new String[2];
                String[] stringArray2 = new String[2];
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Vector<String> vector = new Vector<String>();
                for (Map.Entry entry2 : hashMap2.entrySet()) {
                    if (((String)entry2.getKey()).equals("AU")) {
                        hashMap.put("author", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("TI")) {
                        string5 = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("ST")) {
                        string4 = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("YP")) {
                        hashMap.put("year", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("VL")) {
                        hashMap.put("volume", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("NB")) {
                        hashMap.put("number", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("PS")) {
                        stringArray2[0] = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("PE")) {
                        stringArray2[1] = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("KW")) {
                        hashMap.put("keywords", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("RT")) {
                        stringArray[0] = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("SB")) {
                        vector.add("Subject: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("SA")) {
                        vector.add("Secondary Authors: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("NT")) {
                        hashMap.put("note", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("PB")) {
                        hashMap.put("publisher", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("TA")) {
                        vector.add("Tertiary Authors: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("TT")) {
                        vector.add("Tertiary Title: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("ED")) {
                        hashMap.put("edition", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("TW")) {
                        stringArray[1] = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("QA")) {
                        vector.add("Quaternary Authors: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("QT")) {
                        vector.add("Quaternary Title: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("IS")) {
                        hashMap.put("isbn", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("AB")) {
                        hashMap.put("abstract", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("AD")) {
                        string3 = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("LG")) {
                        hashMap.put("language", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("CO")) {
                        string2 = ((StringBuffer)entry2.getValue()).toString();
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("UR") || ((String)entry2.getKey()).equals("AT")) {
                        String string6 = ((StringBuffer)entry2.getValue()).toString().trim();
                        hashMap.put(string6.startsWith("http://") || string6.startsWith("ftp://") ? "url" : "pdf", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C1")) {
                        vector.add("Custom1: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C2")) {
                        vector.add("Custom2: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C3")) {
                        vector.add("Custom3: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C4")) {
                        vector.add("Custom4: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C5")) {
                        vector.add("Custom5: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("C6")) {
                        vector.add("Custom6: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("DE")) {
                        hashMap.put("annote", ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("CA")) {
                        vector.add("Categories: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (((String)entry2.getKey()).equals("TH")) {
                        vector.add("Short Title: " + ((StringBuffer)entry2.getValue()).toString());
                        continue;
                    }
                    if (!((String)entry2.getKey()).equals("SE")) continue;
                    hashMap.put("chapter", ((StringBuffer)entry2.getValue()).toString());
                }
                Object object = "misc";
                for (int i = 1; i >= 0 && ((String)object).equals("misc"); --i) {
                    if (stringArray[i] == null) continue;
                    stringArray[i] = stringArray[i].toLowerCase();
                    if (stringArray[i].contains("article")) {
                        object = "article";
                        continue;
                    }
                    if (stringArray[i].contains("journal")) {
                        object = "article";
                        continue;
                    }
                    if (stringArray[i].contains("book section")) {
                        object = "inbook";
                        continue;
                    }
                    if (stringArray[i].contains("book")) {
                        object = "book";
                        continue;
                    }
                    if (stringArray[i].contains("conference")) {
                        object = "inproceedings";
                        continue;
                    }
                    if (stringArray[i].contains("proceedings")) {
                        object = "inproceedings";
                        continue;
                    }
                    if (stringArray[i].contains("report")) {
                        object = "techreport";
                        continue;
                    }
                    if (stringArray[i].contains("thesis") && stringArray[i].contains("master")) {
                        object = "mastersthesis";
                        continue;
                    }
                    if (!stringArray[i].contains("thesis")) continue;
                    object = "phdthesis";
                }
                if (((String)object).equals("article")) {
                    if (string4 != null) {
                        hashMap.put("journal", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                } else if (((String)object).equals("inbook")) {
                    if (string4 != null) {
                        hashMap.put("booktitle", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                } else {
                    if (string4 != null) {
                        hashMap.put("booktitle", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                }
                if (stringArray2[0] != null || stringArray2[1] != null) {
                    hashMap.put("pages", (stringArray2[0] != null ? stringArray2[0] : "") + (stringArray2[1] != null ? "--" + stringArray2[1] : ""));
                }
                if (string3 != null) {
                    hashMap.put("address", string3 + (string2 != null ? ", " + string2 : ""));
                }
                if (vector.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < vector.size(); ++i) {
                        stringBuilder.append(i > 0 ? "; " : "").append((String)vector.elementAt(i));
                    }
                    hashMap.put("comment", stringBuilder.toString());
                }
                entry2 = new BibtexEntry("__ID", Globals.getEntryType((String)object));
                ((BibtexEntry)((Object)entry2)).setField(hashMap);
                arrayList.add((BibtexEntry)((Object)entry2));
                hashMap.clear();
                hashMap2.clear();
                stringBuffer = null;
                continue;
            }
            if (string.startsWith("--") && string.length() >= 7 && string.substring(4, 7).equals("-- ")) {
                stringBuffer = new StringBuffer(string.substring(7));
                hashMap2.put(string.substring(2, 4), stringBuffer);
                continue;
            }
            if (stringBuffer == null) {
                return null;
            }
            stringBuffer.append(string.trim());
        }
        return arrayList;
    }
}

