/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.imports.ParserResult;

public class AutosaveStartupPrompter
implements Runnable {
    private final JabRefFrame frame;
    private final List<File> files;

    public AutosaveStartupPrompter(JabRefFrame jabRefFrame, List<File> list) {
        this.frame = jabRefFrame;
        this.files = list;
    }

    @Override
    public void run() {
        boolean bl = this.frame.baseCount() == 0;
        ArrayList<ParserResult> arrayList = new ArrayList<ParserResult>();
        HashMap<ParserResult, Integer> hashMap = new HashMap<ParserResult, Integer>();
        Iterator<File> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            Object object;
            int n;
            File file;
            File file2 = file = iterator.next();
            boolean bl2 = Globals.prefs.getBoolean("promptBeforeUsingAutosave") ? (n = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("An autosave file was found for this database. This could indicate ") + Globals.lang("that JabRef didn't shut down cleanly last time the file was used.") + "<br>" + Globals.lang("Do you want to recover the database from the autosave file?") + "</html>", Globals.lang("Autosave of file '%0'", file.getName()), 0)) == 0 : true;
            if (bl2) {
                file2 = AutoSaveManager.getAutoSaveFile(file);
            }
            n = 0;
            ParserResult parserResult = null;
            while (n == 0) {
                parserResult = JabRef.openBibFile(file2.getPath(), true);
                if (parserResult != null && !parserResult.isInvalid()) {
                    arrayList.add(parserResult);
                    object = this.frame.addTab(parserResult.getDatabase(), file, parserResult.getMetaData(), parserResult.getEncoding(), bl);
                    hashMap.put(parserResult, this.frame.baseCount() - 1);
                    if (bl2) {
                        ((BasePanel)object).markNonUndoableBaseChanged();
                    }
                    bl = false;
                    n = 1;
                    continue;
                }
                if (bl2) {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("Error opening autosave of '%0'. Trying to load '%0' instead.", file.getName()), Globals.lang("Error opening file"), 0);
                    bl2 = false;
                    file2 = file;
                    continue;
                }
                object = parserResult != null ? "<html>" + parserResult.getErrorMessage() + "<p>" + Globals.lang("Error opening file '%0'.", file.getName()) + "</html>" : Globals.lang("Error opening file '%0'.", file.getName());
                JOptionPane.showMessageDialog(this.frame, object, Globals.lang("Error opening file"), 0);
                n = 1;
            }
            if (parserResult == null || parserResult.isInvalid() || !Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !parserResult.hasWarnings()) continue;
            object = parserResult.warnings();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuilder.append(i + 1).append(". ").append(object[i]).append("\n");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            this.frame.showBaseAt((Integer)hashMap.get(parserResult));
            JOptionPane.showMessageDialog(this.frame, stringBuilder.toString(), Globals.lang("Warnings"), 2);
        }
    }
}

