/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.gui.FetcherPreviewDialog;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PreviewEntryFetcher;
import net.sf.jabref.imports.UnitFormatter;

public class ACMPortalFetcher
implements PreviewEntryFetcher {
    private final ImportInspector dialog = null;
    private final HTMLConverter htmlConverter = new HTMLConverter();
    private final CaseKeeper caseKeeper = new CaseKeeper();
    private final UnitFormatter unitFormatter = new UnitFormatter();
    private String terms;
    private static final String startUrl = "http://portal.acm.org/";
    private static final String searchUrlPart = "results.cfm?query=";
    private static final String searchUrlPartII = "&dl=";
    private static final String endUrl = "&coll=Portal&short=0";
    private static final String bibtexUrl = "exportformats.cfm?id=";
    private static final String bibtexUrlEnd = "&expformat=bibtex";
    private static final String abstractUrl = "tab_abstract.cfm?id=";
    private final JRadioButton acmButton = new JRadioButton(Globals.lang("The ACM Digital Library"));
    private final JRadioButton guideButton = new JRadioButton(Globals.lang("The Guide to Computing Literature"));
    private final JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private static final int perPage = 20;
    private static final int MAX_FETCH = 20;
    private static final int WAIT_TIME = 200;
    private boolean shouldContinue = false;
    private boolean fetchAbstract = false;
    private boolean acmOrGuide = false;
    private static final Pattern hitsPattern = Pattern.compile(".*Found <b>(\\d+,*\\d*)</b>.*");
    private static final Pattern maxHitsPattern = Pattern.compile(".*Results \\d+ - \\d+ of (\\d+,*\\d*).*");
    private static final Pattern fullCitationPattern = Pattern.compile("<A HREF=\"(citation.cfm.*)\" class.*");
    private static final Pattern idPattern = Pattern.compile("citation.cfm\\?id=\\d*\\.?(\\d+)&.*");
    private static final Pattern titlePattern = Pattern.compile("<A HREF=.*?\">([^<]*)</A>");
    private static final Pattern monthYearPattern = Pattern.compile("([A-Za-z]+ [0-9]{4})");
    private static final Pattern absPattern = Pattern.compile("<div .*?>(.*?)</div>");
    private int piv = 0;

    @Override
    public JPanel getOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.guideButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.acmButton);
        buttonGroup.add(this.guideButton);
        jPanel.add(this.absCheckBox);
        jPanel.add(this.acmButton);
        jPanel.add(this.guideButton);
        return jPanel;
    }

    @Override
    public boolean processQueryGetPreview(String string, FetcherPreviewDialog fetcherPreviewDialog, OutputPrinter outputPrinter) {
        this.terms = string;
        this.piv = 0;
        this.shouldContinue = true;
        boolean bl = false;
        boolean bl2 = false;
        this.acmOrGuide = this.acmButton.isSelected();
        this.fetchAbstract = this.absCheckBox.isSelected();
        int n = 1;
        String string2 = this.makeUrl(n);
        LinkedHashMap<String, JLabel> linkedHashMap = new LinkedHashMap<String, JLabel>();
        try {
            URL uRL = new URL(string2);
            String string3 = this.getResults(uRL);
            int n2 = this.getNumberOfHits(string3, "Found", hitsPattern);
            int n3 = string3.indexOf("Found");
            if (n3 >= 0 && (n3 = (string3 = string3.substring(n3 + 5)).indexOf("Found")) >= 0) {
                string3 = string3.substring(n3);
            }
            if (n2 == 0) {
                outputPrinter.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search ACM Portal"), 1);
                return false;
            }
            n2 = this.getNumberOfHits(string3, "Results", maxHitsPattern);
            for (int i = 0; i < n2; ++i) {
                this.parse(string3, 0, n, linkedHashMap);
                n += 20;
            }
            for (String string4 : linkedHashMap.keySet()) {
                fetcherPreviewDialog.addEntry(string4, linkedHashMap.get(string4));
            }
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (ConnectException connectException) {
            outputPrinter.showMessage(Globals.lang("Connection to ACM Portal failed"), Globals.lang("Search ACM Portal"), 0);
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang(iOException.getMessage()), Globals.lang("Search ACM Portal"), 0);
            iOException.printStackTrace();
        }
        return false;
    }

    @Override
    public void getEntries(Map<String, Boolean> map, ImportInspector importInspector) {
        for (String string : map.keySet()) {
            String string2;
            BibtexEntry bibtexEntry;
            if (!this.shouldContinue) break;
            boolean bl = map.get(string);
            if (!bl || (bibtexEntry = this.downloadEntryBibTeX(string, this.fetchAbstract)) == null) continue;
            String string3 = bibtexEntry.getField("title");
            if (string3 != null) {
                string3 = string3.replaceAll("\\\\&", "&").replaceAll("\\\\#", "#");
                string3 = this.convertHTMLChars(string3);
                if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                    string3 = this.unitFormatter.format(string3);
                }
                if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                    string3 = this.caseKeeper.format(string3);
                }
                bibtexEntry.setField("title", string3);
            }
            if ((string2 = bibtexEntry.getField("abstract")) != null) {
                string2 = this.convertHTMLChars(string2);
                bibtexEntry.setField("abstract", string2);
            }
            importInspector.addEntry(bibtexEntry);
        }
    }

    @Override
    public int getWarningLimit() {
        return 10;
    }

    @Override
    public int getPreferredPreviewHeight() {
        return 75;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        return false;
    }

    private String makeUrl(int n) {
        StringBuilder stringBuilder = new StringBuilder(startUrl).append(searchUrlPart);
        stringBuilder.append(this.terms.replaceAll(" ", "%20"));
        stringBuilder.append("&start=").append(String.valueOf(n));
        stringBuilder.append(searchUrlPartII);
        if (this.acmOrGuide) {
            stringBuilder.append("ACM");
        } else {
            stringBuilder.append("GUIDE");
        }
        stringBuilder.append(endUrl);
        return stringBuilder.toString();
    }

    private void parse(String string, int n, int n2, Map<String, JLabel> map) {
        this.piv = n;
        int n3 = n2;
        while (this.getNextEntryURL(string, this.piv, n3, map)) {
            ++n3;
        }
    }

    private String getEntryBibTeXURL(String string, boolean bl) {
        Matcher matcher = idPattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        System.out.println("Did not find ID in: " + string);
        return null;
    }

    private boolean getNextEntryURL(String string, int n, int n2, Map<String, JLabel> map) {
        String string2 = "<strong>" + n2 + "</strong><br>";
        int n3 = string.indexOf(string2, n);
        int n4 = string.length();
        if (n3 >= 0) {
            this.piv = n3 + 1;
            String string3 = string.substring(n3, n4);
            Matcher matcher = fullCitationPattern.matcher(string3);
            if (matcher.find()) {
                String string4;
                Serializable serializable;
                String string5 = this.getEntryBibTeXURL(matcher.group(1), this.fetchAbstract);
                int n5 = string3.indexOf("<div class=\"abstract2\">");
                if (n5 > 0) {
                    Matcher matcher2;
                    Matcher matcher3;
                    int n6;
                    serializable = new StringBuilder();
                    string4 = string3.substring(0, n5);
                    try {
                        this.save("part" + n2 + ".html", string4);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    String string6 = "<div class=\"authors\">";
                    int n7 = string3.indexOf(string6);
                    if (n7 >= 0 && (n6 = string3.indexOf("</div>", n7 + string6.length())) >= 0) {
                        ((StringBuilder)serializable).append("<p>").append(string3.substring(n7, n6)).append("</p>");
                    }
                    if ((matcher3 = titlePattern.matcher(string4)).find()) {
                        ((StringBuilder)serializable).append("<p>").append(matcher3.group(1)).append("</p>");
                    }
                    if ((matcher2 = monthYearPattern.matcher(string4)).find()) {
                        ((StringBuilder)serializable).append("<p>").append(matcher2.group(1)).append("</p>");
                    }
                    string4 = ((StringBuilder)serializable).toString();
                } else {
                    string4 = string5;
                }
                serializable = new JLabel("<html>" + string4 + "</html>");
                ((JComponent)serializable).setPreferredSize(new Dimension(750, 100));
                map.put(string5, (JLabel)serializable);
                return true;
            }
            System.out.printf("Citation Unmatched %d%n", n2);
            System.out.printf(string3, new Object[0]);
            return false;
        }
        return false;
    }

    private BibtexEntry downloadEntryBibTeX(String string, boolean bl) {
        try {
            URL uRL = new URL("http://portal.acm.org/exportformats.cfm?id=" + string + bibtexUrlEnd);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            ParserResult parserResult = BibtexParser.parse(bufferedReader);
            bufferedReader.close();
            Collection<BibtexEntry> collection = parserResult.getDatabase().getEntries();
            if (collection.isEmpty()) {
                return null;
            }
            BibtexEntry bibtexEntry = collection.iterator().next();
            Thread.sleep(200L);
            if (bl) {
                uRL = new URL("http://portal.acm.org/tab_abstract.cfm?id=" + string);
                String string2 = this.getResults(uRL);
                Matcher matcher = absPattern.matcher(string2);
                if (matcher.find()) {
                    bibtexEntry.setField("abstract", matcher.group(1).trim());
                }
                Thread.sleep(200L);
            }
            return bibtexEntry;
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Bad Bibtex record read at: exportformats.cfm?id=" + string + bibtexUrlEnd);
            noSuchElementException.printStackTrace();
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private String convertHTMLChars(String string) {
        return this.htmlConverter.format(string);
    }

    private int getNumberOfHits(String string, String string2, Pattern pattern) throws IOException {
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String string3 = string.substring(n, Math.min(n + 42, string.length()));
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find()) {
            try {
                String string4 = matcher.group(1);
                string4 = string4.replaceAll(",", "");
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
            catch (IllegalStateException illegalStateException) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
        }
        System.out.println("Unmatched!");
        System.out.println(string3);
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    private String getResults(URL uRL) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String getResultsFromFile(File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[256];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getTitle() {
        return "ACM Portal";
    }

    @Override
    public String getHelpPage() {
        return "ACMPortalHelp.html";
    }

    @Override
    public String getKeyName() {
        return "ACM Portal";
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int n) {
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    private void save(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        bufferedWriter.write(string2);
        bufferedWriter.close();
    }
}

