/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.AbstractButtonPanelBuilder;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class MergeEntriesDialog
extends JDialog {
    private final String[] columnHeadings = new String[]{Globals.lang("Field"), Globals.lang("First entry"), Globals.lang("Use 1st"), Globals.lang("None"), Globals.lang("Use 2nd"), Globals.lang("Second entry")};
    private final Dimension DIM = new Dimension(800, 800);
    private PreviewPanel preview;
    private final BasePanel panel;
    private final JabRefFrame frame;
    private JRadioButton[][] rb;
    private Boolean[] identical;
    private final CellConstraints cc = new CellConstraints();
    private final BibtexEntry mergedEntry = new BibtexEntry();
    private BibtexEntry one;
    private BibtexEntry two;
    private JTextArea jta;
    private PreviewPanel pp;
    private Boolean doneBuilding = false;
    private Set<String> joint;
    private String[] jointStrings;
    private NamedCompound ce;

    public MergeEntriesDialog(BasePanel basePanel) {
        super(basePanel.frame(), Globals.lang("Merge entries"), true);
        this.panel = basePanel;
        this.frame = basePanel.frame();
        this.init(basePanel.getSelectedEntries());
        Util.placeDialog(this, this.frame);
    }

    private void init(BibtexEntry[] bibtexEntryArray) {
        JComponent jComponent;
        JComponent i;
        Object iOException;
        Object object;
        Serializable serializable;
        Object object4;
        String string22;
        if (bibtexEntryArray.length != 2) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("You have to choose exactly two entries to merge."), Globals.lang("Merge entries"), 1);
            this.dispose();
            return;
        }
        this.one = bibtexEntryArray[0];
        this.two = bibtexEntryArray[1];
        this.ce = new NamedCompound(Globals.lang("Merge entries"));
        this.joint = new TreeSet<String>(this.one.getAllFields());
        this.joint.addAll(this.two.getAllFields());
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string22 : this.joint) {
            if (!string22.startsWith("__")) continue;
            treeSet.add(string22);
        }
        for (String string22 : treeSet) {
            this.joint.remove(string22);
        }
        this.rb = new JRadioButton[3][this.joint.size() + 1];
        Iterator<String> iterator = new ButtonGroup[this.joint.size() + 1];
        this.identical = new Boolean[this.joint.size() + 1];
        this.jointStrings = new String[this.joint.size()];
        string22 = "left:pref, 5px, fill:4cm:grow, 5px, right:pref, 3px, center:pref, 3px, left:pref, 5px, fill:4cm:grow";
        StringBuilder stringBuilder = new StringBuilder("pref, 10px, pref, ");
        for (int i2 = 0; i2 < this.joint.size(); ++i2) {
            stringBuilder.append("pref, ");
        }
        stringBuilder.append("10px, top:4cm:grow, 10px, pref");
        FormLayout formLayout = new FormLayout(string22, stringBuilder.toString());
        this.setLayout(formLayout);
        for (int i3 = 0; i3 < 6; ++i3) {
            object4 = new JLabel(this.columnHeadings[i3]);
            serializable = ((Component)object4).getFont();
            ((JComponent)object4).setFont(((Font)serializable).deriveFont(((Font)serializable).getStyle() | 1));
            this.add((Component)object4, this.cc.xy(1 + i3 * 2, 1));
        }
        this.add((Component)new JSeparator(), this.cc.xyw(1, 2, 11));
        BibtexEntryType bibtexEntryType = this.one.getType();
        object4 = this.two.getType();
        this.mergedEntry.setType(bibtexEntryType);
        serializable = new JLabel(Globals.lang("Entry type"));
        Font font = ((Component)serializable).getFont();
        ((JComponent)serializable).setFont(font.deriveFont(font.getStyle() | 1));
        this.add((Component)serializable, this.cc.xy(1, 3));
        JTextArea jTextArea = new JTextArea(bibtexEntryType.getName());
        jTextArea.setEditable(false);
        this.add((Component)jTextArea, this.cc.xy(3, 3));
        if (bibtexEntryType.compareTo((BibtexEntryType)object4) != 0) {
            this.identical[0] = false;
            iterator[0] = new ButtonGroup();
            for (int i4 = 0; i4 < 3; i4 += 2) {
                this.rb[i4][0] = new JRadioButton();
                ((ButtonGroup)((Object)iterator[0])).add(this.rb[i4][0]);
                this.add((Component)this.rb[i4][0], this.cc.xy(5 + i4 * 2, 3));
                this.rb[i4][0].addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        MergeEntriesDialog.this.updateAll();
                    }
                });
            }
            this.rb[0][0].setSelected(true);
        } else {
            this.identical[0] = true;
        }
        JTextArea jTextArea2 = new JTextArea(((BibtexEntryType)object4).getName());
        jTextArea2.setEditable(false);
        this.add((Component)jTextArea2, this.cc.xy(11, 3));
        int n = 4;
        Object string3 = this.joint.iterator();
        while (string3.hasNext()) {
            String object32;
            this.jointStrings[n - 4] = object32 = string3.next();
            serializable = new JLabel(StringUtil.toUpperFirstLetter(object32));
            font = ((Component)serializable).getFont();
            ((JComponent)serializable).setFont(font.deriveFont(font.getStyle() | 1));
            this.add((Component)serializable, this.cc.xy(1, n));
            object = this.one.getField(object32);
            iOException = this.two.getField(object32);
            this.identical[n - 3] = false;
            if (object != null && iOException != null && ((String)object).equals(iOException)) {
                this.identical[n - 3] = true;
            }
            if (object32.equals("abstract")) {
                i = new JTextArea();
                ((JTextArea)i).setLineWrap(true);
                ((JTextComponent)i).setEditable(false);
                jComponent = new JScrollPane(i);
                formLayout.setRowSpec(n, RowSpec.decode("center:2cm:grow"));
                this.add((Component)jComponent, this.cc.xy(3, n, "f, f"));
                ((JTextComponent)i).setText((String)object);
                ((JTextComponent)i).setCaretPosition(0);
            } else {
                i = new JTextArea((String)object);
                this.add((Component)i, this.cc.xy(3, n));
                ((JTextComponent)i).setCaretPosition(0);
                ((JTextComponent)i).setEditable(false);
            }
            if (!this.identical[n - 3].booleanValue()) {
                iterator[n - 3] = new ButtonGroup();
                for (int j = 0; j < 3; ++j) {
                    this.rb[j][n - 3] = new JRadioButton();
                    ((ButtonGroup)((Object)iterator[n - 3])).add(this.rb[j][n - 3]);
                    this.add((Component)this.rb[j][n - 3], this.cc.xy(5 + j * 2, n));
                    this.rb[j][n - 3].addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            MergeEntriesDialog.this.updateAll();
                        }
                    });
                }
                if (object != null) {
                    this.mergedEntry.setField(object32, (String)object);
                    this.rb[0][n - 3].setSelected(true);
                } else {
                    this.mergedEntry.setField(object32, (String)iOException);
                    this.rb[2][n - 3].setSelected(true);
                }
            } else {
                this.mergedEntry.setField(object32, (String)object);
            }
            if (object32.equals("abstract")) {
                i = new JTextArea();
                ((JTextArea)i).setLineWrap(true);
                ((JTextComponent)i).setEditable(false);
                jComponent = new JScrollPane(i);
                this.add((Component)jComponent, this.cc.xy(11, n, "f, f"));
                ((JTextComponent)i).setText((String)iOException);
                ((JTextComponent)i).setCaretPosition(0);
            } else {
                i = new JTextArea((String)iOException);
                this.add((Component)i, this.cc.xy(11, n));
                ((JTextComponent)i).setCaretPosition(0);
                ((JTextComponent)i).setEditable(false);
            }
            ++n;
        }
        this.add((Component)new JSeparator(), this.cc.xyw(1, n, 11));
        serializable = new JLabel(Globals.lang("Merged entry"));
        font = ((Component)serializable).getFont();
        ((JComponent)serializable).setFont(font.deriveFont(font.getStyle() | 1));
        this.add((Component)serializable, this.cc.xy(1, ++n));
        string3 = Globals.prefs.get("preview0");
        this.pp = new PreviewPanel(null, this.mergedEntry, null, new MetaData(), (String)string3);
        this.add((Component)this.pp, this.cc.xyw(3, n, 3));
        this.jta = new JTextArea();
        this.jta.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.jta);
        this.add((Component)jScrollPane, this.cc.xyw(9, n, 3));
        this.jta.setEditable(false);
        object = new StringWriter();
        try {
            this.mergedEntry.write((Writer)object, new LatexFieldFormatter(), false);
        }
        catch (IOException iOException2) {
            System.err.println(Globals.lang("Error in entry: " + iOException2.getMessage()));
        }
        this.jta.setText(((StringWriter)object).getBuffer().toString());
        this.jta.setCaretPosition(0);
        this.add((Component)new JSeparator(), this.cc.xyw(1, ++n, 11));
        ++n;
        iOException = new ButtonBarBuilder();
        ((ButtonBarBuilder)iOException).addGlue();
        i = new JButton(Globals.lang("Cancel"));
        ((AbstractButton)i).setActionCommand("cancel");
        ((AbstractButton)i).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MergeEntriesDialog.this.buttonPressed(actionEvent.getActionCommand());
            }
        });
        jComponent = new JButton(Globals.lang("Add new entry and keep both old entries"));
        ((AbstractButton)jComponent).setActionCommand("newentry");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MergeEntriesDialog.this.buttonPressed(actionEvent.getActionCommand());
            }
        });
        JButton jButton = new JButton(Globals.lang("Replace old entries with new entry"));
        jButton.setActionCommand("replace");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MergeEntriesDialog.this.buttonPressed(actionEvent.getActionCommand());
            }
        });
        ((ButtonBarBuilder)iOException).addButton(jButton, jComponent, i);
        this.add((Component)((AbstractButtonPanelBuilder)iOException).getPanel(), this.cc.xyw(1, n, 11));
        formLayout.appendRow(RowSpec.decode("10px"));
        formLayout.appendColumn(ColumnSpec.decode("10px"));
        formLayout.insertRow(1, RowSpec.decode("10px"));
        formLayout.insertColumn(1, ColumnSpec.decode("10px"));
        this.pack();
        if (this.getHeight() > this.DIM.height) {
            this.setSize(new Dimension(this.getWidth(), this.DIM.height));
        }
        if (this.getWidth() > this.DIM.width) {
            this.setSize(new Dimension(this.DIM.width, this.getHeight()));
        }
        this.doneBuilding = true;
        this.setVisible(true);
    }

    private void buttonPressed(String string) {
        if (string.equals("cancel")) {
            this.panel.output(Globals.lang("Cancelled merging entries"));
            this.dispose();
        } else if (string.equals("newentry")) {
            this.panel.insertEntry(this.mergedEntry);
            this.ce.addEdit(new UndoableInsertEntry(this.panel.database(), this.mergedEntry, this.panel));
            this.ce.end();
            this.panel.undoManager.addEdit(this.ce);
            this.panel.output(Globals.lang("Merged entries into a new and kept the old"));
            this.dispose();
        } else if (string.equals("replace")) {
            this.panel.insertEntry(this.mergedEntry);
            this.ce.addEdit(new UndoableInsertEntry(this.panel.database(), this.mergedEntry, this.panel));
            this.ce.addEdit(new UndoableRemoveEntry(this.panel.database(), this.one, this.panel));
            this.panel.database().removeEntry(this.one.getId());
            this.ce.addEdit(new UndoableRemoveEntry(this.panel.database(), this.two, this.panel));
            this.panel.database().removeEntry(this.two.getId());
            this.ce.end();
            this.panel.undoManager.addEdit(this.ce);
            this.panel.output(Globals.lang("Merged entries into a new and removed the old"));
            this.dispose();
        }
    }

    private void updateAll() {
        if (!this.doneBuilding.booleanValue()) {
            return;
        }
        if (!this.identical[0].booleanValue()) {
            if (this.rb[0][0].isSelected()) {
                this.mergedEntry.setType(this.one.getType());
            } else {
                this.mergedEntry.setType(this.two.getType());
            }
        }
        for (int i = 0; i < this.joint.size(); ++i) {
            if (this.identical[i + 1].booleanValue()) continue;
            if (this.rb[0][i + 1].isSelected()) {
                this.mergedEntry.setField(this.jointStrings[i], this.one.getField(this.jointStrings[i]));
                continue;
            }
            if (this.rb[2][i + 1].isSelected()) {
                this.mergedEntry.setField(this.jointStrings[i], this.two.getField(this.jointStrings[i]));
                continue;
            }
            this.mergedEntry.setField(this.jointStrings[i], null);
        }
        this.pp.setEntry(this.mergedEntry);
        StringWriter stringWriter = new StringWriter();
        try {
            this.mergedEntry.write(stringWriter, new LatexFieldFormatter(), false);
        }
        catch (IOException iOException) {
            System.err.println(Globals.lang("Error in entry: " + iOException.getMessage()));
        }
        this.jta.setText(stringWriter.getBuffer().toString());
        this.jta.setCaretPosition(0);
    }
}

