/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldValue;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainTableSelectionListener
implements ListEventListener<BibtexEntry>,
MouseListener,
KeyListener,
FocusListener {
    private PreviewPanel[] previewPanel = null;
    private int activePreview = Globals.prefs.getInt("activePreview");
    private PreviewPanel preview;
    private final MainTable table;
    private final BasePanel panel;
    private final EventList<BibtexEntry> tableRows;
    private boolean previewActive = Globals.prefs.getBoolean("previewEnabled");
    private boolean workingOnPreview = false;
    private boolean enabled = true;
    private final int[] lastPressed = new int[20];
    private int lastPressedCount = 0;
    private long lastPressedTime = 0L;
    private static final Log LOGGER = LogFactory.getLog(MainTableSelectionListener.class);

    public MainTableSelectionListener(BasePanel basePanel, MainTable mainTable) {
        this.table = mainTable;
        this.panel = basePanel;
        this.tableRows = mainTable.getTableRows();
        this.instantiatePreviews();
        this.preview = this.previewPanel[this.activePreview];
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private void instantiatePreviews() {
        this.previewPanel = new PreviewPanel[]{new PreviewPanel(this.panel.database(), null, this.panel, this.panel.metaData(), Globals.prefs.get("preview0"), true), new PreviewPanel(this.panel.database(), null, this.panel, this.panel.metaData(), Globals.prefs.get("preview1"), true)};
        this.panel.frame().getSearchManager().addSearchListener(this.previewPanel[0]);
        this.panel.frame().getSearchManager().addSearchListener(this.previewPanel[1]);
    }

    public void updatePreviews() {
        try {
            this.previewPanel[0].readLayout(Globals.prefs.get("preview0"));
            this.previewPanel[1].readLayout(Globals.prefs.get("preview1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void listChanged(ListEvent<BibtexEntry> listEvent) {
        if (!this.enabled) {
            return;
        }
        EventList<BibtexEntry> eventList = listEvent.getSourceList();
        Object var3_3 = null;
        while (listEvent.next()) {
            if (listEvent.getType() != 2) continue;
            if (var3_3 != null) {
                return;
            }
            if (listEvent.getIndex() >= eventList.size()) continue;
            var3_3 = eventList.get(listEvent.getIndex());
        }
        if (var3_3 != null) {
            BibtexEntry bibtexEntry = var3_3;
            int n = this.panel.getMode();
            if (n == 3 || n == 2) {
                EntryEditor entryEditor = this.panel.getCurrentEditor();
                String string = null;
                if (entryEditor != null) {
                    string = entryEditor.getVisiblePanelName();
                }
                EntryEditor entryEditor2 = this.panel.getEntryEditor(bibtexEntry);
                if (entryEditor != null) {
                    entryEditor.setMovingToDifferentEntry();
                }
                if (entryEditor2 != entryEditor || n != 2) {
                    if (string != null) {
                        entryEditor2.setVisiblePanel(string);
                    }
                    this.panel.showEntryEditor(entryEditor2);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainTableSelectionListener.this.table.ensureVisible(MainTableSelectionListener.this.table.getSelectedRow());
                        }
                    });
                }
            } else if (this.previewActive) {
                this.updatePreview(bibtexEntry, false);
            }
        }
    }

    private void updatePreview(BibtexEntry bibtexEntry, boolean bl) {
        this.updatePreview(bibtexEntry, bl, 0);
    }

    private void updatePreview(final BibtexEntry bibtexEntry, final boolean bl, int n) {
        if (this.workingOnPreview) {
            if (n > 0) {
                return;
            }
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainTableSelectionListener.this.updatePreview(bibtexEntry, bl, 1);
                }
            });
            timer.setRepeats(false);
            timer.start();
            return;
        }
        EventList<BibtexEntry> eventList = this.table.getSelected();
        if (eventList.size() != 1 || eventList.get(0) != bibtexEntry) {
            return;
        }
        final int n2 = this.panel.getMode();
        this.workingOnPreview = true;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (bl || n2 == 0) {
                    MainTableSelectionListener.this.panel.showPreview(MainTableSelectionListener.this.preview);
                    MainTableSelectionListener.this.panel.adjustSplitter();
                }
                MainTableSelectionListener.this.workingOnPreview = false;
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                MainTableSelectionListener.this.preview.setEntry(bibtexEntry);
                SwingUtilities.invokeLater(runnable);
            }
        };
        JabRefExecutorService.INSTANCE.execute(runnable2);
    }

    public void editSignalled() {
        if (this.table.getSelected().size() == 1) {
            this.editSignalled((BibtexEntry)this.table.getSelected().get(0));
        }
    }

    public void editSignalled(BibtexEntry bibtexEntry) {
        int n = this.panel.getMode();
        EntryEditor entryEditor = this.panel.getEntryEditor(bibtexEntry);
        if (n != 2) {
            this.panel.showEntryEditor(entryEditor);
            this.panel.adjustSplitter();
        }
        new FocusRequester(entryEditor);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.table.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
        String[] stringArray = this.table.getIconTypeForColumn(n);
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
            if (stringArray == null) {
                this.processPopupTrigger(mouseEvent, n2);
            } else {
                this.showIconRightClickMenu(mouseEvent, n2, stringArray);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n = this.table.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
        if (mouseEvent.getClickCount() == 2) {
            object = (BibtexEntry)this.tableRows.get(n2);
            this.editSignalled((BibtexEntry)object);
        }
        object = this.table.getIconTypeForColumn(n);
        if (Globals.ON_WIN && object != null && mouseEvent.getButton() != 1) {
            return;
        }
        if (object != null) {
            SpecialField specialField = SpecialFieldsUtils.getSpecialFieldInstanceFromFieldName(object[0]);
            if (mouseEvent.getClickCount() == 1 && specialField != null) {
                if (specialField.isSingleValueField()) {
                    specialField.getValues().get(0).getAction(this.panel.frame()).action();
                } else {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    for (SpecialFieldValue specialFieldValue : specialField.getValues()) {
                        jPopupMenu.add(specialFieldValue.getMenuAction(this.panel.frame()));
                    }
                    jPopupMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            Object object2 = this.table.getValueAt(n2, n);
            if (object2 == null) {
                return;
            }
            final BibtexEntry bibtexEntry = (BibtexEntry)this.tableRows.get(n2);
            int n3 = -1;
            for (int i = ((String[])object).length - 1; i >= 0; --i) {
                if (bibtexEntry.getField(object[i]) == null) continue;
                n3 = i;
            }
            if (n3 == -1) {
                return;
            }
            final String string = object[n3];
            String[] stringArray = new String[]{};
            if (n3 == 0 && object[n3].equals("file") && ((String[])object).length > 1) {
                stringArray = object;
            }
            final List<String> list = Collections.unmodifiableList(Arrays.asList(stringArray));
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    MainTableSelectionListener.this.panel.output(Globals.lang("External viewer called") + '.');
                    String string3 = bibtexEntry.getField(string);
                    if (string3 == null) {
                        LOGGER.info("Error: no link to " + string + '.');
                        return;
                    }
                    if (string.equals("file")) {
                        ExternalFileMenuItem externalFileMenuItem;
                        boolean bl;
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        fileListTableModel.setContent(string3);
                        FileListEntry fileListEntry = null;
                        if (!list.isEmpty()) {
                            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                                fileListEntry = fileListTableModel.getEntry(i);
                                bl = false;
                                for (String string2 : list) {
                                    if (!fileListEntry.getType().toString().equals(string2)) continue;
                                    bl = true;
                                }
                                if (!bl) {
                                    fileListEntry = null;
                                    continue;
                                }
                                break;
                            }
                        } else if (fileListTableModel.getRowCount() > 0) {
                            fileListEntry = fileListTableModel.getEntry(0);
                        }
                        if (fileListEntry != null && !(bl = (externalFileMenuItem = new ExternalFileMenuItem(MainTableSelectionListener.this.panel.frame(), bibtexEntry, "", fileListEntry.getLink(), (Icon)fileListEntry.getType().getIcon(), MainTableSelectionListener.this.panel.metaData(), fileListEntry.getType())).openLink())) {
                            MainTableSelectionListener.this.panel.output(Globals.lang("Unable to open link."));
                        }
                    } else {
                        try {
                            Util.openExternalViewer(MainTableSelectionListener.this.panel.metaData(), string3, string);
                        }
                        catch (IOException iOException) {
                            MainTableSelectionListener.this.panel.output(Globals.lang("Unable to open link."));
                        }
                    }
                }
            });
        }
    }

    private void processPopupTrigger(MouseEvent mouseEvent, int n) {
        int n2 = this.table.getSelectedRow();
        if (n2 == -1 || !this.table.isRowSelected(this.table.rowAtPoint(mouseEvent.getPoint()))) {
            this.table.setRowSelectionInterval(n, n);
        }
        RightClickMenu rightClickMenu = new RightClickMenu(this.panel, this.panel.metaData());
        rightClickMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
    }

    private void showIconRightClickMenu(MouseEvent mouseEvent, int n, String[] stringArray) {
        BibtexEntry bibtexEntry = (BibtexEntry)this.tableRows.get(n);
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = true;
        if (stringArray[0].equals("file")) {
            String string = bibtexEntry.getField(stringArray[0]);
            FileListTableModel fileListTableModel = new FileListTableModel();
            fileListTableModel.setContent(string);
            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                String string2;
                FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                if (stringArray.length > 1) {
                    boolean bl2 = false;
                    for (int j = 1; j < stringArray.length; ++j) {
                        if (!fileListEntry.getType().toString().equals(stringArray[j])) continue;
                        bl2 = true;
                    }
                    if (!bl2) continue;
                }
                if ((string2 = fileListEntry.getDescription()) == null || string2.trim().isEmpty()) {
                    string2 = fileListEntry.getLink();
                }
                jPopupMenu.add(new ExternalFileMenuItem(this.panel.frame(), bibtexEntry, string2, fileListEntry.getLink(), (Icon)fileListEntry.getType().getIcon(), this.panel.metaData(), fileListEntry.getType()));
                bl = false;
            }
        } else {
            SpecialField specialField = SpecialFieldsUtils.getSpecialFieldInstanceFromFieldName(stringArray[0]);
            if (specialField != null) {
                bl = true;
            } else {
                for (String string : stringArray) {
                    String string3 = bibtexEntry.getField(string);
                    if (string3 == null) continue;
                    jPopupMenu.add(new ExternalFileMenuItem(this.panel.frame(), bibtexEntry, string3, string3, GUIGlobals.getTableIcon(string).getIcon(), this.panel.metaData(), string));
                    bl = false;
                }
            }
        }
        if (bl) {
            this.processPopupTrigger(mouseEvent, n);
        } else {
            jPopupMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void entryEditorClosing(EntryEditor entryEditor) {
        this.preview.setEntry(entryEditor.getEntry());
        if (this.previewActive) {
            this.panel.showPreview(this.preview);
        } else {
            this.panel.hideBottomComponent();
        }
        this.panel.adjustSplitter();
        new FocusRequester(this.table);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setPreviewActive(boolean bl) {
        this.previewActive = bl;
        if (!this.previewActive) {
            this.panel.hideBottomComponent();
        } else if (!this.table.getSelected().isEmpty()) {
            this.updatePreview((BibtexEntry)this.table.getSelected().get(0), false);
        }
    }

    public void switchPreview() {
        this.activePreview = this.activePreview < this.previewPanel.length - 1 ? ++this.activePreview : 0;
        Globals.prefs.putInt("activePreview", this.activePreview);
        if (this.previewActive) {
            this.preview = this.previewPanel[this.activePreview];
            if (!this.table.getSelected().isEmpty()) {
                this.updatePreview((BibtexEntry)this.table.getSelected().get(0), true);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!keyEvent.isActionKey() && Character.isLetterOrDigit(keyEvent.getKeyChar()) && keyEvent.getModifiers() == 0) {
            int n;
            long l;
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastPressedTime > (l = 2000L)) {
                this.lastPressedCount = 0;
            }
            this.lastPressedTime = l2;
            char c = keyEvent.getKeyChar();
            if (this.lastPressedCount < this.lastPressed.length) {
                this.lastPressed[this.lastPressedCount] = c;
                ++this.lastPressedCount;
            }
            if ((n = this.table.getSortingColumn(0)) == -1) {
                return;
            }
            int n2 = 0;
            boolean bl = false;
            while (!bl) {
                for (int i = n2; i < this.table.getRowCount(); ++i) {
                    String string;
                    Object object = this.table.getValueAt(i, n);
                    if (object == null || (string = object.toString().toLowerCase()).length() < this.lastPressedCount) continue;
                    for (int j = 0; j < this.lastPressedCount && string.charAt(j) == this.lastPressed[j]; ++j) {
                        if (j != this.lastPressedCount - 1) continue;
                        this.table.setRowSelectionInterval(i, i);
                        this.table.ensureVisible(i);
                        return;
                    }
                }
                if (n2 > 0) {
                    n2 = 0;
                    continue;
                }
                bl = true;
            }
        } else if (keyEvent.getKeyChar() == '\u001b') {
            this.lastPressedCount = 0;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.lastPressedCount = 0;
    }
}

