/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.builder.AbstractButtonPanelBuilder;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class ImportInspectionDialog
extends JDialog
implements ImportInspector,
OutputPrinter {
    protected ImportInspectionDialog ths = this;
    private BasePanel panel;
    private final JabRefFrame frame;
    private final MetaData metaData;
    private final JSplitPane contentPane = new JSplitPane(0);
    private final JTable glTable;
    private final TableComparatorChooser<BibtexEntry> comparatorChooser;
    private final EventSelectionModel<BibtexEntry> selectionModel;
    private final String[] fields;
    private final JProgressBar progressBar = new JProgressBar(0);
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton generate = new JButton(Globals.lang("Generate now"));
    private final EventList<BibtexEntry> entries = new BasicEventList<BibtexEntry>();
    private final SortedList<BibtexEntry> sortedList;
    private final List<BibtexEntry> entriesToDelete = new ArrayList<BibtexEntry>();
    private final String undoName;
    private final ArrayList<CallBack> callBacks = new ArrayList();
    private final boolean newDatabase;
    private final JPopupMenu popup = new JPopupMenu();
    private final JButton deselectAllDuplicates = new JButton(Globals.lang("Deselect all duplicates"));
    private final JButton stop = new JButton(Globals.lang("Stop"));
    private final PreviewPanel preview;
    private boolean generatedKeys = false;
    private boolean defaultSelected = true;
    private final Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private final Map<BibtexEntry, Set<GroupTreeNode>> groupAdditions = new HashMap<BibtexEntry, Set<GroupTreeNode>>();
    private final JCheckBox autoGenerate = new JCheckBox(Globals.lang("Generate keys"), Globals.prefs.getBoolean("generateKeysAfterInspection"));
    private final JLabel duplLabel = new JLabel(GUIGlobals.getImage("duplicate"));
    private final JLabel fileLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    private final JLabel pdfLabel = new JLabel(GUIGlobals.getImage("pdfSmall"));
    private final JLabel psLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    private final JLabel urlLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
    private final int DUPL_COL = 1;
    private final int FILE_COL = 2;
    private final int PDF_COL = -1;
    private final int PS_COL = -2;
    private final int URL_COL = 3;
    private final int PAD = 4;

    public void setDefaultSelected(boolean bl) {
        this.defaultSelected = bl;
    }

    public ImportInspectionDialog(JabRefFrame jabRefFrame, BasePanel basePanel, String[] stringArray, String string, boolean bl) {
        AbstractButton abstractButton;
        Object object;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.metaData = basePanel != null ? basePanel.metaData() : new MetaData();
        this.fields = stringArray;
        this.undoName = string;
        this.newDatabase = bl;
        this.preview = new PreviewPanel(null, this.metaData, Globals.prefs.get("preview0"));
        this.duplLabel.setToolTipText(Globals.lang("Possible duplicate of existing entry. Click to resolve."));
        this.sortedList = new SortedList<BibtexEntry>(this.entries);
        EventTableModel<BibtexEntry> eventTableModel = new EventTableModel<BibtexEntry>(this.sortedList, new EntryTableFormat());
        this.glTable = new EntryTable(eventTableModel);
        GeneralRenderer generalRenderer = new GeneralRenderer(Color.white);
        this.glTable.setDefaultRenderer(JLabel.class, generalRenderer);
        this.glTable.setDefaultRenderer(String.class, generalRenderer);
        this.glTable.getInputMap().put(Globals.prefs.getKey("Delete"), "delete");
        DeleteListener deleteListener = new DeleteListener();
        this.glTable.getActionMap().put("delete", deleteListener);
        this.selectionModel = new EventSelectionModel<BibtexEntry>(this.sortedList);
        this.glTable.setSelectionModel(this.selectionModel);
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.comparatorChooser = TableComparatorChooser.install(this.glTable, this.sortedList, AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser();
        this.glTable.addMouseListener(new TableClickListener());
        this.setWidths();
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.contentPane.setTopComponent(new JScrollPane(this.glTable));
        this.contentPane.setBottomComponent(this.preview);
        jPanel.add((Component)this.contentPane, "Center");
        jPanel.add((Component)this.progressBar, "South");
        this.popup.add(deleteListener);
        this.popup.addSeparator();
        if (!bl) {
            object = this.metaData.getGroups();
            abstractButton = new JMenu(Globals.lang("Add to group"));
            ((JMenuItem)abstractButton).setEnabled(false);
            this.insertNodes((JMenu)abstractButton, (GroupTreeNode)object);
            this.popup.add((JMenuItem)abstractButton);
        }
        this.popup.add(new LinkLocalFile());
        this.popup.add(new DownloadFile());
        this.popup.add(new AutoSetLinks());
        this.popup.add(new AttachUrl());
        this.getContentPane().add((Component)jPanel, "Center");
        object = new ButtonBarBuilder();
        ((ButtonBarBuilder)object).addGlue();
        ((ButtonBarBuilder)object).addButton((JComponent)this.ok);
        ((ButtonBarBuilder)object).addButton((JComponent)this.stop);
        abstractButton = new JButton(Globals.lang("Cancel"));
        ((ButtonBarBuilder)object).addButton((JComponent)abstractButton);
        ((ButtonBarBuilder)object).addRelatedGap();
        JButton jButton = new JButton(Globals.lang("Help"));
        ((ButtonBarBuilder)object).addButton((JComponent)jButton);
        ((ButtonBarBuilder)object).addGlue();
        ((AbstractButtonPanelBuilder)object).getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        JButton jButton2 = new JButton(Globals.lang("Select all"));
        buttonStackBuilder.addButton((JComponent)jButton2);
        JButton jButton3 = new JButton(Globals.lang("Deselect all"));
        buttonStackBuilder.addButton((JComponent)jButton3);
        buttonStackBuilder.addButton((JComponent)this.deselectAllDuplicates);
        buttonStackBuilder.addRelatedGap();
        JButton jButton4 = new JButton(Globals.lang("Delete"));
        buttonStackBuilder.addButton((JComponent)jButton4);
        buttonStackBuilder.addRelatedGap();
        buttonStackBuilder.addFixed(this.autoGenerate);
        buttonStackBuilder.addButton((JComponent)this.generate);
        buttonStackBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)buttonStackBuilder.getPanel(), "West");
        this.ok.setEnabled(false);
        this.generate.setEnabled(false);
        this.ok.addActionListener(new OkListener());
        abstractButton.addActionListener(new CancelListener());
        this.generate.addActionListener(new GenerateListener());
        this.stop.addActionListener(new StopListener());
        jButton2.addActionListener(new SelectionButton(true));
        jButton3.addActionListener(new SelectionButton(false));
        this.deselectAllDuplicates.addActionListener(new DeselectDuplicatesButtonListener());
        this.deselectAllDuplicates.setEnabled(false);
        jButton4.addActionListener(deleteListener);
        jButton.addActionListener(new HelpAction(jabRefFrame.helpDiag, "ImportInspectionDialog.html"));
        this.getContentPane().add((Component)((AbstractButtonPanelBuilder)object).getPanel(), "South");
        this.setSize(new Dimension(Globals.prefs.getInt("importInspectionDialogWidth"), Globals.prefs.getInt("importInspectionDialogHeight")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Globals.prefs.putInt("importInspectionDialogWidth", ImportInspectionDialog.this.getSize().width);
                Globals.prefs.putInt("importInspectionDialogHeight", ImportInspectionDialog.this.getSize().height);
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportInspectionDialog.this.dispose();
            }
        };
        ActionMap actionMap = this.contentPane.getActionMap();
        InputMap inputMap = this.contentPane.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
    }

    @Override
    public void setProgress(int n, int n2) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
    }

    @Override
    public void addEntry(BibtexEntry bibtexEntry) {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.add(bibtexEntry);
        this.addEntries(arrayList);
    }

    public void addEntries(Collection<BibtexEntry> collection) {
        for (BibtexEntry bibtexEntry : collection) {
            bibtexEntry.setSearchHit(this.defaultSelected);
            if (this.panel != null && DuplicateCheck.containsDuplicate(this.panel.database(), bibtexEntry) != null || this.internalDuplicate(this.entries, bibtexEntry) != null) {
                bibtexEntry.setGroupHit(true);
                this.deselectAllDuplicates.setEnabled(true);
            }
            this.entries.getReadWriteLock().writeLock().lock();
            this.entries.add(bibtexEntry);
            this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    private BibtexEntry internalDuplicate(Collection<BibtexEntry> collection, BibtexEntry bibtexEntry) {
        for (BibtexEntry bibtexEntry2 : collection) {
            if (bibtexEntry2 == bibtexEntry || !DuplicateCheck.isDuplicate(bibtexEntry, bibtexEntry2)) continue;
            return bibtexEntry2;
        }
        return null;
    }

    private void removeSelectedEntries() {
        int n = this.glTable.getSelectedRow();
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.addAll(this.selectionModel.getSelected());
        this.entries.getReadWriteLock().writeLock().lock();
        for (Object e : arrayList) {
            this.entries.remove(e);
        }
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.clearSelection();
        if (n >= 0 && !this.entries.isEmpty()) {
            n = Math.min(this.entries.size() - 1, n);
            this.glTable.addRowSelectionInterval(n, n);
        }
    }

    public void entryListComplete() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(false);
        this.ok.setEnabled(true);
        if (!this.generatedKeys) {
            this.generate.setEnabled(true);
        }
        this.stop.setEnabled(false);
        this.glTable.repaint();
        if (this.glTable.getSelectedRowCount() == 0 && this.glTable.getRowCount() > 0) {
            this.glTable.setRowSelectionInterval(0, 0);
        }
    }

    private List<BibtexEntry> getSelectedEntries() {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        for (BibtexEntry bibtexEntry : this.entries) {
            if (!bibtexEntry.isSearchHit()) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private void generateKeySelectedEntry() {
        MetaData metaData;
        BibtexDatabase bibtexDatabase;
        if (this.selectionModel.getSelected().size() != 1) {
            return;
        }
        BibtexEntry bibtexEntry = (BibtexEntry)this.selectionModel.getSelected().get(0);
        this.entries.getReadWriteLock().writeLock().lock();
        if (this.panel != null) {
            bibtexDatabase = this.panel.database();
            metaData = this.panel.metaData();
        } else {
            bibtexDatabase = new BibtexDatabase();
            metaData = new MetaData();
        }
        try {
            bibtexEntry.setId(IdGenerator.next());
            bibtexDatabase.insertEntry(bibtexEntry);
        }
        catch (KeyCollisionException keyCollisionException) {
            keyCollisionException.printStackTrace();
        }
        LabelPatternUtil.makeLabel(metaData, bibtexDatabase, bibtexEntry);
        bibtexDatabase.removeEntry(bibtexEntry.getId());
        this.entries.getReadWriteLock().writeLock().lock();
        this.glTable.repaint();
    }

    private void generateKeys(boolean bl) {
        MetaData metaData;
        BibtexDatabase bibtexDatabase;
        this.entries.getReadWriteLock().writeLock().lock();
        if (this.panel != null) {
            bibtexDatabase = this.panel.database();
            metaData = this.panel.metaData();
        } else {
            bibtexDatabase = new BibtexDatabase();
            metaData = new MetaData();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.entries.size());
        for (BibtexEntry bibtexEntry : this.entries) {
            try {
                bibtexEntry.setId(IdGenerator.next());
                bibtexDatabase.insertEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                keyCollisionException.printStackTrace();
            }
            LabelPatternUtil.makeLabel(metaData, bibtexDatabase, bibtexEntry);
            arrayList.add(bibtexEntry.getCiteKey());
        }
        for (BibtexEntry bibtexEntry : this.entries) {
            bibtexDatabase.removeEntry(bibtexEntry.getId());
        }
        this.entries.getReadWriteLock().writeLock().lock();
        this.glTable.repaint();
    }

    private void insertNodes(JMenu jMenu, GroupTreeNode groupTreeNode) {
        AbstractAction abstractAction = this.getAction(groupTreeNode);
        if (groupTreeNode.getChildCount() == 0) {
            jMenu.add(abstractAction);
            if (abstractAction.isEnabled()) {
                jMenu.setEnabled(true);
            }
            return;
        }
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu, (GroupTreeNode)groupTreeNode.getChildAt(i));
            }
        } else {
            JMenu jMenu2 = new JMenu('[' + groupTreeNode.getGroup().getName() + ']');
            jMenu2.setEnabled(abstractAction.isEnabled());
            jMenu2.add(abstractAction);
            jMenu2.add(new JPopupMenu.Separator());
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu2, (GroupTreeNode)groupTreeNode.getChildAt(i));
            }
            jMenu.add(jMenu2);
            if (jMenu2.isEnabled()) {
                jMenu.setEnabled(true);
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode groupTreeNode) {
        AddToGroupAction addToGroupAction = new AddToGroupAction(groupTreeNode);
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        addToGroupAction.setEnabled(abstractGroup.supportsAdd());
        return addToGroupAction;
    }

    public void addCallBack(CallBack callBack) {
        this.callBacks.add(callBack);
    }

    private void signalStopFetching() {
        for (CallBack callBack : this.callBacks) {
            callBack.stopFetching();
        }
    }

    private void setWidths() {
        int n;
        TableColumnModel tableColumnModel = this.glTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(55);
        tableColumnModel.getColumn(0).setMinWidth(55);
        tableColumnModel.getColumn(0).setMaxWidth(55);
        for (n = 1; n < 4; ++n) {
            if (this.frame.basePanel().tableFormat.isRankingColumn(n)) {
                tableColumnModel.getColumn(n).setPreferredWidth(35);
                tableColumnModel.getColumn(n).setMinWidth(35);
                tableColumnModel.getColumn(n).setMaxWidth(35);
                continue;
            }
            tableColumnModel.getColumn(n).setPreferredWidth(19);
            tableColumnModel.getColumn(n).setMinWidth(19);
            tableColumnModel.getColumn(n).setMaxWidth(19);
        }
        for (n = 0; n < this.fields.length; ++n) {
            int n2 = BibtexFields.getFieldLength(this.fields[n]);
            this.glTable.getColumnModel().getColumn(n + 4).setPreferredWidth(n2);
        }
    }

    private void setupComparatorChooser() {
        int n;
        List<Comparator> list = this.comparatorChooser.getComparatorsForColumn(0);
        list.clear();
        list = this.comparatorChooser.getComparatorsForColumn(1);
        list.clear();
        for (n = 2; n < 4; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            if (n == 2) {
                list.add(new IconComparator(new String[]{"file"}));
                continue;
            }
            if (n == -1) {
                list.add(new IconComparator(new String[]{"pdf"}));
                continue;
            }
            if (n == -2) {
                list.add(new IconComparator(new String[]{"ps"}));
                continue;
            }
            if (n != 3) continue;
            list.add(new IconComparator(new String[]{"url"}));
        }
        for (n = 4; n < 4 + this.fields.length; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            list.add(new FieldComparator(this.fields[n - 4]));
        }
        this.sortedList.getReadWriteLock().writeLock().lock();
        this.comparatorChooser.appendComparator(4, 0, false);
        this.sortedList.getReadWriteLock().writeLock().unlock();
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public void setStatus(String string) {
        this.frame.setStatus(string);
    }

    @Override
    public void showMessage(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this, object, string, n);
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private class EntryTableFormat
    implements TableFormat<BibtexEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 4 + ImportInspectionDialog.this.fields.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Globals.lang("Keep");
            }
            if (n >= 4) {
                return StringUtil.nCase(ImportInspectionDialog.this.fields[n - 4]);
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibtexEntry bibtexEntry, int n) {
            if (n == 0) {
                return bibtexEntry.isSearchHit() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (n < 4) {
                switch (n) {
                    case 1: {
                        return bibtexEntry.isGroupHit() ? ImportInspectionDialog.this.duplLabel : null;
                    }
                    case 2: {
                        String string = bibtexEntry.getField("file");
                        if (string != null) {
                            FileListTableModel fileListTableModel = new FileListTableModel();
                            fileListTableModel.setContent(string);
                            ImportInspectionDialog.this.fileLabel.setToolTipText(fileListTableModel.getToolTipHTMLRepresentation());
                            if (fileListTableModel.getRowCount() > 0) {
                                ImportInspectionDialog.this.fileLabel.setIcon(fileListTableModel.getEntry(0).getType().getIcon());
                            }
                            return ImportInspectionDialog.this.fileLabel;
                        }
                        return null;
                    }
                    case -1: {
                        String string = bibtexEntry.getField("pdf");
                        if (string != null) {
                            ImportInspectionDialog.this.pdfLabel.setToolTipText(string);
                            return ImportInspectionDialog.this.pdfLabel;
                        }
                        return null;
                    }
                    case -2: {
                        String string = bibtexEntry.getField("ps");
                        if (string != null) {
                            ImportInspectionDialog.this.psLabel.setToolTipText(string);
                            return ImportInspectionDialog.this.psLabel;
                        }
                        return null;
                    }
                    case 3: {
                        String string = bibtexEntry.getField("url");
                        if (string != null) {
                            ImportInspectionDialog.this.urlLabel.setToolTipText(string);
                            return ImportInspectionDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String string = ImportInspectionDialog.this.fields[n - 4];
            if (string.equals("author") || string.equals("editor")) {
                String string2 = bibtexEntry.getField(string);
                return string2 != null ? AuthorList.fixAuthor_Natbib(string2) : "";
            }
            return bibtexEntry.getField(string);
        }
    }

    class EntryTable
    extends JTable {
        final GeneralRenderer renderer;

        public EntryTable(TableModel tableModel) {
            super(tableModel);
            this.renderer = new GeneralRenderer(Color.white);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return n2 == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            if (n < 4) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n);
            bibtexEntry.setSearchHit((Boolean)object);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    class AttachFile
    extends JMenuItem
    implements ActionListener {
        final String fileType;

        public AttachFile(String string) {
            super(Globals.lang("Attach %0 file", new String[]{string.toUpperCase()}));
            this.fileType = string;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            AttachFileDialog attachFileDialog = new AttachFileDialog((Dialog)ImportInspectionDialog.this, ImportInspectionDialog.this.metaData, bibtexEntry, this.fileType);
            Util.placeDialog(attachFileDialog, ImportInspectionDialog.this);
            attachFileDialog.setVisible(true);
            if (!attachFileDialog.cancelled()) {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                bibtexEntry.setField(this.fileType, attachFileDialog.getValue());
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                ImportInspectionDialog.this.glTable.repaint();
            }
        }
    }

    class LinkLocalFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        BibtexEntry entry;

        public LinkLocalFile() {
            super(Globals.lang("Link local file"));
            this.entry = null;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            FileListEntry fileListEntry = new FileListEntry("", "", null);
            FileListEntryEditor fileListEntryEditor = new FileListEntryEditor(ImportInspectionDialog.this.frame, fileListEntry, false, true, ImportInspectionDialog.this.metaData);
            fileListEntryEditor.setVisible(true, true);
            if (fileListEntryEditor.okPressed()) {
                FileListTableModel fileListTableModel = new FileListTableModel();
                String string = this.entry.getField("file");
                if (string != null) {
                    fileListTableModel.setContent(string);
                }
                fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                this.entry.setField("file", fileListTableModel.getStringRepresentation());
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                ImportInspectionDialog.this.glTable.repaint();
            }
        }

        @Override
        public void downloadComplete(FileListEntry fileListEntry) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel fileListTableModel = new FileListTableModel();
            String string = this.entry.getField("file");
            if (string != null) {
                fileListTableModel.setContent(string);
            }
            fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            this.entry.setField("file", fileListTableModel.getStringRepresentation());
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class AutoSetLinks
    extends JMenuItem
    implements ActionListener {
        public AutoSetLinks() {
            super(Globals.lang("Autoset external links"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            final BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String string = bibtexEntry.getCiteKey();
            if (string == null) {
                int n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3);
                if (n == 0) {
                    ImportInspectionDialog.this.generateKeySelectedEntry();
                    string = bibtexEntry.getCiteKey();
                } else {
                    return;
                }
            }
            final FileListTableModel fileListTableModel = new FileListTableModel();
            String string2 = bibtexEntry.getField("file");
            if (string2 != null) {
                fileListTableModel.setContent(string2);
            }
            JDialog jDialog = new JDialog((Dialog)ImportInspectionDialog.this, true);
            JabRefExecutorService.INSTANCE.execute(Util.autoSetLinks(bibtexEntry, fileListTableModel, ImportInspectionDialog.this.metaData, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getID() > 0) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        bibtexEntry.setField("file", fileListTableModel.getStringRepresentation());
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        ImportInspectionDialog.this.glTable.repaint();
                    }
                }
            }, jDialog));
        }
    }

    class DownloadFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        BibtexEntry entry;

        public DownloadFile() {
            super(Globals.lang("Download file"));
            this.entry = null;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String string = this.entry.getCiteKey();
            if (string == null && (n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3)) == 0) {
                ImportInspectionDialog.this.generateKeySelectedEntry();
                string = this.entry.getCiteKey();
            }
            DownloadExternalFile downloadExternalFile = new DownloadExternalFile(ImportInspectionDialog.this.frame, ImportInspectionDialog.this.metaData, string);
            try {
                downloadExternalFile.download(this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public void downloadComplete(FileListEntry fileListEntry) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel fileListTableModel = new FileListTableModel();
            String string = this.entry.getField("file");
            if (string != null) {
                fileListTableModel.setContent(string);
            }
            fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            this.entry.setField("file", fileListTableModel.getStringRepresentation());
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class AttachUrl
    extends JMenuItem
    implements ActionListener {
        public AttachUrl() {
            super(Globals.lang("Attach URL"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String string = JOptionPane.showInputDialog(ImportInspectionDialog.this, Globals.lang("Enter URL"), bibtexEntry.getField("url"));
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            if (string != null) {
                if (string.isEmpty()) {
                    bibtexEntry.clearField("url");
                } else {
                    bibtexEntry.setField("url", string);
                }
            }
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class TableClickListener
    implements MouseListener {
        TableClickListener() {
        }

        public boolean isIconColumn(int n) {
            return n == 2 || n == -1 || n == -2 || n == 3;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = ImportInspectionDialog.this.glTable.columnAtPoint(mouseEvent.getPoint());
            int n2 = ImportInspectionDialog.this.glTable.rowAtPoint(mouseEvent.getPoint());
            if (this.isIconColumn(n)) {
                BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n2);
                switch (n) {
                    case 2: {
                        String string = bibtexEntry.getField("file");
                        if (string == null) break;
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        fileListTableModel.setContent(string);
                        if (fileListTableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fileListEntry = fileListTableModel.getEntry(0);
                        new ExternalFileMenuItem(ImportInspectionDialog.this.frame, bibtexEntry, "", fileListEntry.getLink(), null, ImportInspectionDialog.this.panel.metaData(), fileListEntry.getType()).actionPerformed(null);
                        break;
                    }
                    case 3: {
                        this.openExternalLink("url", mouseEvent);
                        break;
                    }
                    case -1: {
                        this.openExternalLink("pdf", mouseEvent);
                        break;
                    }
                    case -2: {
                        this.openExternalLink("ps", mouseEvent);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void showPopup(MouseEvent mouseEvent) {
            int n = ImportInspectionDialog.this.glTable.columnAtPoint(mouseEvent.getPoint());
            switch (n) {
                case 2: {
                    this.showFileFieldMenu(mouseEvent);
                    break;
                }
                default: {
                    this.showOrdinaryRightClickMenu(mouseEvent);
                }
            }
        }

        public void showOrdinaryRightClickMenu(MouseEvent mouseEvent) {
            ImportInspectionDialog.this.popup.show(ImportInspectionDialog.this.glTable, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showFileFieldMenu(MouseEvent mouseEvent) {
            int n = ImportInspectionDialog.this.glTable.rowAtPoint(mouseEvent.getPoint());
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n);
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n2 = 0;
            String string = bibtexEntry.getField("file");
            FileListTableModel fileListTableModel = new FileListTableModel();
            fileListTableModel.setContent(string);
            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                String string2 = fileListEntry.getDescription();
                if (string2 == null || string2.trim().isEmpty()) {
                    string2 = fileListEntry.getLink();
                }
                jPopupMenu.add(new ExternalFileMenuItem(ImportInspectionDialog.this.panel.frame(), bibtexEntry, string2, fileListEntry.getLink(), (Icon)fileListEntry.getType().getIcon(), ImportInspectionDialog.this.panel.metaData(), fileListEntry.getType()));
                ++n2;
            }
            if (n2 == 0) {
                this.showOrdinaryRightClickMenu(mouseEvent);
            } else {
                jPopupMenu.show(ImportInspectionDialog.this.glTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void openExternalLink(String string, MouseEvent mouseEvent) {
            int n = ImportInspectionDialog.this.glTable.rowAtPoint(mouseEvent.getPoint());
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n);
            String string2 = bibtexEntry.getField(string);
            try {
                if (string2 != null) {
                    Util.openExternalViewer(ImportInspectionDialog.this.panel.metaData(), string2, string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
                return;
            }
            int n = ImportInspectionDialog.this.glTable.columnAtPoint(mouseEvent.getPoint());
            int n2 = ImportInspectionDialog.this.glTable.rowAtPoint(mouseEvent.getPoint());
            if (n == 1 && ImportInspectionDialog.this.glTable.getValueAt(n2, n) != null) {
                BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n2);
                BibtexEntry bibtexEntry2 = DuplicateCheck.containsDuplicate(ImportInspectionDialog.this.panel.database(), bibtexEntry);
                if (bibtexEntry2 != null) {
                    DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(ImportInspectionDialog.this, bibtexEntry2, bibtexEntry, 3);
                    Util.placeDialog(duplicateResolverDialog, ImportInspectionDialog.this);
                    duplicateResolverDialog.setVisible(true);
                    ImportInspectionDialog.this.toFront();
                    if (duplicateResolverDialog.getSelected() == 1) {
                        ImportInspectionDialog.this.entriesToDelete.add(bibtexEntry2);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        bibtexEntry.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (duplicateResolverDialog.getSelected() == 2) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        ImportInspectionDialog.this.entries.remove(bibtexEntry);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (duplicateResolverDialog.getSelected() == 0) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        bibtexEntry.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    }
                }
                if ((bibtexEntry2 = ImportInspectionDialog.this.internalDuplicate(ImportInspectionDialog.this.entries, bibtexEntry)) != null) {
                    int n3 = DuplicateResolverDialog.resolveDuplicate(ImportInspectionDialog.this, bibtexEntry, bibtexEntry2);
                    if (n3 == 1) {
                        ImportInspectionDialog.this.entries.remove(bibtexEntry2);
                        bibtexEntry.setGroupHit(false);
                    } else if (n3 == 2) {
                        ImportInspectionDialog.this.entries.remove(bibtexEntry);
                    } else if (n3 == 0) {
                        bibtexEntry.setGroupHit(false);
                    }
                }
            }
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<BibtexEntry> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibtexEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                ImportInspectionDialog.this.preview.setEntry((BibtexEntry)listEvent.getSourceList().get(0));
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportInspectionDialog.this.preview.scrollRectToVisible(ImportInspectionDialog.this.toRect);
                    }
                });
            }
        }
    }

    private class DeselectDuplicatesButtonListener
    implements ActionListener {
        private DeselectDuplicatesButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                if (ImportInspectionDialog.this.glTable.getValueAt(i, 1) == null) continue;
                ImportInspectionDialog.this.glTable.setValueAt(false, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class SelectionButton
    implements ActionListener {
        final Boolean enable;

        public SelectionButton(boolean bl) {
            this.enable = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                ImportInspectionDialog.this.glTable.setValueAt(this.enable, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    private static class MyTableModel
    extends DefaultTableModel {
        private MyTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }
    }

    private static class MyTable
    extends JTable {
        public MyTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    class DeleteListener
    extends AbstractAction
    implements ActionListener {
        public DeleteListener() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.removeSelectedEntries();
        }
    }

    private class GenerateListener
    implements ActionListener {
        private GenerateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.generate.setEnabled(false);
            ImportInspectionDialog.this.generatedKeys = true;
            ImportInspectionDialog.this.generateKeys(true);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.dispose();
            ImportInspectionDialog.this.frame.output(Globals.lang("Import canceled by user"));
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.entryListComplete();
        }
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object3;
            Object object22;
            if (Globals.prefs.getBoolean("warnAboutDuplicatesInInspection")) {
                for (Object object22 : ImportInspectionDialog.this.entries) {
                    if (!((BibtexEntry)object22).isSearchHit() || !((BibtexEntry)object22).isGroupHit()) continue;
                    object3 = new CheckBoxMessage(Globals.lang("There are possible duplicates (marked with a 'D' icon) that haven't been resolved. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, object3, Globals.lang("Duplicates found"), 0);
                    if (((CheckBoxMessage)object3).isSelected()) {
                        Globals.prefs.putBoolean("warnAboutDuplicatesInInspection", false);
                    }
                    if (n != 1) break;
                    return;
                }
            }
            NamedCompound namedCompound = new NamedCompound(ImportInspectionDialog.this.undoName);
            if (!ImportInspectionDialog.this.entriesToDelete.isEmpty()) {
                for (Object object3 : ImportInspectionDialog.this.entriesToDelete) {
                    namedCompound.addEdit(new UndoableRemoveEntry(ImportInspectionDialog.this.panel.database(), (BibtexEntry)object3, ImportInspectionDialog.this.panel));
                    ImportInspectionDialog.this.panel.database().removeEntry(((BibtexEntry)object3).getId());
                }
            }
            if (ImportInspectionDialog.this.autoGenerate.isSelected() && !ImportInspectionDialog.this.generatedKeys) {
                ImportInspectionDialog.this.generateKeys(false);
            }
            Globals.prefs.putBoolean("generateKeysAfterInspection", ImportInspectionDialog.this.autoGenerate.isSelected());
            object22 = ImportInspectionDialog.this.getSelectedEntries();
            if (!object22.isEmpty()) {
                if (ImportInspectionDialog.this.newDatabase) {
                    object3 = new BibtexDatabase();
                    ImportInspectionDialog.this.panel = new BasePanel(ImportInspectionDialog.this.frame, (BibtexDatabase)object3, null, new MetaData(), Globals.prefs.get("defaultEncoding"));
                }
                boolean bl = false;
                Util.setAutomaticFields((Collection<BibtexEntry>)object22, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), Globals.prefs.getBoolean("markImportedEntries"));
                if (Globals.prefs.getBoolean("unmarkAllEntriesBeforeImporting")) {
                    for (BibtexEntry bibtexEntry : ImportInspectionDialog.this.panel.database().getEntries()) {
                        EntryMarker.unmarkEntry(bibtexEntry, true, ImportInspectionDialog.this.panel.database(), namedCompound);
                    }
                }
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    BibtexEntry bibtexEntry;
                    bibtexEntry = (BibtexEntry)iterator.next();
                    bibtexEntry.setSearchHit(false);
                    bibtexEntry.setGroupHit(false);
                    Set set = (Set)ImportInspectionDialog.this.groupAdditions.get(bibtexEntry);
                    if (!bl && set != null) {
                        if (bibtexEntry.getField("bibtexkey") == null) {
                            int n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, Globals.lang("Cannot add entries to group without generating keys. Generate keys now?"), Globals.lang("Add to group"), 0);
                            if (n == 0) {
                                ImportInspectionDialog.this.generateKeys(false);
                            } else {
                                bl = true;
                            }
                        }
                        if (bibtexEntry.getField("bibtexkey") != null) {
                            for (GroupTreeNode groupTreeNode : set) {
                                if (!groupTreeNode.getGroup().supportsAdd()) continue;
                                AbstractUndoableEdit abstractUndoableEdit = groupTreeNode.getGroup().add(new BibtexEntry[]{bibtexEntry});
                                if (abstractUndoableEdit instanceof UndoableChangeAssignment) {
                                    ((UndoableChangeAssignment)abstractUndoableEdit).setEditedNode(groupTreeNode);
                                }
                                namedCompound.addEdit(abstractUndoableEdit);
                            }
                        }
                    }
                    try {
                        bibtexEntry.setId(IdGenerator.next());
                        ImportInspectionDialog.this.panel.database().insertEntry(bibtexEntry);
                        namedCompound.addEdit(new UndoableInsertEntry(ImportInspectionDialog.this.panel.database(), bibtexEntry, ImportInspectionDialog.this.panel));
                    }
                    catch (KeyCollisionException keyCollisionException) {
                        keyCollisionException.printStackTrace();
                    }
                }
                namedCompound.end();
                ((ImportInspectionDialog)ImportInspectionDialog.this).panel.undoManager.addEdit(namedCompound);
            }
            ImportInspectionDialog.this.dispose();
            SwingUtilities.invokeLater(new Runnable((List)object22){
                final /* synthetic */ List val$selected;
                {
                    this.val$selected = list;
                }

                @Override
                public void run() {
                    if (ImportInspectionDialog.this.newDatabase) {
                        ImportInspectionDialog.this.frame.addTab(ImportInspectionDialog.this.panel, null, true);
                    }
                    ImportInspectionDialog.this.panel.markBaseChanged();
                    if (!this.val$selected.isEmpty()) {
                        ImportInspectionDialog.this.frame.output(Globals.lang("Number of entries successfully imported") + ": " + this.val$selected.size());
                    } else {
                        ImportInspectionDialog.this.frame.output(Globals.lang("No entries imported."));
                    }
                }
            });
        }
    }

    class AddToGroupAction
    extends AbstractAction {
        final GroupTreeNode node;

        public AddToGroupAction(GroupTreeNode groupTreeNode) {
            super(groupTreeNode.getGroup().getName());
            this.node = groupTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().lock();
            for (BibtexEntry bibtexEntry : ImportInspectionDialog.this.selectionModel.getSelected()) {
                HashSet<GroupTreeNode> hashSet = (HashSet<GroupTreeNode>)ImportInspectionDialog.this.groupAdditions.get(bibtexEntry);
                if (hashSet == null) {
                    hashSet = new HashSet<GroupTreeNode>();
                    ImportInspectionDialog.this.groupAdditions.put(bibtexEntry, hashSet);
                }
                hashSet.add(this.node);
            }
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().unlock();
        }
    }

    public static interface CallBack {
        public void stopFetching();
    }
}

