/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.IdComparator;

public class GlazedEntrySorter
implements DatabaseChangeListener {
    private final EventList<BibtexEntry> list = new BasicEventList<BibtexEntry>();
    String[] idArray;
    BibtexEntry[] entryArray;

    public GlazedEntrySorter(Map<String, BibtexEntry> map) {
        this.list.getReadWriteLock().writeLock().lock();
        Set<String> set = map.keySet();
        for (String string : set) {
            this.list.add(map.get(string));
        }
        Collections.sort(this.list, new IdComparator());
        this.list.getReadWriteLock().writeLock().unlock();
    }

    public EventList<BibtexEntry> getTheList() {
        return this.list;
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        int n;
        this.list.getReadWriteLock().writeLock().lock();
        if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY) {
            this.list.add(databaseChangeEvent.getEntry());
        } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.REMOVED_ENTRY) {
            this.list.remove(databaseChangeEvent.getEntry());
        } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.CHANGED_ENTRY && (n = this.list.indexOf(databaseChangeEvent.getEntry())) != -1) {
            this.list.set(n, databaseChangeEvent.getEntry());
        }
        this.list.getReadWriteLock().writeLock().unlock();
    }
}

