/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.ConfirmCloseFileListEntryEditor;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;

public class FileListEntryEditor {
    private JDialog diag;
    private final JTextField link = new JTextField();
    private final JTextField description = new JTextField();
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JComboBox types;
    private final JProgressBar prog = new JProgressBar(0);
    private final JLabel downloadLabel = new JLabel(Globals.lang("Downloading..."));
    private ConfirmCloseFileListEntryEditor externalConfirm = null;
    private FileListEntry entry;
    private final MetaData metaData;
    private boolean okPressed = false;
    private boolean okDisabledExternally = false;
    private boolean openBrowseWhenShown = false;
    private boolean dontOpenBrowseUntilDisposed = false;
    private static final Pattern remoteLinkPattern = Pattern.compile("[a-z]+://.*");

    public FileListEntryEditor(JabRefFrame jabRefFrame, FileListEntry fileListEntry, boolean bl, boolean bl2, MetaData metaData) {
        this.entry = fileListEntry;
        this.metaData = metaData;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FileListEntryEditor.this.ok.isEnabled()) {
                    return;
                }
                if (FileListEntryEditor.this.externalConfirm != null) {
                    FileListEntry fileListEntry = new FileListEntry("", "", null);
                    FileListEntryEditor.this.storeSettings(fileListEntry);
                    if (!FileListEntryEditor.this.externalConfirm.confirmClose(fileListEntry)) {
                        return;
                    }
                }
                FileListEntryEditor.this.diag.dispose();
                FileListEntryEditor.this.storeSettings(FileListEntryEditor.this.entry);
                FileListEntryEditor.this.okPressed = true;
            }
        };
        this.types = new JComboBox();
        this.types.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FileListEntryEditor.this.okDisabledExternally) {
                    FileListEntryEditor.this.ok.setEnabled(FileListEntryEditor.this.types.getSelectedItem() != null);
                }
            }
        });
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(Globals.lang("Link"));
        defaultFormBuilder.append(this.link);
        final BrowseListener browseListener = new BrowseListener(jabRefFrame, this.link);
        final JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(browseListener);
        defaultFormBuilder.append(jButton);
        JButton jButton2 = new JButton(Globals.lang("Open"));
        if (bl2) {
            defaultFormBuilder.append(jButton2);
        }
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Description"));
        defaultFormBuilder.append((Component)this.description, 3);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("File type"));
        defaultFormBuilder.append((Component)this.types, 3);
        if (bl) {
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.downloadLabel);
            defaultFormBuilder.append((Component)this.prog, 3);
        }
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton((JComponent)this.ok);
        JButton jButton3 = new JButton(Globals.lang("Cancel"));
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addGlue();
        this.ok.addActionListener(abstractAction);
        this.link.addActionListener(abstractAction);
        this.description.addActionListener(abstractAction);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEntryEditor.this.openFile();
            }
        });
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEntryEditor.this.diag.dispose();
            }
        };
        jButton3.addActionListener(abstractAction2);
        ActionMap actionMap = defaultFormBuilder.getPanel().getActionMap();
        InputMap inputMap = defaultFormBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction2);
        this.link.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }
        });
        this.diag = new JDialog(jabRefFrame, Globals.lang("Edit file link"), true);
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        Util.placeDialog(this.diag, jabRefFrame);
        this.diag.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (FileListEntryEditor.this.openBrowseWhenShown && !FileListEntryEditor.this.dontOpenBrowseUntilDisposed) {
                    FileListEntryEditor.this.dontOpenBrowseUntilDisposed = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            browseListener.actionPerformed(new ActionEvent(jButton, 0, ""));
                        }
                    });
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FileListEntryEditor.this.dontOpenBrowseUntilDisposed = false;
            }
        });
        this.setValues(fileListEntry);
    }

    private void checkExtension() {
        if (this.types.getSelectedIndex() == -1 && !this.link.getText().trim().isEmpty()) {
            Object object;
            if (remoteLinkPattern.matcher(this.link.getText()).matches() && (object = Globals.prefs.getExternalFileTypeByExt("html")) != null) {
                this.types.setSelectedItem(object);
                return;
            }
            object = this.link.getText().trim();
            ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeForName((String)object);
            if (externalFileType != null) {
                this.types.setSelectedItem(externalFileType);
            }
        }
    }

    private void openFile() {
        ExternalFileType externalFileType = (ExternalFileType)this.types.getSelectedItem();
        if (externalFileType != null) {
            try {
                Util.openExternalFileAnyFormat(this.metaData, this.link.getText(), externalFileType);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setExternalConfirm(ConfirmCloseFileListEntryEditor confirmCloseFileListEntryEditor) {
        this.externalConfirm = confirmCloseFileListEntryEditor;
    }

    public void setOkEnabled(boolean bl) {
        this.okDisabledExternally = !bl;
        this.ok.setEnabled(bl);
    }

    public JProgressBar getProgressBar() {
        return this.prog;
    }

    public JLabel getProgressBarLabel() {
        return this.downloadLabel;
    }

    public void setEntry(FileListEntry fileListEntry) {
        this.entry = fileListEntry;
        this.setValues(fileListEntry);
    }

    public void setVisible(boolean bl, boolean bl2) {
        boolean bl3 = this.openBrowseWhenShown = bl2 && Globals.prefs.getBoolean("allowFileAutoOpenBrowse");
        if (bl) {
            this.okPressed = false;
        }
        this.diag.setVisible(bl);
    }

    public boolean isVisible() {
        return this.diag != null && this.diag.isVisible();
    }

    private void setValues(FileListEntry fileListEntry) {
        this.description.setText(fileListEntry.getDescription());
        this.link.setText(fileListEntry.getLink());
        this.types.setModel(new DefaultComboBoxModel<ExternalFileType>(Globals.prefs.getExternalFileTypeSelection()));
        this.types.setSelectedIndex(-1);
        if (fileListEntry.getType() != null && !(fileListEntry.getType() instanceof UnknownExternalFileType)) {
            this.types.setSelectedItem(fileListEntry.getType());
        } else if (fileListEntry.getLink() != null && !fileListEntry.getLink().isEmpty()) {
            this.checkExtension();
        }
    }

    private void storeSettings(FileListEntry fileListEntry) {
        fileListEntry.setDescription(this.description.getText().trim());
        try {
            String[] stringArray = this.metaData.getFileDirectory("file");
            if (stringArray.length == 0) {
                fileListEntry.setLink(this.link.getText().trim());
            } else {
                boolean bl = false;
                for (String string : stringArray) {
                    String string2;
                    String string3 = new File(string).getCanonicalPath();
                    File file = new File(this.link.getText().trim());
                    if (!file.isAbsolute() || (string2 = file.getCanonicalPath()).length() <= string3.length() || !string2.startsWith(string3)) continue;
                    String string4 = file.getCanonicalPath().substring(string3.length() + 1);
                    fileListEntry.setLink(string4);
                    bl = true;
                    break;
                }
                if (!bl) {
                    fileListEntry.setLink(this.link.getText().trim());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            fileListEntry.setLink(this.link.getText().trim());
        }
        fileListEntry.setType((ExternalFileType)this.types.getSelectedItem());
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    class BrowseListener
    implements ActionListener {
        private final JFrame parent;
        private final JTextField comp;

        public BrowseListener(JFrame jFrame, JTextField jTextField) {
            this.parent = jFrame;
            this.comp = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            File file = new File(this.comp.getText().trim());
            if (this.comp.getText().trim().isEmpty()) {
                file = new File(Globals.prefs.get("fileWorkingDirectory"));
            }
            if ((string = FileDialogs.getNewFile(this.parent, file, "_non__", 0, false)) != null) {
                File file2 = new File(string);
                Globals.prefs.put("fileWorkingDirectory", file2.getParent());
                String[] stringArray = FileListEntryEditor.this.metaData.getFileDirectory("file");
                file2 = FileUtil.shortenFileName(file2, stringArray);
                this.comp.setText(file2.getPath());
                this.comp.requestFocus();
            }
        }
    }
}

