/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class FieldWeightDialog
extends JDialog {
    private final JabRefFrame frame;
    private final HashMap<JSlider, SliderInfo> sliders = new HashMap();
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));

    public static void main(String[] stringArray) {
        new FieldWeightDialog(null).setVisible(true);
    }

    private FieldWeightDialog(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        JPanel jPanel = this.buildMainPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.pack();
    }

    private JPanel buildMainPanel() {
        FormLayout formLayout = new FormLayout("right:pref, 4dlu, fill:pref, 8dlu, right:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("Field sizes"));
        TreeSet<String> treeSet = new TreeSet<String>();
        this.sliders.clear();
        int n = BibtexFields.numberOfPublicFields();
        for (int i = 0; i < n; ++i) {
            treeSet.add(BibtexFields.getFieldName(i));
        }
        treeSet.remove("bibtexkey");
        for (String string : treeSet) {
            defaultFormBuilder.append(string);
            int n2 = (int)(100.0 * BibtexFields.getFieldWeight(string) / 2.0);
            JSlider jSlider = new JSlider(0, 100, n2);
            this.sliders.put(jSlider, new SliderInfo(string, n2));
            defaultFormBuilder.append(jSlider);
        }
        defaultFormBuilder.appendSeparator();
        return defaultFormBuilder.getPanel();
    }

    private JPanel buildButtonPanel() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldWeightDialog.this.storeSettings();
                FieldWeightDialog.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldWeightDialog.this.dispose();
            }
        });
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        return buttonBarBuilder.getPanel();
    }

    private void storeSettings() {
        for (JSlider jSlider : this.sliders.keySet()) {
            SliderInfo sliderInfo = this.sliders.get(jSlider);
            if (sliderInfo.originalValue == jSlider.getValue()) continue;
            double d = 2.0 * (double)jSlider.getValue() / 100.0;
            BibtexFields.setFieldWeight(sliderInfo.fieldName, d);
        }
        this.frame.removeCachedEntryEditors();
    }

    static class SliderInfo {
        final String fieldName;
        final int originalValue;

        public SliderInfo(String string, int n) {
            this.fieldName = string;
            this.originalValue = n;
        }
    }
}

