/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.Globals;
import net.sf.jabref.util.error.StreamEavesdropper;
import net.sf.jabref.util.logging.CacheableHandler;

public class ErrorConsoleAction
extends AbstractAction {
    private final JFrame frame;
    private final StreamEavesdropper streamEavesdropper;
    private final CacheableHandler logHandler;

    public ErrorConsoleAction(JFrame jFrame, StreamEavesdropper streamEavesdropper, CacheableHandler cacheableHandler) {
        super(Globals.menuTitle("Show error console"));
        this.streamEavesdropper = streamEavesdropper;
        this.logHandler = cacheableHandler;
        this.putValue("ShortDescription", Globals.lang("Display all error messages"));
        this.frame = jFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.displayErrorConsole(this.frame);
    }

    private void displayErrorConsole(JFrame jFrame) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.addTextArea(jTabbedPane, Globals.lang("Output"), this.streamEavesdropper.getOutput());
        this.addTextArea(jTabbedPane, Globals.lang("Exceptions"), this.streamEavesdropper.getErrorMessages(), Globals.lang("No exceptions have ocurred."));
        this.addTextArea(jTabbedPane, Globals.lang("Log"), this.logHandler.getLog());
        jTabbedPane.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(jFrame, jTabbedPane, Globals.lang("Program output"), 0);
    }

    private void addTextArea(JTabbedPane jTabbedPane, String string, String string2, String string3) {
        JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setEditable(false);
        if (string3 != null && jTextArea.getText().isEmpty()) {
            jTextArea.setText(string3);
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTabbedPane.addTab(string, jScrollPane);
    }

    private void addTextArea(JTabbedPane jTabbedPane, String string, String string2) {
        this.addTextArea(jTabbedPane, string, string2, null);
    }
}

