/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.EntryTypeList;
import net.sf.jabref.gui.FieldSetComponent;
import net.sf.jabref.util.StringUtil;

public class EntryCustomizationDialog2
extends JDialog
implements ListSelectionListener,
ActionListener {
    private final JabRefFrame frame;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    private FieldSetComponent reqComp;
    private FieldSetComponent optComp;
    private FieldSetComponent optComp2;
    private EntryTypeList typeComp;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    protected JButton helpButton;
    protected JButton delete;
    protected JButton importTypes;
    protected JButton exportTypes;
    private final List<String> preset = Arrays.asList(BibtexFields.getAllFieldNames());
    private String lastSelected = null;
    private final Map<String, List<String>> reqLists = new HashMap<String, List<String>>();
    private final Map<String, List<String>> optLists = new HashMap<String, List<String>>();
    private final Map<String, List<String>> opt2Lists = new HashMap<String, List<String>>();
    private final Set<String> defaulted = new HashSet<String>();
    private final Set<String> changed = new HashSet<String>();
    private boolean biblatexMode;

    public EntryCustomizationDialog2(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Customize entry types"), false);
        this.frame = jabRefFrame;
        this.initGui();
    }

    private void initGui() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.biblatexMode = Globals.prefs.getBoolean("biblatexMode");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel3.setLayout(new GridLayout(this.biblatexMode ? 2 : 1, 2));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : BibtexEntryType.getAllTypes()) {
            arrayList.add(object2);
        }
        this.typeComp = new EntryTypeList(arrayList);
        this.typeComp.addListSelectionListener(this);
        this.typeComp.addAdditionActionListener(this);
        this.typeComp.addDefaultActionListener(new DefaultListener());
        this.typeComp.setListSelectionMode(0);
        this.reqComp = new FieldSetComponent(Globals.lang("Required fields"), new ArrayList<String>(), this.preset, true, true);
        this.reqComp.setEnabled(false);
        this.reqComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DataListener dataListener = new DataListener();
        this.reqComp.addListDataListener(dataListener);
        this.optComp = new FieldSetComponent(Globals.lang("Optional fields"), new ArrayList<String>(), this.preset, true, true);
        this.optComp.setEnabled(false);
        this.optComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.optComp.addListDataListener(dataListener);
        jPanel3.add(this.reqComp);
        jPanel3.add(this.optComp);
        if (this.biblatexMode) {
            this.optComp2 = new FieldSetComponent(Globals.lang("Optional fields") + " 2", new ArrayList<String>(), this.preset, true, true);
            this.optComp2.setEnabled(false);
            this.optComp2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.optComp2.addListDataListener(dataListener);
            jPanel3.add(new JPanel());
            jPanel3.add(this.optComp2);
        }
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.ok = new JButton("Ok");
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.apply = new JButton(Globals.lang("Apply"));
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.apply);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryCustomizationDialog2.this.dispose();
            }
        };
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        jPanel.add((Component)this.typeComp, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.lastSelected != null) {
            this.reqLists.put(this.lastSelected, this.reqComp.getFields());
            this.optLists.put(this.lastSelected, this.optComp.getFields());
            if (this.biblatexMode) {
                this.opt2Lists.put(this.lastSelected, this.optComp2.getFields());
            }
        }
        if ((string = this.typeComp.getFirstSelected()) == null) {
            return;
        }
        List<String> list = this.reqLists.get(string);
        if (list == null) {
            BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
            if (bibtexEntryType != null) {
                List<String> list2;
                String[] stringArray = bibtexEntryType.getRequiredFieldsForCustomization();
                List<String> list3 = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
                if (!this.biblatexMode) {
                    String[] stringArray2 = bibtexEntryType.getOptionalFields();
                    list2 = stringArray2 != null ? Arrays.asList(stringArray2) : new ArrayList<String>();
                } else {
                    String[] stringArray3 = bibtexEntryType.getPrimaryOptionalFields();
                    list2 = stringArray3 != null ? Arrays.asList(stringArray3) : new ArrayList<String>();
                    String[] stringArray4 = bibtexEntryType.getSecondaryOptionalFields();
                    List<String> list4 = stringArray4 != null ? Arrays.asList(stringArray4) : new ArrayList<String>();
                    this.optComp2.setFields(list4);
                    this.optComp2.setEnabled(true);
                }
                this.reqComp.setFields(list3);
                this.reqComp.setEnabled(true);
                this.optComp.setFields(list2);
                this.optComp.setEnabled(true);
            } else {
                this.reqComp.setFields(new ArrayList<String>());
                this.reqComp.setEnabled(true);
                this.optComp.setFields(new ArrayList<String>());
                this.optComp.setEnabled(true);
                if (this.biblatexMode) {
                    this.optComp2.setFields(new ArrayList<String>());
                    this.optComp2.setEnabled(true);
                }
                new FocusRequester(this.reqComp);
            }
        } else {
            this.reqComp.setFields(list);
            this.optComp.setFields(this.optLists.get(string));
            if (this.biblatexMode) {
                this.optComp2.setFields(this.opt2Lists.get(string));
            }
        }
        this.lastSelected = string;
        this.typeComp.enable(string, this.changed.contains(this.lastSelected) && !this.defaulted.contains(this.lastSelected));
    }

    private void applyChanges() {
        this.valueChanged(new ListSelectionEvent(new JList(), 0, 0, false));
        List list = this.typeComp.getFields();
        for (Map.Entry<String, List<String>> object2 : this.reqLists.entrySet()) {
            String[] stringArray;
            Object object;
            if (!list.contains(object2.getKey())) continue;
            List<String> list2 = object2.getValue();
            List<String> list3 = this.optLists.get(object2.getKey());
            List<String> list4 = this.opt2Lists.get(object2.getKey());
            String[] stringArray2 = new String[list2.size()];
            stringArray2 = list2.toArray(stringArray2);
            String[] stringArray3 = new String[list3.size()];
            stringArray3 = list3.toArray(stringArray3);
            String[] stringArray4 = list4 != null ? list4.toArray(new String[list4.size()]) : new String[]{};
            boolean bl = true;
            if (this.defaulted.contains(object2.getKey())) {
                object = StringUtil.nCase(object2.getKey());
                BibtexEntryType.removeType((String)object);
                this.updateTypesForEntries((String)object);
                continue;
            }
            object = BibtexEntryType.getType(object2.getKey());
            if (object != null) {
                stringArray = ((BibtexEntryType)object).getRequiredFields();
                String[] stringArray5 = ((BibtexEntryType)object).getOptionalFields();
                if (this.biblatexMode) {
                    String[] stringArray6 = ((BibtexEntryType)object).getPrimaryOptionalFields();
                    String[] stringArray7 = ((BibtexEntryType)object).getSecondaryOptionalFields();
                    if (this.equalArrays(stringArray, stringArray2) && this.equalArrays(stringArray6, stringArray3) && this.equalArrays(stringArray7, stringArray4)) {
                        bl = false;
                    }
                } else if (this.equalArrays(stringArray, stringArray2) && this.equalArrays(stringArray5, stringArray3)) {
                    bl = false;
                }
            }
            if (!bl) continue;
            stringArray = this.biblatexMode ? new CustomEntryType(StringUtil.nCase(object2.getKey()), stringArray2, stringArray3, stringArray4) : new CustomEntryType(StringUtil.nCase(object2.getKey()), stringArray2, stringArray3);
            BibtexEntryType.addOrModifyCustomEntryType((CustomEntryType)stringArray);
            this.updateTypesForEntries(stringArray.getName());
        }
        HashSet hashSet = new HashSet();
        for (String string : BibtexEntryType.getAllTypes()) {
            if (list.contains(string)) continue;
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.typeDeletion((String)e);
            }
        }
        this.updateTables();
    }

    private void typeDeletion(String string) {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
        if (bibtexEntryType instanceof CustomEntryType) {
            int n;
            if (BibtexEntryType.getStandardType(string) == null && (n = JOptionPane.showConfirmDialog(this.frame, Globals.lang("All entries of this type will be declared typeless. Continue?"), Globals.lang("Delete custom format") + " '" + StringUtil.nCase(string) + '\'', 0, 2)) != 0) {
                return;
            }
            BibtexEntryType.removeType(string);
            this.updateTypesForEntries(StringUtil.nCase(string));
            this.changed.remove(string);
            this.reqLists.remove(string);
            this.optLists.remove(string);
            if (this.biblatexMode) {
                this.opt2Lists.remove(string);
            }
        }
    }

    private boolean equalArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.applyChanges();
            this.dispose();
        } else if (actionEvent.getSource() == this.cancel) {
            this.dispose();
        } else if (actionEvent.getSource() == this.apply) {
            this.applyChanges();
        } else if (actionEvent.getSource() == this.typeComp) {
            this.typeComp.selectField(actionEvent.getActionCommand());
        }
    }

    private void updateTypesForEntries(String string) {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.frame.getTabbedPane().getComponentAt(i);
            basePanel.entryEditors.remove(string);
            for (BibtexEntry bibtexEntry : basePanel.database().getEntries()) {
                bibtexEntry.updateType();
            }
        }
    }

    private void updateTables() {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            this.frame.getTabbedPane().getComponentAt(i);
        }
    }

    class DataListener
    implements ListDataListener {
        DataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.record();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.record();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.record();
        }

        private void record() {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.remove(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.changed.add(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.typeComp.enable(EntryCustomizationDialog2.this.lastSelected, true);
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.add(EntryCustomizationDialog2.this.lastSelected);
            BibtexEntryType bibtexEntryType = BibtexEntryType.getStandardType(EntryCustomizationDialog2.this.lastSelected);
            if (bibtexEntryType != null) {
                String[] stringArray = bibtexEntryType.getRequiredFieldsForCustomization();
                String[] stringArray2 = bibtexEntryType.getOptionalFields();
                List<String> list = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
                ArrayList<String> arrayList = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList();
                if (EntryCustomizationDialog2.this.biblatexMode) {
                    if (stringArray2 != null) {
                        String[] stringArray3 = bibtexEntryType.getPrimaryOptionalFields();
                        String[] stringArray4 = bibtexEntryType.getSecondaryOptionalFields();
                        if (stringArray3 != null) {
                            arrayList = Arrays.asList(stringArray3);
                        }
                        if (stringArray4 != null) {
                            arrayList2 = Arrays.asList(stringArray4);
                        }
                    }
                } else if (stringArray2 != null) {
                    arrayList = Arrays.asList(stringArray2);
                }
                EntryCustomizationDialog2.this.reqComp.setFields(list);
                EntryCustomizationDialog2.this.reqComp.setEnabled(true);
                EntryCustomizationDialog2.this.optComp.setFields(arrayList);
                if (EntryCustomizationDialog2.this.biblatexMode) {
                    EntryCustomizationDialog2.this.optComp2.setFields(arrayList2);
                }
            }
        }
    }
}

