/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.UnitFormatter;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.DOIUtil;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.MonthUtil;
import net.sf.jabref.util.Util;

public class CleanUpAction
extends AbstractWorker {
    private static final String AKS_AUTO_NAMING_PDFS_AGAIN = "AskAutoNamingPDFsAgain";
    private static final String CLEANUP_DOI = "CleanUpDOI";
    private static final String CLEANUP_MONTH = "CleanUpMonth";
    private static final String CLEANUP_PAGENUMBERS = "CleanUpPageNumbers";
    private static final String CLEANUP_MAKEPATHSRELATIVE = "CleanUpMakePathsRelative";
    private static final String CLEANUP_RENAMEPDF = "CleanUpRenamePDF";
    private static final String CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS = "CleanUpRenamePDFonlyRelativePaths";
    private static final String CLEANUP_UPGRADE_EXTERNAL_LINKS = "CleanUpUpgradeExternalLinks";
    private static final String CLEANUP_SUPERSCRIPTS = "CleanUpSuperscripts";
    private static final String CLEANUP_HTML = "CleanUpHTML";
    private static final String CLEANUP_CASE = "CleanUpCase";
    private static final String CLEANUP_LATEX = "CleanUpLaTeX";
    private static final String CLEANUP_UNITS = "CleanUpUnits";
    private static final String CLEANUP_UNICODE = "CleanUpUnicode";
    private static final String CLEANUP_CONVERTTOBIBLATEX = "CleanUpConvertToBiblatex";
    private JCheckBox cleanUpSuperscrips;
    private JCheckBox cleanUpDOI;
    private JCheckBox cleanUpMonth;
    private JCheckBox cleanUpPageNumbers;
    private JCheckBox cleanUpMakePathsRelative;
    private JCheckBox cleanUpRenamePDF;
    private JCheckBox cleanUpRenamePDFonlyRelativePaths;
    private JCheckBox cleanUpUpgradeExternalLinks;
    private JCheckBox cleanUpHTML;
    private JCheckBox cleanUpCase;
    private JCheckBox cleanUpLaTeX;
    private JCheckBox cleanUpUnits;
    private JCheckBox cleanUpUnicode;
    private JCheckBox cleanUpBiblatex;
    private JPanel optionsPanel = new JPanel();
    private final BasePanel panel;
    private final JabRefFrame frame;
    private int unsuccesfullRenames = 0;
    private boolean cancelled;
    private int modifiedEntriesCount;
    int numSelected;

    public static void putDefaults(HashMap<String, Object> hashMap) {
        hashMap.put(AKS_AUTO_NAMING_PDFS_AGAIN, Boolean.TRUE);
        hashMap.put(CLEANUP_SUPERSCRIPTS, Boolean.TRUE);
        hashMap.put(CLEANUP_DOI, Boolean.TRUE);
        hashMap.put(CLEANUP_MONTH, Boolean.TRUE);
        hashMap.put(CLEANUP_PAGENUMBERS, Boolean.TRUE);
        hashMap.put(CLEANUP_MAKEPATHSRELATIVE, Boolean.TRUE);
        hashMap.put(CLEANUP_RENAMEPDF, Boolean.TRUE);
        hashMap.put(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS, Boolean.FALSE);
        hashMap.put(CLEANUP_UPGRADE_EXTERNAL_LINKS, Boolean.FALSE);
        hashMap.put(CLEANUP_MAKEPATHSRELATIVE, Boolean.TRUE);
        hashMap.put(CLEANUP_HTML, Boolean.TRUE);
        hashMap.put(CLEANUP_CASE, Boolean.TRUE);
        hashMap.put(CLEANUP_LATEX, Boolean.TRUE);
        hashMap.put(CLEANUP_UNITS, Boolean.TRUE);
        hashMap.put(CLEANUP_UNICODE, Boolean.TRUE);
        hashMap.put(CLEANUP_CONVERTTOBIBLATEX, Boolean.FALSE);
    }

    public CleanUpAction(BasePanel basePanel) {
        this.panel = basePanel;
        this.frame = basePanel.frame();
        this.initOptionsPanel();
    }

    private void initOptionsPanel() {
        this.cleanUpSuperscrips = new JCheckBox(Globals.lang("Convert 1st, 2nd, ... to real superscripts"));
        this.cleanUpDOI = new JCheckBox(Globals.lang("Move DOIs from note and URL field to DOI field and remove http prefix"));
        this.cleanUpMonth = new JCheckBox(Globals.lang("Format content of month field to #mon#"));
        this.cleanUpPageNumbers = new JCheckBox(Globals.lang("Ensure that page ranges are of the form num1--num2"));
        this.cleanUpMakePathsRelative = new JCheckBox(Globals.lang("Make paths of linked files relative (if possible)"));
        this.cleanUpRenamePDF = new JCheckBox(Globals.lang("Rename PDFs to given file name format pattern"));
        this.cleanUpRenamePDF.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CleanUpAction.this.cleanUpRenamePDFonlyRelativePaths.setEnabled(CleanUpAction.this.cleanUpRenamePDF.isSelected());
            }
        });
        this.cleanUpRenamePDFonlyRelativePaths = new JCheckBox(Globals.lang("Rename only PDFs having a relative path"));
        this.cleanUpUpgradeExternalLinks = new JCheckBox(Globals.lang("Upgrade external PDF/PS links to use the '%0' field.", "file"));
        this.cleanUpHTML = new JCheckBox(Globals.lang("Run HTML converter on title"));
        this.cleanUpCase = new JCheckBox(Globals.lang("Run filter on title keeping the case of selected words"));
        this.cleanUpLaTeX = new JCheckBox(Globals.lang("Remove unneccessary $, {, and } and move adjacent numbers into equations"));
        this.cleanUpUnits = new JCheckBox(Globals.lang("Add brackets and replace separators with their non-breaking version for units"));
        this.cleanUpUnicode = new JCheckBox(Globals.lang("Run Unicode converter on title, author(s), and abstract"));
        this.cleanUpBiblatex = new JCheckBox(Globals.lang("Convert to BibLatex format (for example, move the value of the 'journal' field to 'journaltitle')"));
        this.optionsPanel = new JPanel();
        this.retrieveSettings();
        FormLayout formLayout = new FormLayout("left:15dlu,pref:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout, this.optionsPanel);
        defaultFormBuilder.border(Borders.DIALOG);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.cleanUpHTML, cellConstraints.xyw(1, 1, 2));
        defaultFormBuilder.add((Component)this.cleanUpUnicode, cellConstraints.xyw(1, 2, 2));
        defaultFormBuilder.add((Component)this.cleanUpCase, cellConstraints.xyw(1, 3, 2));
        defaultFormBuilder.add((Component)this.cleanUpLaTeX, cellConstraints.xyw(1, 4, 2));
        defaultFormBuilder.add((Component)this.cleanUpUnits, cellConstraints.xyw(1, 5, 2));
        defaultFormBuilder.add((Component)this.cleanUpSuperscrips, cellConstraints.xyw(1, 6, 2));
        defaultFormBuilder.add((Component)this.cleanUpDOI, cellConstraints.xyw(1, 7, 2));
        defaultFormBuilder.add((Component)this.cleanUpMonth, cellConstraints.xyw(1, 8, 2));
        defaultFormBuilder.add((Component)this.cleanUpPageNumbers, cellConstraints.xyw(1, 9, 2));
        defaultFormBuilder.add((Component)this.cleanUpUpgradeExternalLinks, cellConstraints.xyw(1, 10, 2));
        defaultFormBuilder.add((Component)this.cleanUpMakePathsRelative, cellConstraints.xyw(1, 11, 2));
        defaultFormBuilder.add((Component)this.cleanUpRenamePDF, cellConstraints.xyw(1, 12, 2));
        String string = Globals.lang("File name format pattern").concat(": ").concat(Globals.prefs.get("importFileNamePattern"));
        defaultFormBuilder.add((Component)new JLabel(string), cellConstraints.xyw(2, 13, 1));
        defaultFormBuilder.add((Component)this.cleanUpRenamePDFonlyRelativePaths, cellConstraints.xyw(2, 14, 1));
        defaultFormBuilder.add((Component)this.cleanUpBiblatex, cellConstraints.xyw(1, 15, 2));
    }

    private void retrieveSettings() {
        this.cleanUpSuperscrips.setSelected(Globals.prefs.getBoolean(CLEANUP_SUPERSCRIPTS));
        this.cleanUpDOI.setSelected(Globals.prefs.getBoolean(CLEANUP_DOI));
        this.cleanUpMonth.setSelected(Globals.prefs.getBoolean(CLEANUP_MONTH));
        this.cleanUpPageNumbers.setSelected(Globals.prefs.getBoolean(CLEANUP_PAGENUMBERS));
        this.cleanUpMakePathsRelative.setSelected(Globals.prefs.getBoolean(CLEANUP_MAKEPATHSRELATIVE));
        this.cleanUpRenamePDF.setSelected(Globals.prefs.getBoolean(CLEANUP_RENAMEPDF));
        this.cleanUpRenamePDFonlyRelativePaths.setSelected(Globals.prefs.getBoolean(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS));
        this.cleanUpRenamePDFonlyRelativePaths.setEnabled(this.cleanUpRenamePDF.isSelected());
        this.cleanUpUpgradeExternalLinks.setSelected(Globals.prefs.getBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS));
        this.cleanUpHTML.setSelected(Globals.prefs.getBoolean(CLEANUP_HTML));
        this.cleanUpCase.setSelected(Globals.prefs.getBoolean(CLEANUP_CASE));
        this.cleanUpLaTeX.setSelected(Globals.prefs.getBoolean(CLEANUP_LATEX));
        this.cleanUpUnits.setSelected(Globals.prefs.getBoolean(CLEANUP_UNITS));
        this.cleanUpUnicode.setSelected(Globals.prefs.getBoolean(CLEANUP_UNICODE));
        this.cleanUpBiblatex.setSelected(Globals.prefs.getBoolean(CLEANUP_CONVERTTOBIBLATEX));
    }

    private void storeSettings() {
        Globals.prefs.putBoolean(CLEANUP_SUPERSCRIPTS, this.cleanUpSuperscrips.isSelected());
        Globals.prefs.putBoolean(CLEANUP_DOI, this.cleanUpDOI.isSelected());
        Globals.prefs.putBoolean(CLEANUP_MONTH, this.cleanUpMonth.isSelected());
        Globals.prefs.putBoolean(CLEANUP_PAGENUMBERS, this.cleanUpPageNumbers.isSelected());
        Globals.prefs.putBoolean(CLEANUP_MAKEPATHSRELATIVE, this.cleanUpMakePathsRelative.isSelected());
        Globals.prefs.putBoolean(CLEANUP_RENAMEPDF, this.cleanUpRenamePDF.isSelected());
        Globals.prefs.putBoolean(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS, this.cleanUpRenamePDFonlyRelativePaths.isSelected());
        Globals.prefs.putBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS, this.cleanUpUpgradeExternalLinks.isSelected());
        Globals.prefs.putBoolean(CLEANUP_HTML, this.cleanUpHTML.isSelected());
        Globals.prefs.putBoolean(CLEANUP_CASE, this.cleanUpCase.isSelected());
        Globals.prefs.putBoolean(CLEANUP_LATEX, this.cleanUpLaTeX.isSelected());
        Globals.prefs.putBoolean(CLEANUP_UNITS, this.cleanUpUnits.isSelected());
        Globals.prefs.putBoolean(CLEANUP_UNICODE, this.cleanUpUnicode.isSelected());
        Globals.prefs.putBoolean(CLEANUP_CONVERTTOBIBLATEX, this.cleanUpBiblatex.isSelected());
    }

    private int showCleanUpDialog() {
        String string = Globals.lang("Cleanup entries");
        Object[] objectArray = new Object[]{Globals.lang("What would you like to clean up?"), this.optionsPanel};
        return JOptionPane.showConfirmDialog(this.frame, objectArray, string, 2, 3);
    }

    @Override
    public void init() {
        this.cancelled = false;
        this.modifiedEntriesCount = 0;
        int n = this.panel.getSelectedEntries().length;
        if (n == 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("First select entries to clean up."), Globals.lang("Cleanup entry"), 1);
            this.cancelled = true;
            return;
        }
        this.frame.block();
        this.panel.output(Globals.lang("Doing a cleanup for %0 entries...", Integer.toString(n)));
    }

    @Override
    public void run() {
        Object object;
        if (this.cancelled) {
            return;
        }
        int n = this.showCleanUpDialog();
        if (n != 0) {
            this.cancelled = true;
            return;
        }
        this.storeSettings();
        boolean bl = this.cleanUpSuperscrips.isSelected();
        boolean bl2 = this.cleanUpDOI.isSelected();
        boolean bl3 = this.cleanUpMonth.isSelected();
        boolean bl4 = this.cleanUpPageNumbers.isSelected();
        boolean bl5 = this.cleanUpUpgradeExternalLinks.isSelected();
        boolean bl6 = this.cleanUpMakePathsRelative.isSelected();
        boolean bl7 = this.cleanUpRenamePDF.isSelected();
        boolean bl8 = this.cleanUpHTML.isSelected();
        boolean bl9 = this.cleanUpCase.isSelected();
        boolean bl10 = this.cleanUpLaTeX.isSelected();
        boolean bl11 = this.cleanUpUnits.isSelected();
        boolean bl12 = this.cleanUpUnicode.isSelected();
        boolean bl13 = this.cleanUpBiblatex.isSelected();
        if (bl7 && Globals.prefs.getBoolean(AKS_AUTO_NAMING_PDFS_AGAIN)) {
            object = new CheckBoxMessage(Globals.lang("Auto-generating PDF-Names does not support undo. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
            int n2 = JOptionPane.showConfirmDialog(this.frame, object, Globals.lang("Autogenerate PDF Names"), 0);
            if (((CheckBoxMessage)object).isSelected()) {
                Globals.prefs.putBoolean(AKS_AUTO_NAMING_PDFS_AGAIN, false);
            }
            if (n2 == 1) {
                this.cancelled = true;
                return;
            }
        }
        if (bl5 && ((NamedCompound)(object = Util.upgradePdfPsToFile(Arrays.asList(this.panel.getSelectedEntries()), new String[]{"pdf", "ps"}))).hasEdits()) {
            this.panel.undoManager.addEdit((UndoableEdit)object);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
            this.panel.output(Globals.lang("Upgraded links."));
        }
        for (BibtexEntry bibtexEntry : this.panel.getSelectedEntries()) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Cleanup entry"));
            if (bl) {
                this.doCleanUpSuperscripts(bibtexEntry, namedCompound);
            }
            if (bl2) {
                this.doCleanUpDOI(bibtexEntry, namedCompound);
            }
            if (bl3) {
                this.doCleanUpMonth(bibtexEntry, namedCompound);
            }
            if (bl4) {
                this.doCleanUpPageNumbers(bibtexEntry, namedCompound);
            }
            this.fixWrongFileEntries(bibtexEntry, namedCompound);
            if (bl6) {
                this.doMakePathsRelative(bibtexEntry, namedCompound);
            }
            if (bl7) {
                this.doRenamePDFs(bibtexEntry, namedCompound);
            }
            if (bl8) {
                this.doConvertHTML(bibtexEntry, namedCompound);
            }
            if (bl11) {
                this.doConvertUnits(bibtexEntry, namedCompound);
            }
            if (bl9) {
                this.doConvertCase(bibtexEntry, namedCompound);
            }
            if (bl10) {
                this.doConvertLaTeX(bibtexEntry, namedCompound);
            }
            if (bl12) {
                this.doConvertUnicode(bibtexEntry, namedCompound);
            }
            if (bl13) {
                this.doConvertToBiblatex(bibtexEntry, namedCompound);
            }
            namedCompound.end();
            if (!namedCompound.hasEdits()) continue;
            ++this.modifiedEntriesCount;
            this.panel.undoManager.addEdit(namedCompound);
        }
    }

    @Override
    public void update() {
        String string;
        if (this.cancelled) {
            this.frame.unblock();
            return;
        }
        if (this.unsuccesfullRenames > 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("File rename failed for") + " " + this.unsuccesfullRenames + " " + Globals.lang("entries") + ".", Globals.lang("Autogenerate PDF Names"), 1);
        }
        if (this.modifiedEntriesCount > 0) {
            this.panel.updateEntryEditorIfShowing();
            this.panel.markBaseChanged();
        }
        switch (this.modifiedEntriesCount) {
            case 0: {
                string = Globals.lang("No entry needed a clean up");
                break;
            }
            case 1: {
                string = Globals.lang("One entry needed a clean up");
                break;
            }
            default: {
                string = Globals.lang("%0 entries needed a clean up", Integer.toString(this.modifiedEntriesCount));
            }
        }
        this.panel.output(string);
        this.frame.unblock();
    }

    private void doCleanUpSuperscripts(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("booktitle");
        if (string == null) {
            return;
        }
        String string2 = string.replaceAll(" (\\d+)(st|nd|rd|th) ", " $1\\\\textsuperscript{$2} ");
        if (!string.equals(string2)) {
            bibtexEntry.setField("booktitle", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "booktitle", string, string2));
        }
    }

    private void doCleanUpDOI(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        block4: {
            String[] stringArray;
            block3: {
                stringArray = new String[]{"note", "url", "ee"};
                if (bibtexEntry.getField("doi") == null) break block3;
                String string = bibtexEntry.getField("doi");
                if (DOIUtil.checkForDOIwithHTTPprefix(string)) {
                    String[] stringArray2 = DOIUtil.getDOI(string);
                    namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "doi", string, (String)stringArray2));
                    bibtexEntry.setField("doi", (String)stringArray2);
                }
                if (!DOIUtil.checkForPlainDOI(string)) break block4;
                for (String string2 : stringArray) {
                    if (!DOIUtil.checkForPlainDOI(bibtexEntry.getField(string2))) continue;
                    DOIUtil.removeDOIfromBibtexEntryField(bibtexEntry, string2, namedCompound);
                }
                break block4;
            }
            for (String string : stringArray) {
                if (!DOIUtil.checkForPlainDOI(bibtexEntry.getField(string))) continue;
                String string3 = bibtexEntry.getField("doi");
                String string4 = DOIUtil.getDOI(bibtexEntry.getField(string));
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "doi", string3, string4));
                bibtexEntry.setField("doi", string4);
                DOIUtil.removeDOIfromBibtexEntryField(bibtexEntry, string, namedCompound);
            }
        }
    }

    private void doCleanUpMonth(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("month");
        if (string == null) {
            return;
        }
        String string2 = string;
        MonthUtil.Month month = MonthUtil.getMonth(string);
        if (month.isValid()) {
            string2 = month.bibtexFormat;
        }
        if (!string.equals(string2)) {
            bibtexEntry.setField("month", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "month", string, string2));
        }
    }

    private void doCleanUpPageNumbers(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("pages");
        if (string == null) {
            return;
        }
        String string2 = string.replaceAll(" *(\\d+) *- *(\\d+) *", "$1--$2");
        if (!string.equals(string2)) {
            bibtexEntry.setField("pages", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "pages", string, string2));
        }
    }

    private void fixWrongFileEntries(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("file");
        if (string == null) {
            return;
        }
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.setContent(string);
        if (fileListTableModel.getRowCount() == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
            FileListEntry fileListEntry = fileListTableModel.getEntry(i);
            String string2 = fileListEntry.getLink();
            String string3 = fileListEntry.getDescription();
            if (!string2.equals("") || string3.equals("")) continue;
            fileListEntry.setLink(fileListEntry.getDescription());
            fileListEntry.setDescription("");
            bl = true;
        }
        if (bl) {
            String string4 = fileListTableModel.getStringRepresentation();
            assert (!string.equals(string4));
            bibtexEntry.setField("file", string4);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "file", string, string4));
        }
    }

    private void doMakePathsRelative(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("file");
        if (string == null) {
            return;
        }
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.setContent(string);
        if (fileListTableModel.getRowCount() == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
            String string2;
            FileListEntry fileListEntry = fileListTableModel.getEntry(i);
            String string3 = fileListEntry.getLink();
            if (string3.equals(string2 = FileUtil.shortenFileName(new File(string3), this.panel.metaData().getFileDirectory("file")).toString())) continue;
            fileListEntry.setLink(string2);
            bl = true;
        }
        if (bl) {
            String string4 = fileListTableModel.getStringRepresentation();
            assert (!string.equals(string4));
            bibtexEntry.setField("file", string4);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "file", string, string4));
        }
    }

    private void doRenamePDFs(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("file");
        if (string == null) {
            return;
        }
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.setContent(string);
        if (fileListTableModel.getRowCount() == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
            String string2;
            String string3 = fileListTableModel.getEntry(i).getLink();
            if (this.cleanUpRenamePDFonlyRelativePaths.isSelected() && new File(string3).isAbsolute()) continue;
            String string4 = Util.getLinkedFileName(this.panel.database(), bibtexEntry);
            string4 = string4 + "." + fileListTableModel.getEntry(i).getType().getExtension();
            File file = FileUtil.expandFilename(string3, this.panel.metaData().getFileDirectory("file"));
            if (file.getParent() == null || new File(string2 = file.getParent().concat(System.getProperty("file.separator")).concat(string4)).exists()) continue;
            boolean bl2 = FileUtil.renameFile(file.toString(), string2);
            if (bl2) {
                bl = true;
                String string5 = fileListTableModel.getEntry(i).getDescription();
                ExternalFileType externalFileType = fileListTableModel.getEntry(i).getType();
                fileListTableModel.removeEntry(i);
                File file2 = new File(string3).getParentFile();
                String string6 = file2 == null ? string4 : file2.toString().concat(System.getProperty("file.separator")).concat(string4);
                fileListTableModel.addEntry(i, new FileListEntry(string5, string6, externalFileType));
                continue;
            }
            ++this.unsuccesfullRenames;
        }
        if (bl) {
            String string7 = fileListTableModel.getStringRepresentation();
            assert (!string.equals(string7));
            bibtexEntry.setField("file", string7);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "file", string, string7));
        }
    }

    private void doConvertHTML(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("title");
        if (string == null) {
            return;
        }
        HTMLConverter hTMLConverter = new HTMLConverter();
        String string2 = hTMLConverter.format(string);
        if (!string.equals(string2)) {
            bibtexEntry.setField("title", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "title", string, string2));
        }
    }

    private void doConvertUnicode(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"title", "author", "abstract"}) {
            String string2 = bibtexEntry.getField(string);
            if (string2 == null) {
                return;
            }
            HTMLConverter hTMLConverter = new HTMLConverter();
            String string3 = hTMLConverter.formatUnicode(string2);
            if (string2.equals(string3)) continue;
            bibtexEntry.setField(string, string3);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string3));
        }
    }

    private void doConvertCase(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("title");
        if (string == null) {
            return;
        }
        CaseKeeper caseKeeper = new CaseKeeper();
        String string2 = caseKeeper.format(string);
        if (!string.equals(string2)) {
            bibtexEntry.setField("title", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "title", string, string2));
        }
    }

    private void doConvertUnits(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("title");
        if (string == null) {
            return;
        }
        UnitFormatter unitFormatter = new UnitFormatter();
        String string2 = unitFormatter.format(string);
        if (!string.equals(string2)) {
            bibtexEntry.setField("title", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "title", string, string2));
        }
    }

    private void doConvertLaTeX(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string = bibtexEntry.getField("title");
        if (string == null) {
            return;
        }
        String string2 = string;
        string2 = string2.replace("$$", "").replaceAll("(?<!\\\\[\\p{Alpha}]{0,100}\\{[^\\}]{0,100})\\}([-/ ]?)\\{", "$1");
        string2 = string2.replaceAll("(([^$]|\\\\\\$)*)\\$", "$1@@");
        string2 = string2.replaceAll("([^@]*)@@([^@]*)@@", "$1\\$$2@@");
        string2 = string2.replaceAll("([0-9\\(\\.]+[ ]?[-+/]?[ ]?)\\$", "\\$$1");
        string2 = string2.replaceAll("@@([ ]?[-+/]?[ ]?[0-9\\)\\.]+)", " $1@@");
        string2 = string2.replace("@@", "$");
        string2 = string2.replace("  ", " ");
        string2 = string2.replace("$$", "");
        if (!string.equals(string2 = string2.replace(" )$", ")$"))) {
            bibtexEntry.setField("title", string2);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "title", string, string2));
        }
    }

    private void doConvertToBiblatex(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string;
        for (Map.Entry<String, String> object : BibtexEntry.FieldAliasesOldToNew.entrySet()) {
            string = object.getKey();
            String string2 = object.getValue();
            String string3 = bibtexEntry.getField(string);
            String string4 = bibtexEntry.getField(string2);
            if (string3 == null || string3.length() <= 0 || string4 != null) continue;
            bibtexEntry.setField(string2, string3);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string2, null, string3));
            bibtexEntry.setField(string, null);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, null));
        }
        if (bibtexEntry.getField("date") == null || bibtexEntry.getField("date").length() == 0) {
            String string5 = bibtexEntry.getFieldOrAlias("date");
            String string6 = bibtexEntry.getField("year");
            string = bibtexEntry.getField("month");
            bibtexEntry.setField("date", string5);
            bibtexEntry.setField("year", null);
            bibtexEntry.setField("month", null);
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "date", null, string5));
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "year", string6, null));
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "month", string, null));
        }
    }
}

