/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.migrations;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.util.StringUtil;

public class VersionHandling {
    public static final int CURRENT_VERSION = 3;

    public static GroupTreeNode importFlatGroups(Vector<String> vector) throws IllegalArgumentException {
        GroupTreeNode groupTreeNode = new GroupTreeNode(new AllEntriesGroup());
        int n = vector.size() / 3;
        for (int i = 0; i < n; ++i) {
            String string = vector.get(3 * i);
            String string2 = vector.get(3 * i + 1);
            String string3 = vector.get(3 * i + 2);
            groupTreeNode.add(new GroupTreeNode(new KeywordGroup(string2, string, string3, false, true, GroupHierarchyType.INDEPENDENT)));
        }
        return groupTreeNode;
    }

    public static GroupTreeNode importGroups(Vector<String> vector, BibtexDatabase bibtexDatabase, int n) throws Exception {
        switch (n) {
            case 0: 
            case 1: {
                return Version0_1.fromString(vector.firstElement(), bibtexDatabase, n);
            }
            case 2: 
            case 3: {
                return Version2_3.fromString(vector, bibtexDatabase, n);
            }
        }
        throw new IllegalArgumentException(Globals.lang("Failed to read groups data (unsupported version: %0)", Integer.toString(n)));
    }

    private static class Version2_3 {
        private Version2_3() {
        }

        private static GroupTreeNode fromString(Vector<String> vector, BibtexDatabase bibtexDatabase, int n) throws Exception {
            GroupTreeNode groupTreeNode = null;
            GroupTreeNode groupTreeNode2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                String string = vector.elementAt(i);
                if ((string = string.trim()).length() == 0) continue;
                int n2 = string.indexOf(32);
                if (n2 <= 0) {
                    throw new Exception("bad format");
                }
                int n3 = Integer.parseInt(string.substring(0, n2));
                AbstractGroup abstractGroup = AbstractGroup.fromString(string.substring(n2 + 1), bibtexDatabase, n);
                GroupTreeNode groupTreeNode3 = new GroupTreeNode(abstractGroup);
                if (groupTreeNode == null) {
                    groupTreeNode2 = groupTreeNode = groupTreeNode3;
                    continue;
                }
                while (n3 <= groupTreeNode.getLevel()) {
                    groupTreeNode = (GroupTreeNode)groupTreeNode.getParent();
                }
                groupTreeNode.add(groupTreeNode3);
                groupTreeNode = groupTreeNode3;
            }
            return groupTreeNode2;
        }
    }

    private static class Version0_1 {
        private Version0_1() {
        }

        private static GroupTreeNode fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
            GroupTreeNode groupTreeNode = null;
            while (string.length() > 0) {
                int n2;
                GroupTreeNode groupTreeNode2;
                if (string.startsWith("(")) {
                    String string2 = Version0_1.getSubtree(string);
                    groupTreeNode2 = Version0_1.fromString(string2, bibtexDatabase, n);
                    n2 = 3 + string2.length();
                    string = n2 >= string.length() ? "" : string.substring(n2);
                } else {
                    n2 = Version0_1.indexOfUnquoted(string, ',');
                    String string3 = n2 < 0 ? string : string.substring(0, n2);
                    string = n2 >= 0 ? string.substring(n2 + 1) : "";
                    groupTreeNode2 = new GroupTreeNode(AbstractGroup.fromString(StringUtil.unquote(string3, '\\'), bibtexDatabase, n));
                }
                if (groupTreeNode == null) {
                    groupTreeNode = groupTreeNode2;
                    continue;
                }
                groupTreeNode.add(groupTreeNode2);
            }
            return groupTreeNode;
        }

        private static String getSubtree(String string) {
            int n = 1;
            block5: for (int i = 1; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '\\': {
                        ++i;
                        continue block5;
                    }
                    case '(': {
                        ++n;
                        continue block5;
                    }
                    case ')': {
                        if (--n != 0) continue block5;
                        return string.substring(1, i);
                    }
                }
            }
            return "";
        }

        private static int indexOfUnquoted(String string, char c) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\\') {
                    ++i;
                    continue;
                }
                if (string.charAt(i) != c) continue;
                return i;
            }
            return -1;
        }
    }
}

