/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AllEntriesGroup;

class UndoableResetGroups
extends AbstractUndoableEdit {
    private final GroupTreeNode m_groupsBackup;
    private final GroupTreeNode m_groupsRootHandle;
    private final GroupSelector m_groupSelector;
    private boolean m_revalidate = true;

    public UndoableResetGroups(GroupSelector groupSelector, GroupTreeNode groupTreeNode) {
        this.m_groupsBackup = groupTreeNode.deepCopy();
        this.m_groupsRootHandle = groupTreeNode;
        this.m_groupSelector = groupSelector;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("clear all groups");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("clear all groups");
    }

    @Override
    public void undo() {
        super.undo();
        this.m_groupsRootHandle.removeAllChildren();
        this.m_groupsRootHandle.setGroup(this.m_groupsBackup.getGroup().deepCopy());
        for (int i = 0; i < this.m_groupsBackup.getChildCount(); ++i) {
            this.m_groupsRootHandle.add(((GroupTreeNode)this.m_groupsBackup.getChildAt(i)).deepCopy());
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    @Override
    public void redo() {
        super.redo();
        this.m_groupsRootHandle.removeAllChildren();
        this.m_groupsRootHandle.setGroup(new AllEntriesGroup());
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean bl) {
        this.m_revalidate = bl;
    }
}

