/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.HashSet;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.ExplicitGroup;

public class UndoableChangeAssignment
extends AbstractUndoableEdit {
    private final Set<BibtexEntry> m_previousAssignmentBackup;
    private final Set<BibtexEntry> m_newAssignmentBackup;
    private int[] m_pathToNode = null;
    private GroupTreeNode m_groupsRootHandle = null;

    public UndoableChangeAssignment(Set<BibtexEntry> set, Set<BibtexEntry> set2) {
        this.m_previousAssignmentBackup = new HashSet<BibtexEntry>(set);
        this.m_newAssignmentBackup = new HashSet<BibtexEntry>(set2);
    }

    public UndoableChangeAssignment(Set<BibtexEntry> set, Set<BibtexEntry> set2, GroupTreeNode groupTreeNode) {
        this(set, set2);
        this.setEditedNode(groupTreeNode);
    }

    public void setEditedNode(GroupTreeNode groupTreeNode) {
        this.m_groupsRootHandle = (GroupTreeNode)groupTreeNode.getRoot();
        this.m_pathToNode = groupTreeNode.getIndexedPath();
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change assignment of entries");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change assignment of entries");
    }

    @Override
    public void undo() {
        super.undo();
        ExplicitGroup explicitGroup = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        explicitGroup.clearAssignments();
        for (BibtexEntry bibtexEntry : this.m_previousAssignmentBackup) {
            explicitGroup.addEntry(bibtexEntry);
        }
    }

    @Override
    public void redo() {
        super.redo();
        ExplicitGroup explicitGroup = (ExplicitGroup)this.m_groupsRootHandle.getChildAt(this.m_pathToNode).getGroup();
        explicitGroup.clearAssignments();
        for (BibtexEntry bibtexEntry : this.m_newAssignmentBackup) {
            explicitGroup.addEntry(bibtexEntry);
        }
    }
}

