/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.util.Util;

class AutoGroupDialog
extends JDialog
implements CaretListener {
    private final JTextField remove = new JTextField(60);
    private final JTextField field = new JTextField(60);
    private final JTextField deliminator = new JTextField(60);
    JLabel nf = new JLabel(Globals.lang("Field to group by") + ":");
    JLabel nr = new JLabel(Globals.lang("Characters to ignore") + ":");
    private final JRadioButton keywords = new JRadioButton(Globals.lang("Generate groups from keywords in a BibTeX field"));
    private final JRadioButton authors = new JRadioButton(Globals.lang("Generate groups for author last names"));
    private final JRadioButton editors = new JRadioButton(Globals.lang("Generate groups for editor last names"));
    private final JCheckBox nd = new JCheckBox(Globals.lang("Use the following delimiter character(s):"));
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private boolean ok_pressed = false;
    private final GroupTreeNode m_groupsRoot;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final GroupSelector gs;
    private String oldRemove;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public AutoGroupDialog(JabRefFrame jabRefFrame, BasePanel basePanel, GroupSelector groupSelector, GroupTreeNode groupTreeNode, String string, String string2, String string3) {
        super(jabRefFrame, Globals.lang("Automatically create groups"), true);
        this.frame = jabRefFrame;
        this.gs = groupSelector;
        this.panel = basePanel;
        this.m_groupsRoot = groupTreeNode;
        this.field.setText(string);
        this.remove.setText(string2);
        this.deliminator.setText(string3);
        this.nd.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                AutoGroupDialog.this.ok_pressed = true;
                AutoGroupDialog.this.dispose();
                GroupTreeNode groupTreeNode = new GroupTreeNode(new ExplicitGroup(Globals.lang("Automatically created groups"), GroupHierarchyType.INCLUDING));
                Set<String> set = null;
                String string = AutoGroupDialog.this.field();
                if (AutoGroupDialog.this.keywords.isSelected()) {
                    set = AutoGroupDialog.this.nd.isSelected() ? Util.findDeliminatedWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.deliminator.getText()) : Util.findAllWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.remove());
                } else if (AutoGroupDialog.this.authors.isSelected()) {
                    serializable = new ArrayList<String>(2);
                    serializable.add("author");
                    set = Util.findAuthorLastNames(AutoGroupDialog.this.panel.getDatabase(), serializable);
                    string = "author";
                } else if (AutoGroupDialog.this.editors.isSelected()) {
                    serializable = new ArrayList<String>(2);
                    serializable.add("editor");
                    set = Util.findAuthorLastNames(AutoGroupDialog.this.panel.getDatabase(), serializable);
                    string = "editor";
                }
                for (String object2 : set) {
                    KeywordGroup keywordGroup = new KeywordGroup(object2, string, object2, false, false, GroupHierarchyType.INDEPENDENT);
                    groupTreeNode.add(new GroupTreeNode(keywordGroup));
                }
                AutoGroupDialog.this.m_groupsRoot.add(groupTreeNode);
                serializable = new NamedCompound(Globals.lang("Autogenerate groups"));
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(AutoGroupDialog.this.gs, AutoGroupDialog.this.m_groupsRoot, groupTreeNode, 0);
                undoableAddOrRemoveGroup.setRevalidate(true);
                ((NamedCompound)serializable).addEdit(undoableAddOrRemoveGroup);
                AutoGroupDialog.this.panel.markBaseChanged();
                AutoGroupDialog.this.gs.revalidateGroups();
                AutoGroupDialog.this.frame.output(Globals.lang("Created groups."));
                ((CompoundEdit)serializable).end();
                ((AutoGroupDialog)AutoGroupDialog.this).panel.undoManager.addEdit((UndoableEdit)((Object)serializable));
            }
        };
        this.remove.addActionListener(actionListener);
        this.field.addActionListener(actionListener);
        this.field.addCaretListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoGroupDialog.this.dispose();
            }
        };
        JButton jButton = new JButton(Globals.lang("Cancel"));
        jButton.addActionListener(abstractAction);
        this.ok.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.keywords);
        buttonGroup.add(this.authors);
        buttonGroup.add(this.editors);
        this.keywords.setSelected(true);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:20dlu, 4dlu, left:pref, 4dlu, fill:60dlu, 4dlu, fill:0dlu", ""), jPanel);
        defaultFormBuilder.append((Component)this.keywords, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(Globals.lang("Field to group by") + ":");
        defaultFormBuilder.append(this.field);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(Globals.lang("Characters to ignore") + ":");
        defaultFormBuilder.append(this.remove);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.nd);
        defaultFormBuilder.append(this.deliminator);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.authors, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.editors, 5);
        defaultFormBuilder.nextLine();
        JPanel jPanel2 = new JPanel();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addGlue();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.updateComponents();
        this.pack();
        Util.placeDialog(this, this.frame);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldRemove() {
        return this.oldRemove;
    }

    private String field() {
        return this.field.getText();
    }

    private String remove() {
        return this.remove.getText();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateComponents();
    }

    private void updateComponents() {
        String string = this.field.getText().trim();
        this.ok.setEnabled(string.matches("\\w+"));
    }
}

