/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.util.Util;

public class AddToGroupAction
extends AbstractAction {
    private GroupTreeNode m_node;
    private final boolean m_move;
    private BasePanel m_panel;

    public AddToGroupAction(GroupTreeNode groupTreeNode, boolean bl, BasePanel basePanel) {
        super(groupTreeNode.getGroup().getName());
        this.m_node = groupTreeNode;
        this.m_move = bl;
        this.m_panel = basePanel;
    }

    public AddToGroupAction(boolean bl) {
        super(bl ? Globals.lang("Assign entry selection exclusively to this group") : Globals.lang("Add entry selection to this group"));
        this.m_move = bl;
    }

    public void setBasePanel(BasePanel basePanel) {
        this.m_panel = basePanel;
    }

    public void setNode(GroupTreeNode groupTreeNode) {
        this.m_node = groupTreeNode;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        Object object2;
        BibtexEntry[] bibtexEntryArray = this.m_panel.getSelectedEntries();
        Vector<GroupTreeNode> vector = new Vector<GroupTreeNode>();
        if (this.m_move) {
            object2 = ((GroupTreeNode)this.m_node.getRoot()).preorderEnumeration();
            while (object2.hasMoreElements()) {
                serializable = object2.nextElement();
                if (!serializable.getGroup().supportsRemove()) continue;
                for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                    if (!serializable.getGroup().contains(bibtexEntry)) continue;
                    vector.add((GroupTreeNode)serializable);
                }
            }
            object = new AbstractGroup[vector.size() + 1];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = ((GroupTreeNode)vector.elementAt(i)).getGroup();
            }
            object[((Object[])object).length - 1] = this.m_node.getGroup();
            if (!Util.warnAssignmentSideEffects((AbstractGroup[])object, bibtexEntryArray, this.m_panel.getDatabase(), this.m_panel.frame())) {
                return;
            }
        } else if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_node.getGroup()}, bibtexEntryArray, this.m_panel.getDatabase(), this.m_panel.frame())) {
            return;
        }
        this.m_panel.storeCurrentEdit();
        object2 = new NamedCompound(Globals.lang("change assignment of entries"));
        if (this.m_move) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (GroupTreeNode)vector.elementAt(i);
                if (!((GroupTreeNode)object).getGroup().containsAny(bibtexEntryArray)) continue;
                ((NamedCompound)object2).addEdit(((GroupTreeNode)object).removeFromGroup(bibtexEntryArray));
            }
            AbstractUndoableEdit abstractUndoableEdit = this.m_node.addToGroup(bibtexEntryArray);
            if (abstractUndoableEdit != null) {
                ((NamedCompound)object2).addEdit(abstractUndoableEdit);
            }
        } else {
            serializable = this.m_node.addToGroup(bibtexEntryArray);
            if (serializable == null) {
                return;
            }
            ((NamedCompound)object2).addEdit((UndoableEdit)((Object)serializable));
        }
        ((CompoundEdit)object2).end();
        this.m_panel.undoManager.addEdit((UndoableEdit)object2);
        this.m_panel.markBaseChanged();
        this.m_panel.updateEntryEditorIfShowing();
        this.m_panel.getGroupSelector().valueChanged(null);
    }
}

