/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;

public class SynchronizeFileField
extends AbstractWorker {
    private final String fieldName = "file";
    private final BasePanel panel;
    private BibtexEntry[] sel = null;
    private OptionsDialog optDiag = null;
    private final Object[] brokenLinkOptions = new Object[]{Globals.lang("Ignore"), Globals.lang("Assign new file"), Globals.lang("Remove link"), Globals.lang("Remove all broken links"), Globals.lang("Quit synchronization")};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean checkExisting = true;

    public SynchronizeFileField(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public void init() {
        Collection<BibtexEntry> collection = this.panel.database().getEntries();
        this.goOn = true;
        this.sel = new BibtexEntry[collection.size()];
        this.sel = collection.toArray(this.sel);
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.panel.metaData(), "file");
        }
        Util.placeDialog(this.optDiag, this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.autoSetNone.isSelected();
        this.checkExisting = this.optDiag.checkLinks.isSelected();
        this.panel.output(Globals.lang("Synchronizing %0 links...", "file".toUpperCase()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (!this.goOn) {
            this.panel.output(Globals.lang("No entries selected."));
            return;
        }
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int n = 10;
        int n2 = (this.autoSet ? n * this.sel.length : 0) + (this.checkExisting ? this.sel.length : 0);
        this.panel.frame().setProgressBarMaximum(n2);
        int n3 = 0;
        int n4 = 0;
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Autoset %0 field", "file"));
        HashSet<BibtexEntry> hashSet = new HashSet<BibtexEntry>();
        if (this.autoSet) {
            ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
            Collections.addAll(arrayList, this.sel);
            BibtexEntry[] bibtexEntryArray = Util.autoSetLinks(arrayList, namedCompound, hashSet, null, this.panel.metaData(), null, null);
            JabRefExecutorService.INSTANCE.executeAndWait((Runnable)bibtexEntryArray);
        }
        this.panel.frame().setProgressBarValue(n3 += this.sel.length * n);
        if (this.checkExisting) {
            boolean bl = false;
            block6: for (BibtexEntry bibtexEntry : this.sel) {
                this.panel.frame().setProgressBarValue(n3++);
                String string = bibtexEntry.getField("file");
                if (string == null || string.equals("")) continue;
                FileListTableModel fileListTableModel = new FileListTableModel();
                fileListTableModel.setContentDontGuessTypes(string);
                String[] stringArray = this.panel.metaData().getFileDirectory("file");
                ArrayList<File> arrayList = new ArrayList<File>();
                for (String string2 : stringArray) {
                    arrayList.add(new File(string2));
                }
                for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                    Object object;
                    Object object2;
                    FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                    int n5 = fileListEntry.getLink().toLowerCase().startsWith("http") ? 1 : 0;
                    if (n5 != 0) continue;
                    boolean bl2 = false;
                    File file = FileUtil.expandFilename(fileListEntry.getLink(), stringArray);
                    if (file == null || !file.exists()) {
                        int n6 = !bl ? JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", new String[]{fileListEntry.getLink(), bibtexEntry.getCiteKey()}), Globals.lang("Broken link"), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]) : 2;
                        switch (n6) {
                            case 1: {
                                object2 = new FileListEntryEditor(this.panel.frame(), fileListEntry, false, true, this.panel.metaData());
                                ((FileListEntryEditor)object2).setVisible(true, true);
                                break;
                            }
                            case 2: {
                                fileListTableModel.removeEntry(i);
                                bl2 = true;
                                --i;
                                break;
                            }
                            case 3: {
                                fileListTableModel.removeEntry(i);
                                bl2 = true;
                                --i;
                                bl = true;
                                break;
                            }
                            case 4: {
                                break block6;
                            }
                        }
                        ++n4;
                    }
                    if (bl2 || !(fileListEntry.getType() instanceof UnknownExternalFileType)) continue;
                    Object[] objectArray = new String[]{Globals.lang("Define '%0'", fileListEntry.getType().getName()), Globals.lang("Change file type"), Globals.lang("Cancel")};
                    object2 = objectArray[0];
                    int n7 = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("One or more file links are of the type '%0', which is undefined. What do you want to do?", fileListEntry.getType().getName()), Globals.lang("Undefined file type"), 1, 3, null, objectArray, object2);
                    if (n7 == 2) continue;
                    if (n7 == 0) {
                        object = new ExternalFileType(fileListEntry.getType().getName(), "", "", "", "new");
                        ExternalFileTypeEntryEditor externalFileTypeEntryEditor = new ExternalFileTypeEntryEditor(this.panel.frame(), (ExternalFileType)object);
                        externalFileTypeEntryEditor.setVisible(true);
                        if (!externalFileTypeEntryEditor.okPressed()) continue;
                        ArrayList<ExternalFileType> arrayList2 = new ArrayList<ExternalFileType>();
                        ExternalFileType[] externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection();
                        Collections.addAll(arrayList2, externalFileTypeArray);
                        arrayList2.add((ExternalFileType)object);
                        Collections.sort(arrayList2);
                        Globals.prefs.setExternalFileTypes(arrayList2);
                        this.panel.mainTable.repaint();
                        continue;
                    }
                    object = new FileListEntryEditor(this.panel.frame(), fileListEntry, false, true, this.panel.metaData());
                    ((FileListEntryEditor)object).setVisible(true, false);
                }
                if (fileListTableModel.getStringRepresentation().equals(string)) continue;
                String string3 = fileListTableModel.getStringRepresentation();
                if (string3.length() == 0) {
                    string3 = null;
                }
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "file", string, string3));
                bibtexEntry.setField("file", string3);
                hashSet.add(bibtexEntry);
            }
        }
        if (!hashSet.isEmpty()) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
            this.panel.markBaseChanged();
        }
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        int n = 0;
        this.panel.output(Globals.lang("Finished synchronizing %0 links. Entries changed%c %1.", new String[]{"file".toUpperCase(), String.valueOf(n)}));
        this.panel.frame().setProgressBarVisible(false);
        if (n > 0) {
            this.panel.markBaseChanged();
        }
    }

    static class OptionsDialog
    extends JDialog {
        final JRadioButton autoSetUnset;
        final JRadioButton autoSetAll;
        final JRadioButton autoSetNone;
        final JCheckBox checkLinks;
        final JButton ok = new JButton(Globals.lang("Ok"));
        final JButton cancel = new JButton(Globals.lang("Cancel"));
        JLabel description;
        private boolean canceled = true;
        private final MetaData metaData;

        public OptionsDialog(JFrame jFrame, MetaData metaData, String string) {
            super(jFrame, Globals.lang("Synchronize %0 links", string.toUpperCase()), true);
            this.metaData = metaData;
            String string2 = Globals.lang("file");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.canceled = false;
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.dispose();
                }
            };
            this.cancel.addActionListener(abstractAction);
            InputMap inputMap = this.cancel.getInputMap(2);
            ActionMap actionMap = this.cancel.getActionMap();
            inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
            actionMap.put("close", abstractAction);
            this.autoSetUnset = new JRadioButton(Globals.lang("Autoset %0 links. Do not overwrite existing links.", string2), true);
            this.autoSetAll = new JRadioButton(Globals.lang("Autoset %0 links. Allow overwriting existing links.", string2), false);
            this.autoSetNone = new JRadioButton(Globals.lang("Do not autoset"), false);
            this.checkLinks = new JCheckBox(Globals.lang("Check existing %0 links", string2), true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.autoSetUnset);
            buttonGroup.add(this.autoSetNone);
            buttonGroup.add(this.autoSetAll);
            FormLayout formLayout = new FormLayout("fill:pref", "");
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
            this.description = new JLabel("<HTML>" + Globals.lang("Attempt to autoset %0 links for your entries. Autoset works if a %0 file in your %0 directory or a subdirectory<BR>is named identically to an entry's BibTeX key, plus extension.", string2) + "</HTML>");
            defaultFormBuilder.appendSeparator(Globals.lang("Autoset"));
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetUnset);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetAll);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetNone);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(Globals.lang("Check links"));
            this.description = new JLabel("<HTML>" + Globals.lang("This makes JabRef look up each %0 extension and check if the file exists. If not, you will be given options<BR>to resolve the problem.", string2) + "</HTML>");
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.checkLinks);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator();
            JPanel jPanel = defaultFormBuilder.getPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addButton((JComponent)this.ok);
            buttonBarBuilder.addButton((JComponent)this.cancel);
            buttonBarBuilder.addGlue();
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
            this.pack();
        }

        @Override
        public void setVisible(boolean bl) {
            String[] stringArray;
            if (bl) {
                this.canceled = true;
            }
            if ((stringArray = this.metaData.getFileDirectory("file")).length == 0) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            new FocusRequester(this.ok);
            super.setVisible(bl);
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

