/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToVim
implements PushToApplication {
    private JPanel settings = null;
    private final JTextField vimPath = new JTextField(30);
    private final JTextField vimServer = new JTextField(30);
    private final JTextField citeCommand = new JTextField(30);
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into Vim");
    }

    @Override
    public String getApplicationName() {
        return "Vim";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to Vim");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("vim");
    }

    @Override
    public String getKeyStrokeName() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.vimPath.setText(Globals.prefs.get("vim"));
        this.vimServer.setText(Globals.prefs.get("vimServer"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandVim"));
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("vim", this.vimPath.getText());
        Globals.prefs.put("vimServer", this.vimServer.getText());
        Globals.prefs.put("citeCommandVim", this.citeCommand.getText());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(new JLabel(Globals.lang("Path to Vim") + ":"));
        defaultFormBuilder.append(this.vimPath);
        BrowseAction browseAction = BrowseAction.buildForFile(this.vimPath);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(browseAction);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Vim Server Name") + ":");
        defaultFormBuilder.append(this.vimServer);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Cite command") + ":");
        defaultFormBuilder.append(this.citeCommand);
        this.settings = defaultFormBuilder.getPanel();
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        try {
            String[] stringArray = new String[]{Globals.prefs.get("vim"), "--servername", Globals.prefs.get("vimServer"), "--remote-send", "<C-\\><C-N>a" + Globals.prefs.get("citeCommandVim") + "{" + string + "}"};
            final Process process = Runtime.getRuntime().exec(stringArray);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = process.getErrorStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        int n;
                        while ((n = inputStream.read()) != -1) {
                            stringBuilder.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (stringBuilder.toString().trim().length() > 0) {
                        System.out.println(stringBuilder.toString());
                        PushToVim.this.couldNotConnect = true;
                    }
                }
            };
            JabRefExecutorService.INSTANCE.executeAndWait(runnable);
        }
        catch (IOException iOException) {
            this.couldNotRunClient = true;
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(basePanel.frame(), "<HTML>" + Globals.lang("Could not connect to Vim server. Make sure that Vim is running<BR>with correct server name.") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(basePanel.frame(), Globals.lang("Could not run the 'vim' program."), Globals.lang("Error"), 0);
        } else {
            basePanel.output(Globals.lang("Pushed citations to Vim"));
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }
}

