/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToLyx
implements PushToApplication {
    private final JTextField lyxPipe = new JTextField(30);
    private JPanel settings = null;
    private boolean couldNotFindPipe = false;
    private boolean couldNotWrite = false;

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, final String string, MetaData metaData) {
        File file;
        this.couldNotFindPipe = false;
        this.couldNotWrite = false;
        String string2 = Globals.prefs.get("lyxpipe");
        if (!string2.endsWith(".in")) {
            string2 = string2 + ".in";
        }
        if (!((file = new File(string2)).exists() && file.canWrite() || (file = new File(string2 + ".in")).exists() && file.canWrite())) {
            this.couldNotFindPipe = true;
            return;
        }
        final File file2 = file;
        JabRefExecutorService.INSTANCE.executeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    FileWriter fileWriter = new FileWriter(file2);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    String string2 = "LYXCMD:sampleclient:citation-insert:" + string;
                    bufferedWriter.write(string2 + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    PushToLyx.this.couldNotWrite = true;
                }
            }
        });
    }

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into LyX/Kile");
    }

    @Override
    public String getApplicationName() {
        return "LyX/Kile";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to LyX/Kile");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("lyx");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to LyX";
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotFindPipe) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("verify that LyX is running and that the lyxpipe is valid") + ". [" + Globals.prefs.get("lyxpipe") + "]");
        } else if (this.couldNotWrite) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("unable to write to") + " " + Globals.prefs.get("lyxpipe") + ".in");
        } else {
            String string = "";
            basePanel.output(Globals.lang("Pushed the citations for the following rows to") + " Lyx: " + string);
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.lyxPipe.setText(Globals.prefs.get("lyxpipe"));
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("lyxpipe", this.lyxPipe.getText());
    }

    private void initSettingsPanel() {
        this.settings = new JPanel();
        this.settings.add(new JLabel(Globals.lang("Path to LyX pipe") + ":"));
        this.settings.add(this.lyxPipe);
    }
}

