/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToLatexEditor
implements PushToApplication {
    private boolean couldNotCall = false;
    private boolean notDefined = false;
    private JPanel settings = null;
    private final JTextField ledPath = new JTextField(30);
    private final JTextField citeCommand = new JTextField(30);

    @Override
    public String getName() {
        return Globals.menuTitle("Insert selected citations into LatexEditor");
    }

    @Override
    public String getApplicationName() {
        return "LatexEditor";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push to LatexEditor");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("edit");
    }

    @Override
    public String getKeyStrokeName() {
        return null;
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        this.couldNotCall = false;
        this.notDefined = false;
        String string2 = Globals.prefs.get("latexEditorPath");
        if (string2 == null || string2.trim().length() == 0) {
            this.notDefined = true;
            return;
        }
        try {
            Runtime.getRuntime().exec(string2 + " " + "-i " + Globals.prefs.get("citeCommandLed") + "{" + string + "}");
        }
        catch (IOException iOException) {
            this.couldNotCall = true;
            iOException.printStackTrace();
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.notDefined) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("Path to %0 not defined", this.getApplicationName()) + ".");
        } else if (this.couldNotCall) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("Could not call executable") + " '" + Globals.prefs.get("latexEditorPath") + "'.");
        } else {
            Globals.lang("Pushed citations to %0", "LatexEditor");
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.ledPath.setText(Globals.prefs.get("latexEditorPath"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandLed"));
        return this.settings;
    }

    private void initSettingsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(new JLabel(Globals.lang("Path to LatexEditor (LEd.exe)") + ":"));
        defaultFormBuilder.append(this.ledPath);
        BrowseAction browseAction = BrowseAction.buildForFile(this.ledPath);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(browseAction);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Cite command") + ":");
        defaultFormBuilder.append(this.citeCommand);
        this.settings = defaultFormBuilder.getPanel();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("latexEditorPath", this.ledPath.getText());
        Globals.prefs.put("citeCommandLed", this.citeCommand.getText());
    }
}

