/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationAction;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToTeXstudio;
import net.sf.jabref.external.PushToVim;
import net.sf.jabref.external.PushToWinEdt;
import net.sf.jabref.oo.OpenOfficePanel;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;

public class PushToApplicationButton
implements ActionListener {
    public static final List<PushToApplication> applications;
    private final JabRefFrame frame;
    private final List<PushToApplication> pushActions;
    private JPanel comp;
    private JButton pushButton;
    private JButton menuButton;
    private int selected = 0;
    private JPopupMenu popup = null;
    private final HashMap<PushToApplication, PushToApplicationAction> actions = new HashMap();
    private final Dimension buttonDim = new Dimension(23, 23);
    private static final URL ARROW_ICON;
    private final MenuAction mAction = new MenuAction();
    private final JPopupMenu optPopup = new JPopupMenu();
    private final JMenuItem settings = new JMenuItem(Globals.lang("Settings"));

    public PushToApplicationButton(JabRefFrame jabRefFrame, List<PushToApplication> list) {
        this.frame = jabRefFrame;
        this.pushActions = list;
        this.init();
    }

    private void init() {
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        this.menuButton = new JButton(new ImageIcon(ARROW_ICON));
        this.menuButton.setMargin(new Insets(0, 0, 0, 0));
        this.menuButton.setPreferredSize(new Dimension(this.menuButton.getIcon().getIconWidth(), this.menuButton.getIcon().getIconHeight()));
        this.menuButton.addActionListener(new MenuButtonActionListener());
        this.menuButton.setToolTipText(Globals.lang("Select external application"));
        this.pushButton = new JButton();
        if (Globals.prefs.hasKey("pushToApplication")) {
            String string = Globals.prefs.get("pushToApplication");
            for (int i = 0; i < this.pushActions.size(); ++i) {
                PushToApplication pushToApplication = this.pushActions.get(i);
                if (!pushToApplication.getName().equals(string)) continue;
                this.selected = i;
                break;
            }
        }
        this.setSelected(this.selected);
        this.pushButton.addActionListener(this);
        this.pushButton.addMouseListener(new PushButtonMouseListener());
        this.pushButton.setOpaque(false);
        this.menuButton.setOpaque(false);
        this.comp.setOpaque(false);
        this.comp.add((Component)this.pushButton, "Center");
        this.comp.add((Component)this.menuButton, "East");
        this.comp.setMaximumSize(this.comp.getPreferredSize());
        this.optPopup.add(this.settings);
        this.settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PushToApplication pushToApplication = (PushToApplication)PushToApplicationButton.this.pushActions.get(PushToApplicationButton.this.selected);
                JPanel jPanel = pushToApplication.getSettingsPanel();
                if (jPanel != null) {
                    PushToApplicationButton.showSettingsDialog(PushToApplicationButton.this.frame, pushToApplication, jPanel);
                }
            }
        });
        this.buildPopupMenu();
    }

    private void buildPopupMenu() {
        this.popup = new JPopupMenu();
        int n = 0;
        for (PushToApplication pushToApplication : this.pushActions) {
            JMenuItem jMenuItem = new JMenuItem(pushToApplication.getApplicationName(), pushToApplication.getIcon());
            jMenuItem.setToolTipText(pushToApplication.getTooltip());
            jMenuItem.addActionListener(new PopupItemActionListener(n));
            this.popup.add(jMenuItem);
            ++n;
        }
    }

    private void setSelected(int n) {
        this.selected = n;
        PushToApplication pushToApplication = this.pushActions.get(n);
        this.pushButton.setIcon(pushToApplication.getIcon());
        this.pushButton.setToolTipText(pushToApplication.getTooltip());
        this.pushButton.setPreferredSize(this.buttonDim);
        Globals.prefs.put("pushToApplication", pushToApplication.getName());
        this.mAction.setTitle(pushToApplication.getApplicationName());
    }

    public Component getComponent() {
        return this.comp;
    }

    public Action getMenuAction() {
        return this.mAction;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PushToApplication pushToApplication = this.pushActions.get(this.selected);
        PushToApplicationAction pushToApplicationAction = this.actions.get(pushToApplication);
        if (pushToApplicationAction == null) {
            pushToApplicationAction = new PushToApplicationAction(this.frame, pushToApplication);
            this.actions.put(pushToApplication, pushToApplicationAction);
        }
        pushToApplicationAction.actionPerformed(new ActionEvent(pushToApplication, 0, "push"));
    }

    public static void showSettingsDialog(Object object, PushToApplication pushToApplication, JPanel jPanel) {
        final BooleanHolder booleanHolder = new BooleanHolder(false);
        JDialog jDialog = object instanceof JDialog ? new JDialog((JDialog)object, Globals.lang("Settings"), true) : new JDialog((JFrame)object, Globals.lang("Settings"), true);
        final JDialog jDialog2 = jDialog;
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jDialog2.getContentPane().add((Component)jPanel, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jDialog2.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                booleanHolder.value = true;
                jDialog2.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.dispose();
            }
        });
        ActionMap actionMap = buttonBarBuilder.getPanel().getActionMap();
        InputMap inputMap = buttonBarBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.dispose();
            }
        });
        jDialog2.pack();
        if (object instanceof JDialog) {
            jDialog2.setLocationRelativeTo((JDialog)object);
        } else {
            jDialog2.setLocationRelativeTo((JFrame)object);
        }
        jDialog2.setVisible(true);
        if (booleanHolder.value) {
            pushToApplication.storeSettings();
        }
    }

    static {
        ARROW_ICON = GUIGlobals.class.getResource("/images/secondary_sorted_reverse.png");
        applications = new ArrayList<PushToApplication>();
        JabRefPlugin jabRefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabRefPlugin != null) {
            List<_JabRefPlugin.PushToApplicationExtension> list = jabRefPlugin.getPushToApplicationExtensions();
            for (_JabRefPlugin.PushToApplicationExtension pushToApplicationExtension : list) {
                applications.add(pushToApplicationExtension.getPushToApp());
            }
            applications.add(new PushToLyx());
            applications.add(new PushToEmacs());
            applications.add(new PushToWinEdt());
            applications.add(new PushToLatexEditor());
            applications.add(new PushToVim());
            applications.add(OpenOfficePanel.getInstance());
            applications.add(new PushToTeXstudio());
        }
    }

    private static class PushToApplicationComparator
    implements Comparator<PushToApplication> {
        private PushToApplicationComparator() {
        }

        @Override
        public int compare(PushToApplication pushToApplication, PushToApplication pushToApplication2) {
            return pushToApplication.getName().compareTo(pushToApplication2.getName());
        }
    }

    class PushButtonMouseListener
    extends MouseAdapter {
        PushButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        private void processPopupTrigger(MouseEvent mouseEvent) {
            PushToApplication pushToApplication = (PushToApplication)PushToApplicationButton.this.pushActions.get(PushToApplicationButton.this.selected);
            if (pushToApplication.getSettingsPanel() != null) {
                PushToApplicationButton.this.optPopup.show(PushToApplicationButton.this.pushButton, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class MenuAction
    extends MnemonicAwareAction {
        public MenuAction() {
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Push to application"));
        }

        public void setTitle(String string) {
            this.putValue("Name", Globals.lang("Push entries to external application (%0)", string));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PushToApplicationButton.this.actionPerformed(null);
        }
    }

    private class MenuButtonActionListener
    implements ActionListener {
        private MenuButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PushToApplicationButton.this.popup == null) {
                PushToApplicationButton.this.buildPopupMenu();
            }
            PushToApplicationButton.this.popup.show(PushToApplicationButton.this.comp, 0, PushToApplicationButton.this.menuButton.getHeight());
        }
    }

    class PopupItemActionListener
    implements ActionListener {
        private final int index;

        public PopupItemActionListener(int n) {
            this.index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PushToApplicationButton.this.setSelected(this.index);
            PushToApplicationButton.this.pushButton.requestFocus();
        }
    }

    static class BooleanHolder {
        public boolean value;

        public BooleanHolder(boolean bl) {
            this.value = bl;
        }
    }
}

