/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.PushToApplication;

class PushToApplicationAction
extends AbstractAction
implements Runnable {
    private final PushToApplication operation;
    private final JabRefFrame frame;
    private BasePanel panel;
    private BibtexEntry[] entries;

    public PushToApplicationAction(JabRefFrame jabRefFrame, PushToApplication pushToApplication) {
        this.frame = jabRefFrame;
        this.putValue("SmallIcon", pushToApplication.getIcon());
        this.putValue("Name", pushToApplication.getName());
        this.putValue("ShortDescription", pushToApplication.getTooltip());
        if (pushToApplication.getKeyStrokeName() != null) {
            this.putValue("AcceleratorKey", Globals.prefs.getKey(pushToApplication.getKeyStrokeName()));
        }
        this.operation = pushToApplication;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.panel = this.frame.basePanel();
        if (this.panel == null) {
            return;
        }
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.length == 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires one or more entries to be selected."), (String)this.getValue("Name"), 0);
            return;
        }
        if (this.operation.requiresBibtexKeys()) {
            for (BibtexEntry bibtexEntry : this.entries) {
                if (bibtexEntry.getCiteKey() != null && bibtexEntry.getCiteKey().trim().length() != 0) continue;
                JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires all selected entries to have BibTex keys defined."), (String)this.getValue("Name"), 0);
                return;
            }
        }
        JabRefExecutorService.INSTANCE.execute(this);
    }

    @Override
    public void run() {
        this.operation.pushEntries(this.panel.database(), this.entries, this.getKeyString(this.entries), this.panel.metaData());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PushToApplicationAction.this.operation.operationCompleted(PushToApplicationAction.this.panel);
            }
        });
    }

    private String getKeyString(BibtexEntry[] bibtexEntryArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            String string = bibtexEntry.getField("bibtexkey");
            if (string == null || string.equals("")) continue;
            if (bl) {
                stringBuilder.append(string);
                bl = false;
                continue;
            }
            stringBuilder.append(",").append(string);
        }
        return stringBuilder.toString();
    }
}

