/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.AbstractButtonPanelBuilder;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.IconSelection;
import net.sf.jabref.gui.FileDialogs;

public class ExternalFileTypeEntryEditor {
    private JFrame fParent = null;
    private JDialog dParent = null;
    private JDialog diag;
    private final JTextField extension = new JTextField();
    private final JTextField name = new JTextField();
    private final JTextField mimeType = new JTextField();
    private final JTextField application = new JTextField();
    private String selectedIcon = null;
    private final JButton icon = new JButton(GUIGlobals.getImage("picture"));
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private final JRadioButton useDefault = new JRadioButton(Globals.lang("Default"));
    private final JRadioButton other = new JRadioButton("");
    final String emptyMessage = "<" + Globals.lang("Use default viewer") + ">";
    boolean applicationFieldEmpty = false;
    private ExternalFileType entry;
    private boolean okPressed = false;

    public ExternalFileTypeEntryEditor(JFrame jFrame, ExternalFileType externalFileType) {
        this.fParent = jFrame;
        this.init(externalFileType);
    }

    public ExternalFileTypeEntryEditor(JDialog jDialog, ExternalFileType externalFileType) {
        this.dParent = jDialog;
        this.init(externalFileType);
    }

    private void init(ExternalFileType externalFileType) {
        Object object;
        Object object2;
        this.entry = externalFileType;
        this.icon.setText(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useDefault);
        buttonGroup.add(this.other);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(Globals.lang("Icon"));
        defaultFormBuilder.append(this.icon);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Name"));
        defaultFormBuilder.append(this.name);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Extension"));
        defaultFormBuilder.append(this.extension);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("MIME type"));
        defaultFormBuilder.append(this.mimeType);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Application"));
        JButton jButton = new JButton(Globals.lang("Browse"));
        if (Globals.ON_WIN) {
            defaultFormBuilder.append(this.useDefault);
            defaultFormBuilder.nextLine();
            object2 = new JPanel();
            defaultFormBuilder.append((Component)object2);
            object = new JPanel();
            this.application.setPreferredSize(new Dimension(300, this.application.getPreferredSize().height));
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(4);
            ((Container)object).setLayout(borderLayout);
            ((Container)object).add((Component)this.other, "West");
            ((Container)object).add((Component)this.application, "Center");
            defaultFormBuilder.append((Component)object);
            defaultFormBuilder.append(jButton);
        } else {
            defaultFormBuilder.append(this.application);
            defaultFormBuilder.append(jButton);
        }
        object2 = new ButtonBarBuilder();
        ((ButtonBarBuilder)object2).addGlue();
        ((ButtonBarBuilder)object2).addButton((JComponent)this.ok);
        ((ButtonBarBuilder)object2).addButton((JComponent)this.cancel);
        ((ButtonBarBuilder)object2).addGlue();
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFileTypeEntryEditor.this.okPressed = true;
                ExternalFileTypeEntryEditor.this.storeSettings(ExternalFileTypeEntryEditor.this.entry);
                ExternalFileTypeEntryEditor.this.diag.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFileTypeEntryEditor.this.diag.dispose();
            }
        });
        this.icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ExternalFileTypeEntryEditor.this.entry.getIconName();
                if (ExternalFileTypeEntryEditor.this.selectedIcon != null) {
                    string = ExternalFileTypeEntryEditor.this.selectedIcon;
                }
                IconSelection iconSelection = new IconSelection(ExternalFileTypeEntryEditor.this.diag, string);
                iconSelection.setVisible(true);
                if (iconSelection.isOkPressed()) {
                    ExternalFileTypeEntryEditor.this.selectedIcon = iconSelection.getSelectedIconKey();
                    ExternalFileTypeEntryEditor.this.icon.setIcon(GUIGlobals.getImage(ExternalFileTypeEntryEditor.this.selectedIcon));
                }
            }
        });
        if (Globals.ON_WIN) {
            this.application.getDocument().addDocumentListener(new DocumentListener(){

                private void handle(DocumentEvent documentEvent) {
                    if (ExternalFileTypeEntryEditor.this.application.getText().length() == 0) {
                        ExternalFileTypeEntryEditor.this.useDefault.setSelected(true);
                    } else {
                        ExternalFileTypeEntryEditor.this.other.setSelected(true);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.handle(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.handle(documentEvent);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.handle(documentEvent);
                }
            });
        }
        this.diag = this.dParent != null ? new JDialog(this.dParent, Globals.lang("Edit file type"), true) : new JDialog(this.fParent, Globals.lang("Edit file type"), true);
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)((AbstractButtonPanelBuilder)object2).getPanel(), "South");
        this.diag.pack();
        object = new BrowseListener(this.diag, this.application);
        jButton.addActionListener((ActionListener)object);
        if (this.dParent != null) {
            this.diag.setLocationRelativeTo(this.dParent);
        } else {
            this.diag.setLocationRelativeTo(this.fParent);
        }
        this.setValues(externalFileType);
    }

    public void setEntry(ExternalFileType externalFileType) {
        this.entry = externalFileType;
        this.setValues(externalFileType);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.okPressed = false;
        }
        this.diag.setVisible(bl);
    }

    private void setValues(ExternalFileType externalFileType) {
        this.name.setText(externalFileType.getName());
        this.extension.setText(externalFileType.getExtension());
        this.mimeType.setText(externalFileType.getMimeType());
        this.application.setText(externalFileType.getOpenWith());
        this.icon.setIcon(externalFileType.getIcon());
        if (this.application.getText().length() == 0) {
            this.useDefault.setSelected(true);
        } else {
            this.other.setSelected(true);
        }
        this.selectedIcon = null;
    }

    private void storeSettings(ExternalFileType externalFileType) {
        externalFileType.setName(this.name.getText().trim());
        externalFileType.setMimeType(this.mimeType.getText().trim());
        String string = this.extension.getText().trim();
        if (string.length() > 0 && string.charAt(0) == '.') {
            externalFileType.setExtension(string.substring(1));
        } else {
            externalFileType.setExtension(string);
        }
        if (this.selectedIcon != null) {
            externalFileType.setIconName(this.selectedIcon);
        }
        if (!Globals.ON_WIN) {
            externalFileType.setOpenWith(this.application.getText().trim());
        } else if (this.useDefault.isSelected() || this.application.getText().trim().length() == 0) {
            externalFileType.setOpenWith("");
        } else {
            externalFileType.setOpenWith(this.application.getText().trim());
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    class BrowseListener
    implements ActionListener {
        private final JTextField comp;

        public BrowseListener(JDialog jDialog, JTextField jTextField) {
            this.comp = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            File file = new File(this.comp.getText().trim());
            if (this.comp.getText().trim().length() == 0) {
                file = new File(Globals.prefs.get("fileWorkingDirectory"));
            }
            if ((string = FileDialogs.getNewFile(null, file, "_non__", 0, false)) != null) {
                File file2 = new File(string);
                Globals.prefs.put("fileWorkingDirectory", file2.getParent());
                this.comp.setText(file2.getPath());
                this.comp.requestFocus();
            }
        }
    }
}

