/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.XMPUtil;

public class DroppedFileHandler {
    public static final String DFH_LEAVE = "DroppedFileHandler_LeaveFileInDir";
    public static final String DFH_COPY = "DroppedFileHandler_CopyFile";
    public static final String DFH_MOVE = "DroppedFileHandler_MoveFile";
    public static final String DFH_RENAME = "DroppedFileHandler_RenameFile";
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final JRadioButton linkInPlace = new JRadioButton();
    private final JRadioButton copyRadioButton = new JRadioButton();
    private final JRadioButton moveRadioButton = new JRadioButton();
    private final JLabel destDirLabel = new JLabel();
    private final JCheckBox renameCheckBox = new JCheckBox();
    private final JTextField renameToTextBox = new JTextField(50);
    private final JPanel optionsPanel = new JPanel();

    public DroppedFileHandler(JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.linkInPlace);
        buttonGroup.add(this.copyRadioButton);
        buttonGroup.add(this.moveRadioButton);
        FormLayout formLayout = new FormLayout("left:15dlu,pref,pref,pref", "bottom:14pt,pref,pref,pref,pref");
        formLayout.setRowGroups(new int[][]{{1, 2, 3, 4, 5}});
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout, this.optionsPanel);
        defaultFormBuilder.border(Borders.DIALOG);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.linkInPlace, cellConstraints.xyw(1, 1, 4));
        defaultFormBuilder.add((Component)this.destDirLabel, cellConstraints.xyw(1, 2, 4));
        defaultFormBuilder.add((Component)this.copyRadioButton, cellConstraints.xyw(2, 3, 3));
        defaultFormBuilder.add((Component)this.moveRadioButton, cellConstraints.xyw(2, 4, 3));
        defaultFormBuilder.add((Component)this.renameCheckBox, cellConstraints.xyw(2, 5, 1));
        defaultFormBuilder.add((Component)this.renameToTextBox, cellConstraints.xyw(4, 5, 1));
    }

    public void handleDroppedfile(String string, ExternalFileType externalFileType, boolean bl, MainTable mainTable, int n) {
        BibtexEntry bibtexEntry = mainTable.getEntryAt(n);
        this.handleDroppedfile(string, externalFileType, bl, bibtexEntry);
    }

    public void handleDroppedfile(String string, ExternalFileType externalFileType, boolean bl, BibtexEntry bibtexEntry) {
        String string2;
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Drop %0", externalFileType.extension));
        if (this.tryXmpImport(string, externalFileType, bl, namedCompound)) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
            return;
        }
        boolean bl2 = false;
        String string3 = bibtexEntry.getCiteKey();
        if (!this.showLinkMoveCopyRenameDialog(string, externalFileType, bibtexEntry, bl2, false, this.panel.database())) {
            return;
        }
        boolean bl3 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = FileUtil.shortenFileName(new File(string), this.panel.metaData().getFileDirectory("file")).toString();
        } else {
            String string4 = string2 = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : new File(string).getName();
            if (this.copyRadioButton.isSelected()) {
                bl3 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl3 = this.doMove(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl3) {
            this.doLink(bibtexEntry, externalFileType, string2, false, namedCompound);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        namedCompound.end();
        this.panel.undoManager.addEdit(namedCompound);
    }

    public void linkPdfToEntry(String string, MainTable mainTable, int n) {
        BibtexEntry bibtexEntry = mainTable.getEntryAt(n);
        this.linkPdfToEntry(string, mainTable, bibtexEntry);
    }

    public void linkPdfToEntry(String string, MainTable mainTable, BibtexEntry bibtexEntry) {
        String string2;
        ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByExt("pdf");
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Drop %0", externalFileType.extension));
        boolean bl = false;
        String string3 = bibtexEntry.getCiteKey();
        if (!this.showLinkMoveCopyRenameDialog(string, externalFileType, bibtexEntry, bl, false, this.panel.database())) {
            return;
        }
        boolean bl2 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = FileUtil.shortenFileName(new File(string), this.panel.metaData().getFileDirectory("file")).toString();
        } else {
            String string4 = string2 = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : new File(string).getName();
            if (this.copyRadioButton.isSelected()) {
                bl2 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl2 = this.doMove(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl2) {
            this.doLink(bibtexEntry, externalFileType, string2, false, namedCompound);
            this.panel.markBaseChanged();
        }
        namedCompound.end();
        this.panel.undoManager.addEdit(namedCompound);
    }

    public void importXmp(List<BibtexEntry> list, String string) {
        String string2;
        ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByExt("pdf");
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Drop %0", externalFileType.extension));
        boolean bl = list.size() == 1;
        BibtexEntry bibtexEntry = bl ? list.get(0) : null;
        boolean bl2 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = FileUtil.shortenFileName(new File(string), this.panel.metaData().getFileDirectory("file")).toString();
        } else {
            string2 = this.renameCheckBox.isSelected() ? string : bibtexEntry.getCiteKey() + "." + externalFileType.extension;
            if (this.copyRadioButton.isSelected()) {
                bl2 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl2 = this.doMove(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl2) {
            for (BibtexEntry bibtexEntry2 : list) {
                try {
                    bibtexEntry2.setId(IdGenerator.next());
                    namedCompound.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), bibtexEntry2, this.panel));
                    this.panel.getDatabase().insertEntry(bibtexEntry2);
                    this.doLink(bibtexEntry2, externalFileType, string2, true, namedCompound);
                }
                catch (KeyCollisionException keyCollisionException) {}
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        namedCompound.end();
        this.panel.undoManager.addEdit(namedCompound);
    }

    private boolean tryXmpImport(String string, ExternalFileType externalFileType, boolean bl, NamedCompound namedCompound) {
        String string2;
        List<BibtexEntry> list;
        if (!externalFileType.extension.equals("pdf")) {
            return false;
        }
        try {
            list = XMPUtil.readXMP(string);
        }
        catch (Exception exception) {
            return false;
        }
        if (list == null || list.size() == 0) {
            return false;
        }
        JLabel jLabel = new JLabel(Globals.lang("The PDF contains one or several bibtex-records.\nDo you want to import these as new entries into the current database?"));
        int n = JOptionPane.showConfirmDialog(this.frame, jLabel, Globals.lang("XMP metadata found in PDF: %0", string), 1, 3);
        if (n == 2) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        boolean bl2 = list.size() == 1;
        BibtexEntry bibtexEntry = bl2 ? list.get(0) : null;
        boolean bl3 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = FileUtil.shortenFileName(new File(string), this.panel.metaData().getFileDirectory("file")).toString();
        } else {
            string2 = this.renameCheckBox.isSelected() ? string : bibtexEntry.getCiteKey() + "." + externalFileType.extension;
            if (this.copyRadioButton.isSelected()) {
                bl3 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl3 = this.doMove(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl3) {
            for (BibtexEntry bibtexEntry2 : list) {
                try {
                    bibtexEntry2.setId(IdGenerator.next());
                    namedCompound.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), bibtexEntry2, this.panel));
                    this.panel.getDatabase().insertEntry(bibtexEntry2);
                    this.doLink(bibtexEntry2, externalFileType, string2, true, namedCompound);
                }
                catch (KeyCollisionException keyCollisionException) {}
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showLinkMoveCopyRenameDialog(String string, ExternalFileType externalFileType, BibtexEntry bibtexEntry, boolean bl, final boolean bl2, BibtexDatabase bibtexDatabase) {
        String string2 = bibtexEntry.getCiteKey();
        String string3 = Globals.lang("Link to file %0", string);
        String[] stringArray = this.panel.metaData().getFileDirectory("file");
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(stringArray[i]).exists()) continue;
            n = i;
            break;
        }
        if (n < 0) {
            this.destDirLabel.setText(Globals.lang("File directory is not set or does not exist!"));
            this.copyRadioButton.setEnabled(false);
            this.moveRadioButton.setEnabled(false);
            this.renameToTextBox.setEnabled(false);
            this.renameCheckBox.setEnabled(false);
            this.linkInPlace.setSelected(true);
        } else {
            this.destDirLabel.setText(Globals.lang("File directory is '%0':", stringArray[n]));
            this.copyRadioButton.setEnabled(true);
            this.moveRadioButton.setEnabled(true);
            this.renameToTextBox.setEnabled(true);
            this.renameCheckBox.setEnabled(true);
        }
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DroppedFileHandler.this.renameCheckBox.setEnabled(!DroppedFileHandler.this.linkInPlace.isSelected() && !bl2);
                DroppedFileHandler.this.renameToTextBox.setEnabled(!DroppedFileHandler.this.linkInPlace.isSelected() && !bl2);
                if (bl2) {
                    DroppedFileHandler.this.renameToTextBox.setText("Multiple entries");
                }
            }
        };
        if (bl2) {
            this.linkInPlace.setText(Globals.lang("Leave files in their current directory."));
            this.copyRadioButton.setText(Globals.lang("Copy files to file directory."));
            this.moveRadioButton.setText(Globals.lang("Move files to file directory."));
        } else {
            this.linkInPlace.setText(Globals.lang("Leave file in its current directory."));
            this.copyRadioButton.setText(Globals.lang("Copy file to file directory."));
            this.moveRadioButton.setText(Globals.lang("Move file to file directory."));
        }
        this.renameCheckBox.setText(Globals.lang("Rename file to").concat(": "));
        String string4 = Util.getLinkedFileName(bibtexDatabase, bibtexEntry);
        this.renameToTextBox.setText(string4.concat(".").concat(externalFileType.extension));
        this.linkInPlace.setSelected(this.frame.prefs().getBoolean(DFH_LEAVE));
        this.copyRadioButton.setSelected(this.frame.prefs().getBoolean(DFH_COPY));
        this.moveRadioButton.setSelected(this.frame.prefs().getBoolean(DFH_MOVE));
        this.renameCheckBox.setSelected(this.frame.prefs().getBoolean(DFH_RENAME));
        this.linkInPlace.addChangeListener(changeListener);
        changeListener.stateChanged(new ChangeEvent(this.linkInPlace));
        try {
            Object[] objectArray = new Object[]{Globals.lang("How would you like to link to '%0'?", string), this.optionsPanel};
            int n2 = JOptionPane.showConfirmDialog(this.frame, objectArray, string3, 2, 3);
            if (n2 == 0) {
                this.frame.prefs().putBoolean(DFH_LEAVE, this.linkInPlace.isSelected());
                this.frame.prefs().putBoolean(DFH_COPY, this.copyRadioButton.isSelected());
                this.frame.prefs().putBoolean(DFH_MOVE, this.moveRadioButton.isSelected());
                this.frame.prefs().putBoolean(DFH_RENAME, this.renameCheckBox.isSelected());
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.linkInPlace.removeChangeListener(changeListener);
        }
    }

    private void doLink(BibtexEntry bibtexEntry, ExternalFileType externalFileType, String string, boolean bl, NamedCompound namedCompound) {
        Object object;
        String[] stringArray;
        String string2 = bibtexEntry.getField("file");
        FileListTableModel fileListTableModel = new FileListTableModel();
        if (string2 != null) {
            fileListTableModel.setContent(string2);
        }
        if (bl) {
            stringArray = this.panel.metaData().getFileDirectory("file");
            object = !new File(string).isAbsolute() && stringArray.length > 0 ? FileUtil.expandFilename(string, stringArray).getAbsolutePath() : string;
            for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                String string3 = !new File(fileListEntry.getLink()).isAbsolute() && stringArray.length > 0 ? FileUtil.expandFilename(fileListEntry.getLink(), stringArray).getAbsolutePath() : fileListEntry.getLink();
                System.out.println("absName: " + string3);
                if (!((String)object).equals(string3)) continue;
                return;
            }
        }
        fileListTableModel.addEntry(fileListTableModel.getRowCount(), new FileListEntry("", string, externalFileType));
        stringArray = fileListTableModel.getStringRepresentation();
        object = new UndoableFieldChange(bibtexEntry, "file", string2, (String)stringArray);
        bibtexEntry.setField("file", (String)stringArray);
        if (namedCompound == null) {
            this.panel.undoManager.addEdit((UndoableEdit)object);
        } else {
            namedCompound.addEdit((UndoableEdit)object);
        }
    }

    private boolean doMove(String string, ExternalFileType externalFileType, String string2, NamedCompound namedCompound) {
        int n;
        String[] stringArray = this.panel.metaData().getFileDirectory("file");
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(stringArray[i]).exists()) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return false;
        }
        File file = new File(string);
        File file2 = new File(stringArray[n2] + System.getProperty("file.separator") + string2);
        if (file2.exists() && (n = JOptionPane.showConfirmDialog(this.frame, file2.getAbsolutePath() + " exists. Overwrite?", "Overwrite file?", 0)) == 1) {
            return false;
        }
        if (!file.renameTo(file2)) {
            JOptionPane.showMessageDialog(this.frame, "There was an error moving the file. Please move the file manually and link in place.", "Error moving file", 0);
            return false;
        }
        return true;
    }

    private boolean doCopy(String string, ExternalFileType externalFileType, String string2, NamedCompound namedCompound) {
        int n;
        String[] stringArray = this.panel.metaData().getFileDirectory("file");
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(stringArray[i]).exists()) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            System.out.println("dir: " + stringArray[n2] + "\t ext: " + externalFileType.getExtension());
            return false;
        }
        string2 = new File(string2).getName();
        File file = new File(stringArray[n2] + System.getProperty("file.separator") + string2);
        if (file.equals(new File(string))) {
            return true;
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "'" + file.getPath() + "' " + Globals.lang("exists. Overwrite?"), Globals.lang("File exists"), 0, 3)) == 1) {
            return false;
        }
        try {
            FileUtil.copyFile(new File(string), file, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

