/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.ConfirmCloseFileListEntryEditor;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadExternalFile {
    private final JabRefFrame frame;
    private final MetaData metaData;
    private final String bibtexKey;
    private FileListEntryEditor editor;
    private boolean downloadFinished = false;
    private boolean dontShowDialog = false;
    private static final Log LOGGER = LogFactory.getLog(DownloadExternalFile.class);

    public DownloadExternalFile(JabRefFrame jabRefFrame, MetaData metaData, String string) {
        this.frame = jabRefFrame;
        this.metaData = metaData;
        this.bibtexKey = string;
    }

    public void download(DownloadCallback downloadCallback) throws IOException {
        URL uRL;
        this.dontShowDialog = false;
        String string = JOptionPane.showInputDialog(this.frame, (Object)Globals.lang("Enter URL to download"));
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL"), Globals.lang("Download file"), 0);
            return;
        }
        this.download(uRL, downloadCallback);
    }

    public void download(URL uRL, DownloadCallback downloadCallback) throws IOException {
        String string;
        String string2;
        String string3 = uRL.toString();
        final File file = File.createTempFile("jabref_download", "tmp");
        file.deleteOnExit();
        URLDownload uRLDownload = URLDownload.buildMonitoredDownload(this.frame, uRL);
        try {
            string2 = uRLDownload.determineMimeType();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Invalid URL") + ": " + iOException.getMessage(), Globals.lang("Download file"), 0);
            LOGGER.info("Error while downloading '" + string3 + "'", iOException);
            return;
        }
        final URL uRL2 = uRL;
        final URLDownload uRLDownload2 = uRLDownload;
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    uRLDownload2.downloadToFile(file);
                }
                catch (IOException iOException) {
                    DownloadExternalFile.this.dontShowDialog = true;
                    if (DownloadExternalFile.this.editor != null && DownloadExternalFile.this.editor.isVisible()) {
                        DownloadExternalFile.this.editor.setVisible(false, false);
                    }
                    JOptionPane.showMessageDialog(DownloadExternalFile.this.frame, Globals.lang("Invalid URL") + ": " + iOException.getMessage(), Globals.lang("Download file"), 0);
                    LOGGER.info("Error while downloading '" + uRL2.toString() + "'", iOException);
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DownloadExternalFile.this.downloadFinished();
                    }
                });
            }
        });
        ExternalFileType externalFileType = null;
        if (string2 != null) {
            System.out.println("mimetype:" + string2);
            externalFileType = Globals.prefs.getExternalFileTypeByMimeType(string2);
        }
        if (externalFileType != null) {
            string = externalFileType.getExtension();
        } else {
            string = this.getSuffix(string3);
            externalFileType = Globals.prefs.getExternalFileTypeByExt(string);
        }
        String string4 = this.bibtexKey != null ? this.getSuggestedFileName(string) : "";
        String[] stringArray = this.getFileDirectory(string3);
        final String string5 = stringArray.length == 0 ? null : stringArray[0];
        String string6 = string5 != null ? string5 : System.getProperty("user.home");
        File file2 = new File(new File(string6), string4);
        FileListEntry fileListEntry = new FileListEntry("", this.bibtexKey != null ? file2.getCanonicalPath() : "", externalFileType);
        this.editor = new FileListEntryEditor(this.frame, fileListEntry, true, false, this.metaData);
        this.editor.getProgressBar().setIndeterminate(true);
        this.editor.setOkEnabled(false);
        this.editor.setExternalConfirm(new ConfirmCloseFileListEntryEditor(){

            @Override
            public boolean confirmClose(FileListEntry fileListEntry) {
                File file;
                File file2 = file = string5 != null ? DownloadExternalFile.this.expandFilename(string5, fileListEntry.getLink()) : new File(fileListEntry.getLink());
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(DownloadExternalFile.this.frame, Globals.lang("Target file cannot be a directory."), Globals.lang("Download file"), 0);
                    return false;
                }
                if (file.exists()) {
                    return JOptionPane.showConfirmDialog(DownloadExternalFile.this.frame, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Download file"), 2) == 0;
                }
                return true;
            }
        });
        if (this.dontShowDialog) {
            return;
        }
        this.editor.setVisible(true, false);
        if (this.editor.okPressed()) {
            File file3;
            File file4 = file3 = string5 != null ? this.expandFilename(string5, fileListEntry.getLink()) : new File(fileListEntry.getLink());
            String string7 = string5 != null ? (!string5.endsWith(System.getProperty("file.separator")) ? string5 + System.getProperty("file.separator") : string5) : null;
            try {
                boolean bl = FileUtil.copyFile(file, file3, true);
                if (!bl) {
                    System.out.println("File already exists! DownloadExternalFile.download()");
                }
                if (string5 != null && fileListEntry.getLink().startsWith(string5) && fileListEntry.getLink().length() > string7.length()) {
                    fileListEntry.setLink(fileListEntry.getLink().substring(string7.length()));
                }
                downloadCallback.downloadComplete(fileListEntry);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            file.delete();
        } else if (this.downloadFinished) {
            file.delete();
        }
    }

    private File expandFilename(String string, String string2) {
        File file = new File(string2);
        String string3 = string + System.getProperty("file.separator");
        if (!file.isAbsolute()) {
            file = new File(string3 + string2);
        }
        return file;
    }

    private void downloadFinished() {
        this.downloadFinished = true;
        this.editor.getProgressBar().setVisible(false);
        this.editor.getProgressBarLabel().setVisible(false);
        this.editor.setOkEnabled(true);
        this.editor.getProgressBar().setValue(this.editor.getProgressBar().getMaximum());
    }

    private String getSuggestedFileName(String string) {
        String string2 = this.bibtexKey;
        if (string.length() > 0) {
            string2 = string2 + "." + string;
        }
        if (Globals.ON_WIN) {
            string2 = string2.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
        } else if (Globals.ON_MAC) {
            string2 = string2.replaceAll(":", "");
        }
        return string2;
    }

    private String getSuffix(String string) {
        Object object;
        String string2 = string;
        try {
            object = new URL(string);
            if (((URL)object).getQuery() != null && ((URL)object).getQuery().length() < string.length() - 1) {
                string2 = string.substring(0, string.length() - ((URL)object).getQuery().length() - 1);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        int n = string2.lastIndexOf(46);
        object = n <= 0 || n == string2.length() - 1 ? null : string2.substring(n + 1);
        if (Globals.prefs.getExternalFileTypeByExt((String)object) != null) {
            return object;
        }
        n = string.lastIndexOf(46);
        if (n <= 0 || n == string2.length() - 1) {
            if (((String)object).indexOf(47) > 0) {
                return "";
            }
            return object;
        }
        if (string.substring(n + 1).indexOf(47) > 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    private String[] getFileDirectory(String string) {
        return this.metaData.getFileDirectory("file");
    }

    public static interface DownloadCallback {
        public void downloadComplete(FileListEntry var1);
    }
}

