/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.Map;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class XMLChars
implements LayoutFormatter {
    private boolean[] forceReplace;

    @Override
    public String format(String string) {
        string = this.firstFormat(string);
        for (Map.Entry<String, String> entry : Globals.XML_CHARS.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (string3 == null) continue;
            string = string.replaceAll(string2, string3);
        }
        return this.restFormat(string);
    }

    private String firstFormat(String string) {
        return string.replaceAll("&|\\\\&", "&#x0026;").replaceAll("--", "&#x2013;");
    }

    private String restFormat(String string) {
        String string2 = string.replaceAll("\\}", "").replaceAll("\\{", "");
        if (this.forceReplace == null) {
            this.forceReplace = new boolean[126];
            for (int i = 0; i < 40; ++i) {
                this.forceReplace[i] = true;
            }
            this.forceReplace[32] = false;
            for (Object object : (StringBuilder)new int[]{44, 45, 63, 64, 94, 95, 96, 124}) {
                this.forceReplace[object] = true;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() * 2);
        for (int i = 0; i < string2.length(); ++i) {
            int n = string2.charAt(i);
            if (n == 38 && string2.charAt(i + 1) == '#') {
                stringBuilder.append("&#");
                n = string2.charAt(i += 2);
            }
            if (n > 125 || this.forceReplace[n]) {
                stringBuilder.append("&#").append(n).append(';');
                continue;
            }
            stringBuilder.append((char)n);
        }
        string2 = stringBuilder.toString();
        for (Map.Entry<String, String> entry : Globals.ASCII2XML_CHARS.entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            if (string4 == null) continue;
            string2 = string2.replaceAll(string3, string4);
        }
        return string2;
    }
}

