/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.AbstractParamLayoutFormatter;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;

public class WrapFileLinks
extends AbstractParamLayoutFormatter {
    private String fileType = null;
    private List<FormatEntry> format = null;
    private final Map<String, String> replacements = new HashMap<String, String>();
    private static final int STRING = 0;
    private static final int ITERATION_COUNT = 1;
    private static final int FILE_PATH = 2;
    private static final int FILE_TYPE = 3;
    private static final int FILE_EXTENSION = 4;
    private static final int FILE_DESCRIPTION = 5;
    private static final int RELATIVE_FILE_PATH = 6;
    private static final Map<Character, Integer> ESCAPE_SEQ = new HashMap<Character, Integer>();

    @Override
    public void setArgument(String string) {
        String[] stringArray = AbstractParamLayoutFormatter.parseArgument(string);
        this.format = this.parseFormatString(stringArray[0]);
        if (stringArray.length > 1 && !stringArray[1].trim().isEmpty()) {
            this.fileType = stringArray[1];
        }
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length - 1; i += 2) {
                this.replacements.put(stringArray[i], stringArray[i + 1]);
            }
        }
    }

    @Override
    public String format(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        FileListTableModel fileListTableModel = new FileListTableModel();
        if (string == null) {
            return "";
        }
        fileListTableModel.setContent(string);
        int n = 1;
        for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
            FileListEntry fileListEntry = fileListTableModel.getEntry(i);
            if (this.fileType != null && !fileListEntry.getType().getName().toLowerCase().equals(this.fileType)) continue;
            for (FormatEntry formatEntry : this.format) {
                switch (formatEntry.getType()) {
                    case 0: {
                        stringBuilder.append(formatEntry.getString());
                        break;
                    }
                    case 1: {
                        stringBuilder.append(String.valueOf(n));
                        break;
                    }
                    case 2: {
                        if (fileListEntry.getLink() == null) break;
                        String[] stringArray = Globals.prefs.fileDirForDatabase != null ? Globals.prefs.fileDirForDatabase : new String[]{Globals.prefs.get("fileDirectory")};
                        File file = FileUtil.expandFilename(fileListEntry.getLink(), stringArray);
                        if (file != null) {
                            try {
                                stringBuilder.append(this.replaceStrings(file.getCanonicalPath()));
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                stringBuilder.append(this.replaceStrings(file.getPath()));
                            }
                            break;
                        }
                        stringBuilder.append(this.replaceStrings(fileListEntry.getLink()));
                        break;
                    }
                    case 6: {
                        if (fileListEntry.getLink() == null) break;
                        stringBuilder.append(this.replaceStrings(fileListEntry.getLink()));
                        break;
                    }
                    case 4: {
                        int n2;
                        if (fileListEntry.getLink() == null || (n2 = fileListEntry.getLink().lastIndexOf(46)) < 0 || n2 >= fileListEntry.getLink().length() - 1) break;
                        stringBuilder.append(this.replaceStrings(fileListEntry.getLink().substring(n2 + 1)));
                        break;
                    }
                    case 3: {
                        stringBuilder.append(this.replaceStrings(fileListEntry.getType().getName()));
                        break;
                    }
                    case 5: {
                        stringBuilder.append(this.replaceStrings(fileListEntry.getDescription()));
                    }
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String replaceStrings(String string) {
        for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
            String string2 = entry.getValue();
            string = string.replaceAll(entry.getKey(), string2);
        }
        return string;
    }

    private List<FormatEntry> parseFormatString(String string) {
        ArrayList<FormatEntry> arrayList = new ArrayList<FormatEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            bl = false;
            if (c == '\\') {
                stringBuilder.append('\\');
                continue;
            }
            if (ESCAPE_SEQ.containsKey(Character.valueOf(c))) {
                if (stringBuilder.length() > 0) {
                    arrayList.add(new FormatEntry(stringBuilder.toString()));
                    stringBuilder = new StringBuilder();
                }
                arrayList.add(new FormatEntry(ESCAPE_SEQ.get(Character.valueOf(c))));
                continue;
            }
            stringBuilder.append('\\');
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(new FormatEntry(stringBuilder.toString()));
        }
        return arrayList;
    }

    static {
        ESCAPE_SEQ.put(Character.valueOf('i'), 1);
        ESCAPE_SEQ.put(Character.valueOf('p'), 2);
        ESCAPE_SEQ.put(Character.valueOf('r'), 6);
        ESCAPE_SEQ.put(Character.valueOf('f'), 3);
        ESCAPE_SEQ.put(Character.valueOf('x'), 4);
        ESCAPE_SEQ.put(Character.valueOf('d'), 5);
    }

    static class FormatEntry {
        private final int type;
        private String string = null;

        public FormatEntry(int n) {
            this.type = n;
        }

        public FormatEntry(String string) {
            this.type = 0;
            this.string = string;
        }

        public int getType() {
            return this.type;
        }

        public String getString() {
            return this.string;
        }
    }
}

