/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.export.layout.AbstractParamLayoutFormatter;

public class Authors
extends AbstractParamLayoutFormatter {
    private static final ArrayList<String> authorOrder = new ArrayList();
    private static final ArrayList<String> authorAbbr = new ArrayList();
    private static final ArrayList<String> authorPunc = new ArrayList();
    private static final ArrayList<String> separators = new ArrayList();
    private static final ArrayList<String> lastSeparators = new ArrayList();
    private static final Pattern numberPattern = Pattern.compile("[0-9]+");
    private static final int FIRST_FIRST = 0;
    private static final int LAST_FIRST = 1;
    private static final int LF_FF = 2;
    private static final String COMMA = ", ";
    private static final String AMP = " & ";
    private static final String COLON = ": ";
    private static final String SEMICOLON = "; ";
    private static final String AND = " and ";
    private static final String OXFORD = ", and ";
    private int flMode = 0;
    private boolean abbreviate = true;
    private boolean firstInitialOnly = false;
    private boolean middleInitial = false;
    private boolean lastNameOnly = false;
    private boolean abbrDots = true;
    private boolean abbrSpaces = true;
    private boolean setSep = false;
    private boolean setMaxAuthors = false;
    private int maxAuthors = -1;
    private int authorNumberEtAl = 1;
    private String lastFirstSeparator = ", ";
    private String separator = ", ";
    private String lastSeparator = " and ";
    private String etAlString = " et al.";

    @Override
    public void setArgument(String string) {
        String[] stringArray;
        for (String string2 : stringArray = AbstractParamLayoutFormatter.parseArgument(string)) {
            int n = string2.indexOf("=");
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                this.handleArgument(string3, string4);
                continue;
            }
            this.handleArgument(string2, "");
        }
    }

    private void handleArgument(String string, String string2) {
        if (authorOrder.contains(string.trim().toLowerCase())) {
            if (this.comp(string, "FirstFirst")) {
                this.flMode = 0;
            } else if (this.comp(string, "LastFirst")) {
                this.flMode = 1;
            } else if (this.comp(string, "LastFirstFirstFirst")) {
                this.flMode = 2;
            }
        } else if (authorAbbr.contains(string.trim().toLowerCase())) {
            if (this.comp(string, "FullName")) {
                this.abbreviate = false;
            } else if (this.comp(string, "Initials")) {
                this.abbreviate = true;
                this.firstInitialOnly = false;
            } else if (this.comp(string, "FirstInitial")) {
                this.abbreviate = true;
                this.firstInitialOnly = true;
            } else if (this.comp(string, "MiddleInitial")) {
                this.abbreviate = true;
                this.middleInitial = true;
            } else if (this.comp(string, "LastName")) {
                this.lastNameOnly = true;
            } else if (this.comp(string, "InitialsNoSpace")) {
                this.abbreviate = true;
                this.abbrSpaces = false;
            }
        } else if (authorPunc.contains(string.trim().toLowerCase())) {
            if (this.comp(string, "FullPunc")) {
                this.abbrDots = true;
                this.lastFirstSeparator = COMMA;
            } else if (this.comp(string, "NoPunc")) {
                this.abbrDots = false;
                this.lastFirstSeparator = " ";
            } else if (this.comp(string, "NoComma")) {
                this.abbrDots = true;
                this.lastFirstSeparator = " ";
            } else if (this.comp(string, "NoPeriod")) {
                this.abbrDots = false;
                this.lastFirstSeparator = COMMA;
            }
        } else if (separators.contains(string.trim().toLowerCase()) || lastSeparators.contains(string.trim().toLowerCase())) {
            if (this.comp(string, "Comma")) {
                if (!this.setSep) {
                    this.separator = COMMA;
                    this.setSep = true;
                } else {
                    this.lastSeparator = COMMA;
                }
            } else if (this.comp(string, "And")) {
                if (!this.setSep) {
                    this.separator = AND;
                    this.setSep = true;
                } else {
                    this.lastSeparator = AND;
                }
            } else if (this.comp(string, "Colon")) {
                if (!this.setSep) {
                    this.separator = COLON;
                    this.setSep = true;
                } else {
                    this.lastSeparator = COLON;
                }
            } else if (this.comp(string, "Semicolon")) {
                if (!this.setSep) {
                    this.separator = SEMICOLON;
                    this.setSep = true;
                } else {
                    this.lastSeparator = SEMICOLON;
                }
            } else if (this.comp(string, "Oxford")) {
                this.lastSeparator = OXFORD;
            } else if (this.comp(string, "Amp")) {
                this.lastSeparator = AMP;
            } else if (this.comp(string, "Sep") && !string2.isEmpty()) {
                this.separator = string2;
                this.setSep = true;
            } else if (this.comp(string, "LastSep") && !string2.isEmpty()) {
                this.lastSeparator = string2;
            }
        } else if (string.trim().toLowerCase().equals("etal") && !string2.isEmpty()) {
            this.etAlString = string2;
        } else if (numberPattern.matcher(string.trim()).matches()) {
            int n = Integer.parseInt(string.trim());
            if (!this.setMaxAuthors) {
                this.maxAuthors = n;
                this.setMaxAuthors = true;
            } else {
                this.authorNumberEtAl = n;
            }
        }
    }

    private boolean comp(String string, String string2) {
        return string.trim().equalsIgnoreCase(string2);
    }

    @Override
    public String format(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (this.maxAuthors < 0 || authorList.size() <= this.maxAuthors) {
            for (int i = 0; i < authorList.size(); ++i) {
                AuthorList.Author author = authorList.getAuthor(i);
                this.addSingleName(stringBuilder, author, this.flMode == 0 || this.flMode == 2 && i > 0);
                if (i < authorList.size() - 2) {
                    stringBuilder.append(this.separator);
                    continue;
                }
                if (i >= authorList.size() - 1) continue;
                stringBuilder.append(this.lastSeparator);
            }
        } else {
            for (int i = 0; i < Math.min(authorList.size() - 1, this.authorNumberEtAl); ++i) {
                if (i > 0) {
                    stringBuilder.append(this.separator);
                }
                this.addSingleName(stringBuilder, authorList.getAuthor(i), this.flMode == 0);
            }
            stringBuilder.append(this.etAlString);
        }
        return stringBuilder.toString();
    }

    private void addSingleName(StringBuilder stringBuilder, AuthorList.Author author, boolean bl) {
        String string;
        String string2;
        String string3 = author.getFirst();
        String string4 = author.getLast();
        String string5 = author.getVon();
        if (string5 != null && !string5.isEmpty()) {
            string4 = string5 + ' ' + string4;
        }
        if ((string2 = author.getJr()) != null && !string2.isEmpty()) {
            string = " ";
            string4 = string4 + string + string2;
        }
        if (this.abbreviate && string3 != null) {
            string3 = author.getFirstAbbr();
            if (this.firstInitialOnly && string3.length() > 2) {
                string3 = string3.substring(0, 2);
            } else if (this.middleInitial) {
                string = string3;
                string3 = author.getFirst();
                int n = string3.indexOf(" ");
                if (n >= 0) {
                    string3 = string3.substring(0, n + 1);
                    if (string.length() > 3) {
                        string3 = string3 + string.substring(3);
                    }
                }
            }
            if (!this.abbrDots) {
                string3 = string3.replaceAll("\\.", "");
            }
            if (!this.abbrSpaces) {
                string3 = string3.replaceAll(" ", "");
            }
        }
        if (this.lastNameOnly || string3 == null) {
            stringBuilder.append(string4);
        } else if (bl) {
            string = " ";
            stringBuilder.append(string3).append(string);
            stringBuilder.append(string4);
        } else {
            stringBuilder.append(string4).append(this.lastFirstSeparator).append(string3);
        }
    }

    public static void main(String[] stringArray) {
        Authors authors = new Authors();
        authors.setArgument("lastfirstfirstfirst , initials,  Nocomma,Amp,Semicolon,30 ,EtAl = m.fl.");
        System.out.println(authors.format("Alfredsen, Jr, Jo Arve and Morten Omholt Alver and Yngvar von Olsen and Sebastian A. L. M. Kooijman"));
    }

    static {
        authorOrder.add("firstfirst");
        authorOrder.add("lastfirst");
        authorOrder.add("lastfirstfirstfirst");
        authorAbbr.add("fullname");
        authorAbbr.add("initials");
        authorAbbr.add("firstinitial");
        authorAbbr.add("middleinitial");
        authorAbbr.add("lastname");
        authorAbbr.add("initialsnospace");
        authorPunc.add("fullpunc");
        authorPunc.add("nopunc");
        authorPunc.add("nocomma");
        authorPunc.add("noperiod");
        separators.add("comma");
        separators.add("and");
        separators.add("colon");
        separators.add("semicolon");
        separators.add("sep");
        lastSeparators.add("and");
        lastSeparators.add("colon");
        lastSeparators.add("semicolon");
        lastSeparators.add("amp");
        lastSeparators.add("oxford");
        lastSeparators.add("lastsep");
    }
}

