/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import net.sf.jabref.Globals;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.util.FileBasedLock;
import net.sf.jabref.util.FileUtil;

public class SaveSession {
    public static final String LOCKFILE_SUFFIX = ".lock";
    public static final long LOCKFILE_CRITICAL_AGE = 60000L;
    private static final String TEMP_PREFIX = "jabref";
    private static final String TEMP_SUFFIX = "save.bib";
    private final File file;
    private File tmp;
    File backupFile;
    private String encoding;
    private boolean backup;
    private boolean useLockFile;
    private VerifyingWriter writer;

    public SaveSession(File file, String string, boolean bl) throws IOException, UnsupportedCharsetException {
        this.file = file;
        this.tmp = File.createTempFile(TEMP_PREFIX, TEMP_SUFFIX);
        this.useLockFile = Globals.prefs.getBoolean("useLockFiles");
        this.backup = bl;
        this.encoding = string;
        this.writer = new VerifyingWriter((OutputStream)new FileOutputStream(this.tmp), string);
    }

    public VerifyingWriter getWriter() {
        return this.writer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseBackup(boolean bl) {
        this.backup = bl;
    }

    public void commit() throws SaveException {
        if (this.file == null) {
            return;
        }
        if (this.file.exists() && this.backup) {
            String string = this.file.getName();
            String string2 = this.file.getParent();
            File file = new File(string2, string + ".bak");
            try {
                FileUtil.copyFile(this.file, file, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw SaveException.BACKUP_CREATION;
            }
        }
        try {
            if (this.useLockFile) {
                try {
                    if (this.createLockFile() && !FileBasedLock.waitForFileLock(this.file, 10)) {
                        throw SaveException.FILE_LOCKED;
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Error when creating lock file");
                    iOException.printStackTrace();
                }
            }
            FileUtil.copyFile(this.tmp, this.file, true);
        }
        catch (IOException iOException) {
            throw new SaveException(Globals.lang("Save failed while committing changes") + ": " + iOException.getMessage());
        }
        finally {
            if (this.useLockFile) {
                this.deleteLockFile();
            }
        }
        this.tmp.delete();
    }

    public void cancel() {
        this.tmp.delete();
    }

    private boolean createLockFile() throws IOException {
        File file = new File(this.file.getPath() + LOCKFILE_SUFFIX);
        if (file.exists()) {
            return true;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(0);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error when creating lock file");
            iOException.printStackTrace();
        }
        file.deleteOnExit();
        return false;
    }

    private boolean deleteLockFile() {
        File file = new File(this.file.getPath() + LOCKFILE_SUFFIX);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    public File getTemporaryFile() {
        return this.tmp;
    }
}

