/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.File;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.CallBack;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Worker;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.util.FileBasedLock;

public class SaveDatabaseAction
extends AbstractWorker {
    private final BasePanel panel;
    private final JabRefFrame frame;
    private boolean success = false;
    private boolean cancelled = false;
    private boolean fileLockedError = false;

    public SaveDatabaseAction(BasePanel basePanel) {
        this.panel = basePanel;
        this.frame = basePanel.frame();
    }

    @Override
    public void init() throws Throwable {
        this.success = false;
        this.cancelled = false;
        this.fileLockedError = false;
        if (this.panel.getFile() == null) {
            this.saveAs();
        } else {
            if (this.panel.isUpdatedExternally() || Globals.fileUpdateMonitor.hasBeenModified(this.panel.getFileMonitorHandle())) {
                boolean bl;
                Object[] objectArray = new String[]{Globals.lang("Review changes"), Globals.lang("Save"), Globals.lang("Cancel")};
                int n = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("File has been updated externally. What do you want to do?"), Globals.lang("File updated externally"), 1, 3, null, objectArray, objectArray[0]);
                if (n == 2) {
                    this.cancelled = true;
                    return;
                }
                if (n == 0) {
                    this.cancelled = true;
                    JabRefExecutorService.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!FileBasedLock.waitForFileLock(SaveDatabaseAction.this.panel.getFile(), 10)) {
                                System.err.println("File locked, this will be trouble.");
                            }
                            ChangeScanner changeScanner = new ChangeScanner(SaveDatabaseAction.this.panel.frame(), SaveDatabaseAction.this.panel, SaveDatabaseAction.this.panel.getFile());
                            JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThreadAndWait(changeScanner);
                            if (changeScanner.changesFound()) {
                                changeScanner.displayResult(new ChangeScanner.DisplayResultCallback(){

                                    @Override
                                    public void scanResultsResolved(boolean bl) {
                                        if (!bl) {
                                            SaveDatabaseAction.this.cancelled = true;
                                        } else {
                                            SaveDatabaseAction.this.panel.setUpdatedExternally(false);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    SaveDatabaseAction.this.panel.getSidePaneManager().hide("fileUpdate");
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                    return;
                }
                Vector<String> vector = this.panel.metaData().getData("protectedFlag");
                boolean bl2 = bl = vector != null && Boolean.parseBoolean(vector.get(0));
                if (bl) {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("Database is protected. Cannot save until external changes have been reviewed."), Globals.lang("Protected database"), 0);
                    this.cancelled = true;
                } else {
                    this.panel.setUpdatedExternally(false);
                    this.panel.getSidePaneManager().hide("fileUpdate");
                }
            }
            this.panel.frame().output(Globals.lang("Saving database") + "...");
            this.panel.setSaving(true);
        }
    }

    @Override
    public void update() {
        if (this.success) {
            this.frame.setTabTitle(this.panel, this.panel.getFile().getName(), this.panel.getFile().getAbsolutePath());
            this.frame.output(Globals.lang("Saved database") + " '" + this.panel.getFile().getPath() + "'.");
            this.frame.setWindowTitle();
        } else if (!this.cancelled) {
            if (this.fileLockedError) {
                this.frame.output(Globals.lang("Could not save, file locked by another JabRef instance."));
            } else {
                this.frame.output(Globals.lang("Save failed"));
            }
        }
    }

    @Override
    public void run() {
        if (this.cancelled || this.panel.getFile() == null) {
            return;
        }
        try {
            this.panel.storeCurrentEdit();
            this.panel.autoGenerateKeysBeforeSaving();
            if (!FileBasedLock.waitForFileLock(this.panel.getFile(), 10)) {
                this.success = false;
                this.fileLockedError = true;
            } else {
                this.success = this.saveDatabase(this.panel.getFile(), false, this.panel.getEncoding());
                try {
                    Globals.fileUpdateMonitor.updateTimeStamp(this.panel.getFileMonitorHandle());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.panel.setSaving(false);
            if (this.success) {
                this.panel.undoManager.markUnchanged();
                if (!AutoSaveManager.deleteAutoSaveFile(this.panel)) {
                    // empty if block
                }
                this.panel.setNonUndoableChange(false);
                this.panel.setBaseChanged(false);
                this.panel.setUpdatedExternally(false);
            }
        }
        catch (SaveException saveException) {
            if (saveException == SaveException.FILE_LOCKED) {
                this.success = false;
                this.fileLockedError = true;
                return;
            }
            saveException.printStackTrace();
        }
    }

    private boolean saveDatabase(File file, boolean bl, String string) throws SaveException {
        SaveSession saveSession;
        this.frame.block();
        try {
            saveSession = !bl ? FileActions.saveDatabase(this.panel.database(), this.panel.metaData(), file, Globals.prefs, false, false, string, false) : FileActions.savePartOfDatabase(this.panel.database(), this.panel.metaData(), file, Globals.prefs, this.panel.getSelectedEntries(), string, FileActions.DatabaseSaveType.DEFAULT);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file. Character encoding '%0' is not supported.", string), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        catch (SaveException saveException) {
            if (saveException == SaveException.FILE_LOCKED) {
                throw saveException;
            }
            if (saveException.specificEntry()) {
                int n = this.panel.mainTable.findEntry(saveException.getEntry());
                int n2 = Math.max(0, n - 3);
                this.panel.mainTable.setRowSelectionInterval(n, n);
                this.panel.mainTable.scrollTo(n2);
                this.panel.showEntry(saveException.getEntry());
            } else {
                saveException.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + saveException.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean bl2 = true;
        if (!saveSession.getWriter().couldEncodeAll()) {
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
            JTextArea jTextArea = new JTextArea(saveSession.getWriter().getProblemCharacters());
            jTextArea.setEditable(false);
            defaultFormBuilder.append(Globals.lang("The chosen encoding '%0' could not encode the following characters: ", saveSession.getEncoding()));
            defaultFormBuilder.append(jTextArea);
            defaultFormBuilder.append(Globals.lang("What do you want to do?"));
            String string2 = Globals.lang("Try different encoding");
            int n = JOptionPane.showOptionDialog(this.frame, defaultFormBuilder.getPanel(), Globals.lang("Save database"), 1, 2, null, new String[]{Globals.lang("Save"), string2, Globals.lang("Cancel")}, string2);
            if (n == 1) {
                Object object = JOptionPane.showInputDialog(this.frame, Globals.lang("Select encoding"), Globals.lang("Save database"), 3, null, Globals.ENCODINGS, string);
                if (object != null) {
                    String string3 = (String)object;
                    return this.saveDatabase(file, bl, string3);
                }
                bl2 = false;
            } else if (n == 2) {
                bl2 = false;
            }
        }
        try {
            if (bl2) {
                saveSession.commit();
                this.panel.setEncoding(string);
            } else {
                saveSession.cancel();
            }
        }
        catch (SaveException saveException) {
            int n = JOptionPane.showConfirmDialog(null, Globals.lang("Save failed during backup creation") + ". " + Globals.lang("Save without backup?"), Globals.lang("Unable to create backup"), 0);
            if (n == 0) {
                saveSession.setUseBackup(false);
                saveSession.commit();
                this.panel.setEncoding(string);
            }
            bl2 = false;
        }
        return bl2;
    }

    public void runCommand() throws Throwable {
        Worker worker = this.getWorker();
        CallBack callBack = this.getCallBack();
        this.init();
        worker.run();
        callBack.update();
    }

    public void save() throws Throwable {
        this.runCommand();
    }

    public void saveAs() throws Throwable {
        String string = null;
        File file = null;
        while (file == null) {
            string = FileDialogs.getNewFile((JFrame)this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false, null);
            if (string == null) {
                this.cancelled = true;
                return;
            }
            file = new File(string);
            if (!file.exists() || JOptionPane.showConfirmDialog(this.frame, '\'' + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) == 0) continue;
            file = null;
        }
        if (string != null) {
            File file2 = this.panel.metaData().getFile();
            this.panel.metaData().setFile(file);
            Globals.prefs.put("workingDirectory", file.getParent());
            this.runCommand();
            if (!this.success) {
                this.panel.metaData().setFile(file2);
                return;
            }
            try {
                this.panel.setFileMonitorHandle(Globals.fileUpdateMonitor.addUpdateListener(this.panel, this.panel.getFile()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.frame.getFileHistory().newFile(this.panel.metaData().getFile().getPath());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

