/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.export.IExportFormat;

class ExportFileFilter
extends FileFilter
implements Comparable<ExportFileFilter> {
    private final IExportFormat format;
    private final String extension;
    private final String name;

    public ExportFileFilter(IExportFormat iExportFormat, String string) {
        this.format = iExportFormat;
        this.extension = string;
        this.name = iExportFormat.getDisplayName() + " (*" + string + ')';
    }

    public IExportFormat getExportFormat() {
        return this.format;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getPath().toLowerCase().endsWith(this.extension);
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public int compareTo(ExportFileFilter exportFileFilter) {
        return this.name.compareTo(exportFileFilter.name);
    }
}

