/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringNameChange
extends Change {
    private static final long serialVersionUID = 1L;
    private final BibtexString string;
    private final String mem;
    private final String disk;
    private final String content;
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringNameChange.class);

    public StringNameChange(BibtexString bibtexString, BibtexString bibtexString2, String string, String string2, String string3, String string4) {
        this.tmpString = bibtexString2;
        this.name = Globals.lang("Renamed string") + ": '" + string2 + '\'';
        this.string = bibtexString;
        this.content = string4;
        this.mem = string;
        this.disk = string3;
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        BibtexString bibtexString;
        String string;
        if (basePanel.database().hasStringLabel(this.disk)) {
            LOGGER.info("Cannot rename string '" + this.mem + "' to '" + this.disk + "' because the name " + "is already in use.");
        }
        if (this.string != null) {
            this.string.setName(this.disk);
            namedCompound.addEdit(new UndoableStringChange(basePanel, this.string, true, this.mem, this.disk));
        } else {
            string = IdGenerator.next();
            bibtexString = new BibtexString(string, this.disk, this.content);
            try {
                basePanel.database().addString(bibtexString);
                namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), bibtexString));
            }
            catch (KeyCollisionException keyCollisionException) {
                LOGGER.info("Error: could not add string '" + bibtexString.getName() + "': " + keyCollisionException.getMessage(), keyCollisionException);
            }
        }
        if (this.tmpString != null) {
            this.tmpString.setName(this.disk);
        } else {
            string = IdGenerator.next();
            bibtexString = new BibtexString(string, this.disk, this.content);
            bibtexDatabase.addString(bibtexString);
        }
        return true;
    }

    @Override
    JComponent description() {
        return new JLabel(this.disk + " : " + this.content);
    }
}

