/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringChange
extends Change {
    private static final long serialVersionUID = 1L;
    private final BibtexString string;
    private final String mem;
    private final String disk;
    private final String label;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringChange.class);

    public StringChange(BibtexString bibtexString, BibtexString bibtexString2, String string, String string2, String string3, String string4) {
        this.tmpString = bibtexString2;
        this.name = Globals.lang("Modified string") + ": '" + string + '\'';
        this.string = bibtexString;
        this.label = string;
        this.mem = string2;
        this.disk = string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML><H2>");
        stringBuilder.append(Globals.lang("Modified string"));
        stringBuilder.append("</H2><H3>");
        stringBuilder.append(Globals.lang("Label")).append(":</H3>");
        stringBuilder.append(string);
        stringBuilder.append("<H3>");
        stringBuilder.append(Globals.lang("New content")).append(":</H3>");
        stringBuilder.append(string4);
        if (bibtexString != null) {
            stringBuilder.append("<H3>");
            stringBuilder.append(Globals.lang("Current content")).append(":</H3>");
            stringBuilder.append(bibtexString.getContent());
        } else {
            stringBuilder.append("<P><I>");
            stringBuilder.append(Globals.lang("Cannot merge this change")).append(": ");
            stringBuilder.append(Globals.lang("The string has been removed locally")).append("</I>");
        }
        stringBuilder.append("</HTML>");
        this.tp.setText(stringBuilder.toString());
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        Object object;
        if (this.string != null) {
            this.string.setContent(this.disk);
            namedCompound.addEdit(new UndoableStringChange(basePanel, this.string, false, this.mem, this.disk));
        } else {
            object = IdGenerator.next();
            BibtexString bibtexString = new BibtexString((String)object, this.label, this.disk);
            try {
                basePanel.database().addString(bibtexString);
                namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), bibtexString));
            }
            catch (KeyCollisionException keyCollisionException) {
                LOGGER.info("Error: could not add string '" + this.string.getName() + "': " + keyCollisionException.getMessage());
            }
        }
        if (this.tmpString != null) {
            this.tmpString.setContent(this.disk);
        } else {
            object = new BibtexString(IdGenerator.next(), this.label, this.disk);
            bibtexDatabase.addString((BibtexString)object);
        }
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

