/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.collab.ChangeScanner;

public class FileUpdatePanel
extends SidePaneComponent
implements ActionListener,
ChangeScanner.DisplayResultCallback {
    public static final String NAME = "fileUpdate";
    private final BasePanel panel;
    private final SidePaneManager manager;
    private final ChangeScanner scanner;

    public FileUpdatePanel(JabRefFrame jabRefFrame, BasePanel basePanel, SidePaneManager sidePaneManager, File file, ChangeScanner changeScanner) {
        super(sidePaneManager, GUIGlobals.getIconUrl("save"), Globals.lang("File changed"));
        this.close.setEnabled(false);
        this.panel = basePanel;
        this.manager = sidePaneManager;
        this.scanner = changeScanner;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("<html><center>" + Globals.lang("The file<BR>'%0'<BR>has been modified<BR>externally!", file.getName()) + "</center></html>", 0);
        jPanel.add((Component)jLabel, "Center");
        JButton jButton = new JButton(Globals.lang("Review changes"));
        jPanel.add((Component)jButton, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        jButton.addActionListener(this);
    }

    public BasePanel getPanel() {
        return this.panel;
    }

    @Override
    public void componentClosing() {
        this.manager.unregisterComponent(NAME);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.scanner.displayResult(this);
    }

    @Override
    public void scanResultsResolved(boolean bl) {
        if (bl) {
            this.manager.hideComponent(this);
            this.panel.setUpdatedExternally(false);
        }
    }
}

