/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

class EntryChange
extends Change {
    public EntryChange(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, BibtexEntry bibtexEntry3) {
        String string = bibtexEntry2.getCiteKey();
        this.name = string == null ? "Modified entry" : "Modified entry: '" + string + '\'';
        boolean bl = !(DuplicateCheck.compareEntriesStrictly(bibtexEntry, bibtexEntry2) > 1.0);
        boolean bl2 = DuplicateCheck.compareEntriesStrictly(bibtexEntry, bibtexEntry3) > 1.0;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(bibtexEntry.getAllFields());
        treeSet.addAll(bibtexEntry2.getAllFields());
        treeSet.addAll(bibtexEntry3.getAllFields());
        for (String string2 : treeSet) {
            String string3 = bibtexEntry.getField(string2);
            String string4 = bibtexEntry2.getField(string2);
            String string5 = bibtexEntry3.getField(string2);
            if (string4 != null && string5 != null) {
                if (string4.equals(string5)) continue;
                this.add(new FieldChange(string2, bibtexEntry, bibtexEntry2, string3, string4, string5));
                continue;
            }
            if ((string4 != null || string5 == null || string5.isEmpty()) && (string5 != null || string4 == null || string4.isEmpty() || string3 == null || string3.isEmpty())) continue;
            this.add(new FieldChange(string2, bibtexEntry, bibtexEntry2, string3, string4, string5));
        }
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        boolean bl = true;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Change change = (Change)enumeration.nextElement();
            if (change.isAcceptable() && change.isAccepted()) {
                change.makeChange(basePanel, bibtexDatabase, namedCompound);
                continue;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    JComponent description() {
        return new JLabel(this.name);
    }

    static class FieldChange
    extends Change {
        final BibtexEntry entry;
        final BibtexEntry tmpEntry;
        final String field;
        final String inMem;
        final String onTmp;
        final String onDisk;
        final InfoPane tp = new InfoPane();
        final JScrollPane sp = new JScrollPane(this.tp);

        public FieldChange(String string, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, String string2, String string3, String string4) {
            this.entry = bibtexEntry;
            this.tmpEntry = bibtexEntry2;
            this.name = string;
            this.field = string;
            this.inMem = string2;
            this.onTmp = string3;
            this.onDisk = string4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<FONT SIZE=10>");
            stringBuilder.append("<H2>").append(Globals.lang("Modification of field")).append(" <I>").append(string).append("</I></H2>");
            if (string4 != null && !string4.isEmpty()) {
                stringBuilder.append("<H3>").append(Globals.lang("Value set externally")).append(":</H3> ").append(string4);
            } else {
                stringBuilder.append("<H3>").append(Globals.lang("Value cleared externally")).append("</H3>");
            }
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("<H3>").append(Globals.lang("Current value")).append(":</H3> ").append(string2);
            }
            if (string3 != null && !string3.isEmpty()) {
                stringBuilder.append("<H3>").append(Globals.lang("Current tmp value")).append(":</H3> ").append(string3);
            }
            this.tp.setContentType("text/html");
            this.tp.setText(stringBuilder.toString());
        }

        @Override
        public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
            this.entry.setField(this.field, this.onDisk);
            namedCompound.addEdit(new UndoableFieldChange(this.entry, this.field, this.inMem, this.onDisk));
            this.tmpEntry.setField(this.field, this.onDisk);
            return true;
        }

        @Override
        JComponent description() {
            return this.sp;
        }
    }
}

