/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import java.util.Map;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.autocompleter.AutoCompleterFactory;
import net.sf.jabref.autocompleter.AutoCompleters;
import net.sf.jabref.journals.logic.Abbreviation;

public class ContentAutoCompleters
extends AutoCompleters {
    public ContentAutoCompleters() {
    }

    public ContentAutoCompleters(BibtexDatabase bibtexDatabase, MetaData metaData) {
        String[] stringArray;
        for (String string : stringArray = Globals.prefs.getStringArray("autoCompleteFields")) {
            AutoCompleter autoCompleter = AutoCompleterFactory.getFor(string);
            this.put(string, autoCompleter);
        }
        this.addDatabase(bibtexDatabase);
        this.addJournalListToAutoCompleter();
        this.addContentSelectorValuesToAutoCompleters(metaData);
    }

    public void addContentSelectorValuesToAutoCompleters(MetaData metaData) {
        for (Map.Entry entry : this.autoCompleters.entrySet()) {
            Vector<String> vector;
            AutoCompleter autoCompleter = (AutoCompleter)entry.getValue();
            if (metaData.getData("selector_" + (String)entry.getKey()) == null || (vector = metaData.getData("selector_" + (String)entry.getKey())) == null) continue;
            for (String string : vector) {
                autoCompleter.addWordToIndex(string);
            }
        }
    }

    public void addJournalListToAutoCompleter() {
        AutoCompleter autoCompleter = this.get("journal");
        if (autoCompleter != null) {
            for (Abbreviation abbreviation : Globals.journalAbbrev.getAbbreviations()) {
                autoCompleter.addWordToIndex(abbreviation.getName());
            }
        }
    }
}

