/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePane;
import net.sf.jabref.SidePaneComponent;

public class SidePaneManager {
    private final JabRefFrame frame;
    BasePanel panel;
    private final SidePane sidep;
    private final Map<String, SidePaneComponent> components = new LinkedHashMap<String, SidePaneComponent>();
    private final Map<SidePaneComponent, String> componentNames = new HashMap<SidePaneComponent, String>();
    private final List<SidePaneComponent> visible = new LinkedList<SidePaneComponent>();

    public SidePaneManager(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        jabRefFrame.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SidePaneManager.this.setActiveBasePanel((BasePanel)((SidePaneManager)SidePaneManager.this).frame.tabbedPane.getSelectedComponent());
                    }
                });
            }
        });
        this.sidep = new SidePane();
        this.sidep.setVisible(false);
    }

    public SidePane getPanel() {
        return this.sidep;
    }

    public synchronized boolean hasComponent(String string) {
        return this.components.get(string) != null;
    }

    public boolean isComponentVisible(String string) {
        SidePaneComponent sidePaneComponent = this.components.get(string);
        if (sidePaneComponent != null) {
            return this.visible.contains(sidePaneComponent);
        }
        return false;
    }

    public synchronized void toggle(String string) {
        if (this.isComponentVisible(string)) {
            this.hide(string);
        } else {
            this.show(string);
        }
    }

    public void show(String string) {
        SidePaneComponent sidePaneComponent = this.components.get(string);
        if (sidePaneComponent != null) {
            this.show(sidePaneComponent);
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public void hide(String string) {
        SidePaneComponent sidePaneComponent = this.components.get(string);
        if (sidePaneComponent != null) {
            this.hideComponent(sidePaneComponent);
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void register(String string, SidePaneComponent sidePaneComponent) {
        this.components.put(string, sidePaneComponent);
        this.componentNames.put(sidePaneComponent, string);
    }

    public synchronized void registerAndShow(String string, SidePaneComponent sidePaneComponent) {
        this.register(string, sidePaneComponent);
        this.show(string);
    }

    private synchronized void show(SidePaneComponent sidePaneComponent) {
        if (!this.visible.contains(sidePaneComponent)) {
            this.visible.add(0, sidePaneComponent);
            Collections.sort(this.visible, new PreferredIndexSort());
            this.updateView();
            sidePaneComponent.componentOpening();
        }
    }

    public SidePaneComponent getComponent(String string) {
        return this.components.get(string);
    }

    private String getComponentName(SidePaneComponent sidePaneComponent) {
        return this.componentNames.get(sidePaneComponent);
    }

    public synchronized void hideComponent(SidePaneComponent sidePaneComponent) {
        if (this.visible.contains(sidePaneComponent)) {
            sidePaneComponent.componentClosing();
            this.visible.remove(sidePaneComponent);
            this.updateView();
        }
    }

    public synchronized void hideComponent(String string) {
        SidePaneComponent sidePaneComponent = this.components.get(string);
        if (sidePaneComponent == null) {
            return;
        }
        if (this.visible.contains(sidePaneComponent)) {
            sidePaneComponent.componentClosing();
            this.visible.remove(sidePaneComponent);
            this.updateView();
        }
    }

    private Map<String, Integer> getPreferredPositions() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String[] stringArray = Globals.prefs.getStringArray("sidePaneComponentNames");
        String[] stringArray2 = Globals.prefs.getStringArray("sidePaneComponentPreferredPositions");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                hashMap.put(stringArray[i], Integer.parseInt(stringArray2[i]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    private void updatePreferredPositions() {
        String[] stringArray;
        Map<String, Integer> map = this.getPreferredPositions();
        int n = 0;
        for (SidePaneComponent stringArray22 : this.visible) {
            stringArray = this.getComponentName(stringArray22);
            map.put((String)stringArray, n);
            ++n;
        }
        Set<String> set = map.keySet();
        String[] stringArray2 = set.toArray(new String[set.size()]);
        stringArray = new String[map.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[i] = map.get(stringArray2[i]).toString();
        }
        Globals.prefs.putStringArray("sidePaneComponentNames", stringArray2);
        Globals.prefs.putStringArray("sidePaneComponentPreferredPositions", stringArray);
    }

    public synchronized void moveUp(SidePaneComponent sidePaneComponent) {
        int n;
        if (this.visible.contains(sidePaneComponent) && (n = this.visible.indexOf(sidePaneComponent)) > 0) {
            int n2 = n - 1;
            this.visible.remove(n);
            this.visible.add(n2, sidePaneComponent);
            this.updatePreferredPositions();
            this.updateView();
        }
    }

    public synchronized void moveDown(SidePaneComponent sidePaneComponent) {
        int n;
        if (this.visible.contains(sidePaneComponent) && (n = this.visible.indexOf(sidePaneComponent)) < this.visible.size() - 1) {
            int n2 = n + 1;
            this.visible.remove(n);
            this.visible.add(n2, sidePaneComponent);
            this.updatePreferredPositions();
            this.updateView();
        }
    }

    public synchronized void unregisterComponent(String string) {
        this.componentNames.remove(this.components.get(string));
        this.components.remove(string);
    }

    private void setActiveBasePanel(BasePanel basePanel) {
        for (Map.Entry<String, SidePaneComponent> entry : this.components.entrySet()) {
            entry.getValue().setActiveBasePanel(basePanel);
        }
    }

    public void updateView() {
        this.sidep.setComponents(this.visible);
        if (!this.visible.isEmpty()) {
            boolean bl = this.sidep.isVisible();
            this.sidep.setVisible(true);
            if (!bl) {
                int n = Globals.prefs.getInt("sidePaneWidth");
                if (n > 0) {
                    this.frame.contentPane.setDividerLocation(n);
                } else {
                    this.frame.contentPane.setDividerLocation(this.getPanel().getPreferredSize().width);
                }
            }
        } else {
            if (this.sidep.isVisible()) {
                Globals.prefs.putInt("sidePaneWidth", this.frame.contentPane.getDividerLocation());
            }
            this.sidep.setVisible(false);
        }
    }

    public void revalidate() {
        this.sidep.revalidate();
        this.sidep.repaint();
    }

    private class PreferredIndexSort
    implements Comparator<SidePaneComponent> {
        private final Map<String, Integer> preferredPositions;

        public PreferredIndexSort() {
            this.preferredPositions = SidePaneManager.this.getPreferredPositions();
        }

        @Override
        public int compare(SidePaneComponent sidePaneComponent, SidePaneComponent sidePaneComponent2) {
            String string = SidePaneManager.this.getComponentName(sidePaneComponent);
            String string2 = SidePaneManager.this.getComponentName(sidePaneComponent2);
            int n = this.preferredPositions.containsKey(string) ? this.preferredPositions.get(string) : 0;
            int n2 = this.preferredPositions.containsKey(string2) ? this.preferredPositions.get(string2) : 0;
            return Integer.valueOf(n).compareTo(n2);
        }
    }
}

