/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.SidePaneManager;
import org.jdesktop.swingx.JXTitledPanel;

public abstract class SidePaneComponent
extends JXTitledPanel {
    private static final long serialVersionUID = 1L;
    protected final JButton close = new JButton(GUIGlobals.getImage("close"));
    private boolean visible = false;
    private final SidePaneManager manager;
    protected BasePanel panel = null;

    public SidePaneComponent(SidePaneManager sidePaneManager, URL uRL, String string) {
        super(string);
        this.add(new JLabel(new ImageIcon(uRL)));
        this.manager = sidePaneManager;
        JToolBar jToolBar = new JToolBar();
        this.close.setMargin(new Insets(0, 0, 0, 0));
        this.close.setBorder(null);
        JButton jButton = new JButton(GUIGlobals.getImage("up"));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        JButton jButton2 = new JButton(GUIGlobals.getImage("down"));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(null);
        jButton2.setBorder(null);
        jButton.addActionListener(new UpButtonListener());
        jButton2.addActionListener(new DownButtonListener());
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(this.close);
        this.close.addActionListener(new CloseButtonListener());
        this.getUI().getTitleBar().add(jToolBar);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    void hideAway() {
        this.manager.hideComponent(this);
    }

    private void moveUp() {
        this.manager.moveUp(this);
    }

    private void moveDown() {
        this.manager.moveDown(this);
    }

    void setVisibility(boolean bl) {
        this.visible = bl;
    }

    boolean hasVisibility() {
        return this.visible;
    }

    public void setActiveBasePanel(BasePanel basePanel) {
        this.panel = basePanel;
    }

    public BasePanel getActiveBasePanel() {
        return this.panel;
    }

    public void componentClosing() {
    }

    public void componentOpening() {
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private class DownButtonListener
    implements ActionListener {
        private DownButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SidePaneComponent.this.moveDown();
        }
    }

    private class UpButtonListener
    implements ActionListener {
        private UpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SidePaneComponent.this.moveUp();
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SidePaneComponent.this.hideAway();
        }
    }
}

