/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryWriter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendAsEMailAction
extends AbstractWorker {
    private static final Log LOGGER = LogFactory.getLog(SendAsEMailAction.class);
    private String message = null;
    private final JabRefFrame frame;

    public SendAsEMailAction(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        URI uRI;
        void var8_14;
        Object object;
        if (!Desktop.isDesktopSupported()) {
            this.message = Globals.lang("Error creating email");
            return;
        }
        BasePanel basePanel = this.frame.basePanel();
        if (basePanel == null) {
            return;
        }
        if (basePanel.getSelectedEntries().length == 0) {
            this.message = Globals.lang("No entries selected.");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
        BibtexEntryWriter bibtexEntryWriter = new BibtexEntryWriter(new LatexFieldFormatter(), true);
        for (BibtexEntry object32 : bibtexEntryArray) {
            try {
                bibtexEntryWriter.write(object32, stringWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ArrayList arrayList = new ArrayList();
        int n = JabRefPreferences.getInstance().getBoolean("openFoldersOfAttachedFiles") ? 1 : 0;
        List<File> list = Util.getListOfLinkedFiles(bibtexEntryArray, this.frame.basePanel().metaData().getFileDirectory("file"));
        for (File file : list) {
            arrayList.add(file.getPath());
            if (n == 0) continue;
            try {
                Util.openFolderAndSelectFile(file.getAbsolutePath());
            }
            catch (IOException iOException) {
                LOGGER.debug("Could not open file", iOException);
            }
        }
        String string3 = "?Body=".concat(stringWriter.getBuffer().toString());
        string3 = string3.concat("&Subject=");
        string3 = string3.concat(JabRefPreferences.getInstance().get("emailSubject"));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string5 = var8_14.concat("&Attachment=\"").concat((String)object);
            string5 = string5.concat("\"");
        }
        try {
            uRI = new URI("mailto", (String)var8_14, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            this.message = Globals.lang("Error creating email");
            return;
        }
        object = Desktop.getDesktop();
        try {
            ((Desktop)object).mail(uRI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.message = Globals.lang("Error creating email");
            return;
        }
        this.message = String.format("%s: %d", Globals.lang("Entries added to an email"), bibtexEntryArray.length);
    }

    @Override
    public void update() {
        this.frame.output(this.message);
    }
}

