/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MarkEntriesAction;
import net.sf.jabref.MetaData;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RightClickMenu
extends JPopupMenu
implements PopupMenuListener {
    private static final Log LOGGER = LogFactory.getLog(RightClickMenu.class);
    private final BasePanel panel;
    private final MetaData metaData;
    private final JMenu groupAddMenu = new JMenu(Globals.lang("Add to group"));
    private final JMenu groupRemoveMenu = new JMenu(Globals.lang("Remove from group"));
    private final JMenu groupMoveMenu = new JMenu(Globals.lang("Assign exclusively to group"));
    private final JMenu typeMenu = new JMenu(Globals.lang("Change entry type"));
    private final JMenuItem groupAdd;
    private final JMenuItem groupRemove;
    private final JCheckBoxMenuItem floatMarked = new JCheckBoxMenuItem(Globals.lang("Float marked entries"), Globals.prefs.getBoolean("floatMarkedEntries"));

    public RightClickMenu(BasePanel basePanel, MetaData metaData) {
        this.panel = basePanel;
        this.metaData = metaData;
        boolean bl = this.panel.mainTable.getSelectedRowCount() > 1;
        BibtexEntry bibtexEntry = null;
        if (this.panel.mainTable.getSelectedRowCount() == 1) {
            bibtexEntry = (BibtexEntry)this.panel.mainTable.getSelected().get(0);
        }
        this.addPopupMenuListener(this);
        this.add(new AbstractAction(Globals.lang("Copy"), GUIGlobals.getImage("copy")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copy");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute copy", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Paste"), GUIGlobals.getImage("paste")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("paste");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute paste", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Cut"), GUIGlobals.getImage("cut")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("cut");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute cut", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Delete"), GUIGlobals.getImage("delete")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("delete");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute delete", throwable);
                }
            }
        });
        this.addSeparator();
        this.add(new AbstractAction(Globals.lang("Export to clipboard")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("exportToClipboard");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute exportToClipboard", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Send as email")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("sendAsEmail");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute sendAsEmail", throwable);
                }
            }
        });
        this.addSeparator();
        JMenu jMenu = JabRefFrame.subMenu("Mark specific color");
        JabRefFrame jabRefFrame = this.panel.frame;
        for (int i = 0; i < 5; ++i) {
            jMenu.add(new MarkEntriesAction(jabRefFrame, i).getMenuItem());
        }
        if (bl) {
            this.add(new AbstractAction(Globals.lang("Mark entries"), GUIGlobals.getImage("markEntries")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RightClickMenu.this.panel.runCommand("markEntries");
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Could not execute markEntries", throwable);
                    }
                }
            });
            this.add(jMenu);
            this.add(new AbstractAction(Globals.lang("Unmark entries"), GUIGlobals.getImage("unmarkEntries")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RightClickMenu.this.panel.runCommand("unmarkEntries");
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Could not execute unmarkEntries", throwable);
                    }
                }
            });
            this.addSeparator();
        } else if (bibtexEntry != null) {
            String string = bibtexEntry.getField("__markedentry");
            if (string == null || string.isEmpty()) {
                this.add(new AbstractAction(Globals.lang("Mark entry"), GUIGlobals.getImage("markEntries")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            RightClickMenu.this.panel.runCommand("markEntries");
                        }
                        catch (Throwable throwable) {
                            LOGGER.warn("Could not execute markEntries", throwable);
                        }
                    }
                });
                this.add(jMenu);
            } else {
                this.add(jMenu);
                this.add(new AbstractAction(Globals.lang("Unmark entry"), GUIGlobals.getImage("unmarkEntries")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            RightClickMenu.this.panel.runCommand("unmarkEntries");
                        }
                        catch (Throwable throwable) {
                            LOGGER.warn("Could not execute unmarkEntries", throwable);
                        }
                    }
                });
            }
            this.addSeparator();
        }
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                JMenu jMenu2 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu2, Rank.getInstance(), this.panel.frame);
                this.add(jMenu2);
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.add(Relevance.getInstance().getValues().get(0).getMenuAction(this.panel.frame));
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.add(Quality.getInstance().getValues().get(0).getMenuAction(this.panel.frame));
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.add(Printed.getInstance().getValues().get(0).getMenuAction(this.panel.frame));
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                JMenu jMenu3 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu3, Priority.getInstance(), this.panel.frame);
                this.add(jMenu3);
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                JMenu jMenu4 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu4, ReadStatus.getInstance(), this.panel.frame);
                this.add(jMenu4);
            }
            this.addSeparator();
        }
        this.add(new AbstractAction(Globals.lang("Open folder"), GUIGlobals.getImage("openFolder")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("openFolder");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not open folder", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Open file"), GUIGlobals.getImage("openExternalFile")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("openExternalFile");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not open external file", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Attach file"), GUIGlobals.getImage("open")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("addFileLink");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not attach file", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Open URL or DOI"), GUIGlobals.getImage("www")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("openUrl");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not execute open URL", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy BibTeX key")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copyKey");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not copy BibTex key", throwable);
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy") + " \\cite{" + Globals.lang("BibTeX key") + '}'){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copyCiteKey");
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not copy cite key", throwable);
                }
            }
        });
        this.addSeparator();
        this.populateTypeMenu();
        this.add(this.typeMenu);
        this.add(new AbstractAction(Globals.lang("Plain text import")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("importPlainText");
                }
                catch (Throwable throwable) {
                    LOGGER.debug("Could not import plain text", throwable);
                }
            }
        });
        this.add(JabRef.jrf.massSetField);
        this.add(JabRef.jrf.manageKeywords);
        this.addSeparator();
        this.groupAdd = new JMenuItem(new AbstractAction(Globals.lang("Add to group")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("addToGroup");
                }
                catch (Throwable throwable) {
                    LOGGER.debug("Could not add to group", throwable);
                }
            }
        });
        this.add(this.groupAdd);
        this.groupRemove = new JMenuItem(new AbstractAction(Globals.lang("Remove from group")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("removeFromGroup");
                }
                catch (Throwable throwable) {
                    LOGGER.debug("Could not remove from group", throwable);
                }
            }
        });
        this.add(this.groupRemove);
        JMenuItem jMenuItem = this.add(new AbstractAction(Globals.lang("Move to group")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("moveToGroup");
                }
                catch (Throwable throwable) {
                    LOGGER.debug("Could not execute move to group", throwable);
                }
            }
        });
        this.add(jMenuItem);
        this.floatMarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("floatMarkedEntries", RightClickMenu.this.floatMarked.isSelected());
                ((RightClickMenu)RightClickMenu.this).panel.mainTable.refreshSorting();
            }
        });
    }

    private void populateTypeMenu() {
        this.typeMenu.removeAll();
        for (String string : BibtexEntryType.getAllTypes()) {
            this.typeMenu.add(new ChangeTypeAction(BibtexEntryType.getType(string), this.panel));
        }
    }

    public static void populateSpecialFieldMenu(JMenu jMenu, SpecialField specialField, JabRefFrame jabRefFrame) {
        jMenu.setText(specialField.getMenuString());
        jMenu.setIcon(specialField.getRepresentingIcon());
        for (SpecialFieldValue specialFieldValue : specialField.getValues()) {
            jMenu.add(specialFieldValue.getMenuAction(jabRefFrame));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        BibtexEntry[] bibtexEntryArray = this.panel.getSelectedEntries();
        this.panel.storeCurrentEdit();
        GroupTreeNode groupTreeNode = this.panel.metaData().getGroups();
        if (groupTreeNode == null) {
            this.groupAdd.setEnabled(false);
            this.groupRemove.setEnabled(false);
        } else {
            this.groupAdd.setEnabled(true);
            this.groupRemove.setEnabled(true);
        }
        this.addSeparator();
        this.floatMarked.setSelected(Globals.prefs.getBoolean("floatMarkedEntries"));
        this.add(this.floatMarked);
    }

    private JMenu buildGroupMenu(BibtexEntry[] bibtexEntryArray, boolean bl, boolean bl2) {
        if (bibtexEntryArray == null) {
            return null;
        }
        JMenu jMenu = new JMenu();
        GroupTreeNode groupTreeNode = this.metaData.getGroups();
        if (groupTreeNode == null) {
            this.groupAddMenu.setEnabled(false);
            this.groupMoveMenu.setEnabled(false);
            this.groupRemoveMenu.setEnabled(false);
            return null;
        }
        this.insertNodes(jMenu, this.metaData.getGroups(), bibtexEntryArray, bl, bl2);
        return jMenu;
    }

    private void insertNodes(JMenu jMenu, GroupTreeNode groupTreeNode, BibtexEntry[] bibtexEntryArray, boolean bl, boolean bl2) {
        AbstractAction abstractAction = this.getAction(groupTreeNode, bibtexEntryArray, bl, bl2);
        if (groupTreeNode.getChildCount() == 0) {
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.setGroupFontAndIcon(jMenuItem, groupTreeNode.getGroup());
            jMenu.add(jMenuItem);
            if (abstractAction.isEnabled()) {
                jMenu.setEnabled(true);
            }
            return;
        }
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu, (GroupTreeNode)groupTreeNode.getChildAt(i), bibtexEntryArray, bl, bl2);
            }
        } else {
            JMenu jMenu2 = new JMenu('[' + groupTreeNode.getGroup().getName() + ']');
            this.setGroupFontAndIcon(jMenu2, groupTreeNode.getGroup());
            jMenu2.setEnabled(abstractAction.isEnabled());
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.setGroupFontAndIcon(jMenuItem, groupTreeNode.getGroup());
            jMenu2.add(jMenuItem);
            jMenu2.add(new JPopupMenu.Separator());
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu2, (GroupTreeNode)groupTreeNode.getChildAt(i), bibtexEntryArray, bl, bl2);
            }
            jMenu.add(jMenu2);
            if (jMenu2.isEnabled()) {
                jMenu.setEnabled(true);
            }
        }
    }

    private void setGroupFontAndIcon(JMenuItem jMenuItem, AbstractGroup abstractGroup) {
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            jMenuItem.setFont(jMenuItem.getFont().deriveFont(abstractGroup.isDynamic() ? 2 : 0));
        }
        if (Globals.prefs.getBoolean("groupShowIcons")) {
            switch (abstractGroup.getHierarchicalContext()) {
                case INCLUDING: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupIncluding"));
                    break;
                }
                case REFINING: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupRefining"));
                    break;
                }
                default: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupRegular"));
                }
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode groupTreeNode, BibtexEntry[] bibtexEntryArray, boolean bl, boolean bl2) {
        AbstractAction abstractAction = bl ? new AddToGroupAction(groupTreeNode, bl2, this.panel) : new RemoveFromGroupAction(groupTreeNode, this.panel);
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        if (!bl2) {
            abstractAction.setEnabled(bl ? abstractGroup.supportsAdd() && !abstractGroup.containsAll(bibtexEntryArray) : abstractGroup.supportsRemove() && abstractGroup.containsAny(bibtexEntryArray));
        } else {
            abstractAction.setEnabled(abstractGroup.supportsAdd());
        }
        return abstractAction;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.remove(this.groupAddMenu);
        this.remove(this.groupMoveMenu);
        this.remove(this.groupRemoveMenu);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    static class ChangeTypeAction
    extends AbstractAction {
        final BibtexEntryType type;
        final BasePanel panel;

        public ChangeTypeAction(BibtexEntryType bibtexEntryType, BasePanel basePanel) {
            super(bibtexEntryType.getName());
            this.type = bibtexEntryType;
            this.panel = basePanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.changeType(this.type);
        }
    }
}

