/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

class ReplaceStringDialog
extends JDialog {
    private final JTextField fields = new JTextField("", 30);
    private final JTextField from = new JTextField("", 30);
    private final JTextField to = new JTextField("", 30);
    private final JCheckBox selOnly = new JCheckBox(Globals.lang("Limit to selected entries"), false);
    private final JRadioButton allFi = new JRadioButton(Globals.lang("All fields"), true);
    private final JRadioButton field = new JRadioButton(Globals.lang("Limit to fields") + ":", false);
    private boolean ok_pressed = false;
    private String[] flds = null;
    private String s1;
    private String s2;

    public ReplaceStringDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Replace string"), true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allFi);
        buttonGroup.add(this.field);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceStringDialog.this.s1 = ReplaceStringDialog.this.from.getText();
                ReplaceStringDialog.this.s2 = ReplaceStringDialog.this.to.getText();
                if (ReplaceStringDialog.this.s1.equals("")) {
                    return;
                }
                ReplaceStringDialog.this.ok_pressed = true;
                ReplaceStringDialog.access$502(ReplaceStringDialog.this, StringUtil.split(ReplaceStringDialog.this.fields.getText().toLowerCase(), ";"));
                ReplaceStringDialog.this.dispose();
            }
        };
        JButton jButton = new JButton(Globals.lang("Ok"));
        jButton.addActionListener(actionListener);
        this.to.addActionListener(actionListener);
        this.fields.addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceStringDialog.this.dispose();
            }
        };
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jButton2.addActionListener(abstractAction);
        JPanel jPanel = new JPanel();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(jabRefFrame.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Replace string")));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Strings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagLayout.setConstraints(this.selOnly, gridBagConstraints);
        jPanel.add(this.selOnly);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(13, 5, 3, 5);
        gridBagLayout.setConstraints(this.allFi, gridBagConstraints);
        jPanel.add(this.allFi);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagLayout.setConstraints(this.field, gridBagConstraints);
        jPanel.add(this.field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.fields, gridBagConstraints);
        jPanel.add(this.fields);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(Globals.lang("Search for") + ":");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel(Globals.lang("Replace with") + ":");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.from, gridBagConstraints);
        jPanel3.add(this.from);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.to, gridBagConstraints);
        jPanel3.add(this.to);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel2.add(jButton);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
        Util.placeDialog(this, jabRefFrame);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    private boolean allFields() {
        return this.allFi.isSelected();
    }

    public boolean selOnly() {
        return this.selOnly.isSelected();
    }

    public String[] fields() {
        return StringUtil.split(this.field.getText(), ";");
    }

    public int replace(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        int n = 0;
        if (this.allFields()) {
            for (String string : bibtexEntry.getAllFields()) {
                if (string.equals("bibtexkey")) continue;
                n += this.replaceField(bibtexEntry, string, namedCompound);
            }
        } else {
            for (String string : this.flds) {
                if (string.equals("bibtexkey")) continue;
                n += this.replaceField(bibtexEntry, string, namedCompound);
            }
        }
        return n;
    }

    private int replaceField(BibtexEntry bibtexEntry, String string, NamedCompound namedCompound) {
        int n;
        String string2 = bibtexEntry.getField(string);
        if (string2 == null) {
            return 0;
        }
        String string3 = string2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.s1.length();
        while ((n = string3.indexOf(this.s1, n2)) >= 0) {
            ++n3;
            stringBuilder.append(string3.substring(n2, n));
            stringBuilder.append(this.s2);
            n2 = n + n4;
        }
        stringBuilder.append(string3.substring(n2));
        String string4 = stringBuilder.toString();
        bibtexEntry.setField(string, string4);
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, string4));
        return n3;
    }

    static /* synthetic */ String[] access$502(ReplaceStringDialog replaceStringDialog, String[] stringArray) {
        replaceStringDialog.flds = stringArray;
        return stringArray;
    }
}

