/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryContainer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.PdfPreviewPanel;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.gui.PreviewPanelTransferHandler;
import net.sf.jabref.util.Util;

public class PreviewPanel
extends JPanel
implements VetoableChangeListener,
SearchTextListener,
EntryContainer {
    private static final long serialVersionUID = 1L;
    BibtexEntry entry;
    private MetaData metaData;
    private BibtexDatabase database;
    private Layout layout;
    private String layoutFile;
    private final JEditorPane previewPane;
    private final JScrollPane scrollPane;
    private final PdfPreviewPanel pdfPreviewPanel;
    private final BasePanel panel;
    private Action printAction;
    private Action closeAction;
    private ArrayList<String> wordsToHighlight = null;

    public PreviewPanel(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, BasePanel basePanel, MetaData metaData, String string) {
        this(bibtexDatabase, bibtexEntry, basePanel, metaData, string, false);
    }

    public PreviewPanel(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, BasePanel basePanel, MetaData metaData, String string, boolean bl) {
        this(basePanel, metaData, string, bl);
        this.database = bibtexDatabase;
        this.setEntry(bibtexEntry);
    }

    public PreviewPanel(BasePanel basePanel, MetaData metaData, String string) {
        this(basePanel, metaData, string, false);
    }

    private PreviewPanel(BasePanel basePanel, MetaData metaData, String string, boolean bl) {
        super(new BorderLayout(), true);
        bl = bl && JabRefPreferences.getInstance().getBoolean("pdfPreview");
        this.panel = basePanel;
        this.metaData = metaData;
        this.layoutFile = string;
        this.previewPane = this.createPreviewPane();
        this.pdfPreviewPanel = bl ? new PdfPreviewPanel(metaData) : null;
        if (basePanel != null) {
            this.previewPane.setTransferHandler(new PreviewPanelTransferHandler(basePanel.frame(), this, this.previewPane.getTransferHandler()));
        }
        this.scrollPane = new JScrollPane(this.previewPane, 20, 31);
        this.scrollPane.setBorder(null);
        if (basePanel != null && JabRefPreferences.getInstance().getBoolean("previewPrintButton")) {
            this.add((Component)this.createToolBar(), "Before");
        }
        if (bl) {
            JSplitPane jSplitPane = new JSplitPane(1, this.scrollPane, this.pdfPreviewPanel);
            jSplitPane.setOneTouchExpandable(true);
            int n = 400;
            jSplitPane.setDividerLocation(n * 2);
            this.add(jSplitPane);
        } else {
            this.add((Component)this.scrollPane, "Center");
        }
    }

    private Action getPrintAction() {
        if (this.printAction == null) {
            this.printAction = new PrintAction();
        }
        return this.printAction;
    }

    private Action getCloseAction() {
        if (this.closeAction == null) {
            this.closeAction = new CloseAction();
        }
        return this.closeAction;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getPrintAction());
        if (this.panel != null) {
            jPopupMenu.add(this.panel.frame.switchPreview);
        }
        return jPopupMenu;
    }

    private JToolBar createToolBar() {
        Component[] componentArray;
        JToolBar jToolBar = new JToolBar(1);
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        Action action = this.getPrintAction();
        Action action2 = this.getCloseAction();
        jToolBar.setMargin(new Insets(0, 0, 0, 2));
        ActionMap actionMap = jToolBar.getActionMap();
        InputMap inputMap = jToolBar.getInputMap(2);
        inputMap.put(jabRefPreferences.getKey("Close entry preview"), "close");
        actionMap.put("close", action2);
        inputMap.put(jabRefPreferences.getKey("Print entry preview"), "print");
        actionMap.put("print", action);
        jToolBar.setFloatable(false);
        jToolBar.add(action2);
        jToolBar.addSeparator();
        jToolBar.add(action);
        for (Component component : componentArray = jToolBar.getComponents()) {
            ((JComponent)component).setOpaque(false);
        }
        return jToolBar;
    }

    private JEditorPane createPreviewPane() {
        JEditorPane jEditorPane = new JEditorPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        jEditorPane.setMargin(new Insets(3, 3, 3, 3));
        jEditorPane.setComponentPopupMenu(this.createPopupMenu());
        jEditorPane.setEditable(false);
        jEditorPane.setDragEnabled(true);
        jEditorPane.setContentType("text/html");
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String string = hyperlinkEvent.getURL().toString();
                        Util.openExternalViewer(PreviewPanel.this.metaData, string, "url");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        return jEditorPane;
    }

    public void setDatabase(BibtexDatabase bibtexDatabase) {
        this.database = bibtexDatabase;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public void readLayout(String string) throws Exception {
        this.layoutFile = string;
        this.readLayout();
    }

    private void readLayout() throws Exception {
        StringReader stringReader = new StringReader(this.layoutFile.replaceAll("__NEWLINE__", "\n"));
        this.layout = new LayoutHelper(stringReader).getLayoutFromText("net.sf.jabref.export.layout.format.");
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry != this.entry) {
            if (this.entry != null) {
                this.entry.removePropertyChangeListener(this);
            }
            bibtexEntry.addPropertyChangeListener(this);
        }
        this.entry = bibtexEntry;
        try {
            this.readLayout();
            this.update();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw stringIndexOutOfBoundsException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public BibtexEntry getEntry() {
        return this.entry;
    }

    public void update() {
        StringBuilder stringBuilder = new StringBuilder();
        ExportFormats.entryNumber = 1;
        if (this.entry != null) {
            stringBuilder.append(this.layout.doLayout(this.entry, this.database, this.wordsToHighlight));
        }
        this.previewPane.setText(stringBuilder.toString());
        this.previewPane.revalidate();
        final JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScrollBar.setValue(0);
            }
        });
        if (this.pdfPreviewPanel != null) {
            this.pdfPreviewPanel.updatePanel(this.entry);
        }
    }

    public boolean hasEntry() {
        return this.entry != null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.update();
    }

    @Override
    public void searchText(ArrayList<String> arrayList) {
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.wordsToHighlight = arrayList;
            this.update();
        } else if (this.wordsToHighlight != null) {
            this.wordsToHighlight = null;
            this.update();
        }
    }

    class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            super(Globals.lang("Close window"), GUIGlobals.getImage("close"));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPanel.this.panel.hideBottomComponent();
        }
    }

    class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PrintAction() {
            super(Globals.lang("Print Preview"), GUIGlobals.getImage("psSmall"));
            this.putValue("ShortDescription", Globals.lang("Print Preview"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                        hashPrintRequestAttributeSet.add(new JobName(PreviewPanel.this.entry.getCiteKey(), null));
                        PreviewPanel.this.previewPane.print(null, null, true, null, hashPrintRequestAttributeSet, false);
                    }
                    catch (PrinterException printerException) {
                        JOptionPane.showMessageDialog(PreviewPanel.this, Globals.lang("Could not print preview") + ".\n" + printerException.getMessage(), Globals.lang("Printing Entry Preview"), 0);
                    }
                }
            });
        }
    }
}

