/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.migrations.VersionHandling;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.util.StringUtil;

public class MetaData
implements Iterable<String> {
    private static final String PREFIX_KEYPATTERN = "keypattern_";
    private static final String KEYPATTERNDEFAULT = "keypatterndefault";
    private final HashMap<String, Vector<String>> metaData = new HashMap();
    private GroupTreeNode groupsRoot = null;
    private File file = null;
    private boolean groupTreeValid = true;
    private LabelPattern labelPattern = null;
    private DBStrings dbStrings = new DBStrings();

    public MetaData(HashMap<String, String> hashMap, BibtexDatabase bibtexDatabase) {
        boolean bl = false;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        int n = 0;
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                StringReader stringReader = new StringReader(hashMap.get(string));
                Vector<String> vector3 = new Vector<String>();
                try {
                    String string2;
                    while ((string2 = this.getNextUnit(stringReader)) != null) {
                        vector3.add(string2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Weird error while parsing meta data.");
                }
                if (string.equals("groupsversion")) {
                    if (vector3.size() < 1) continue;
                    n = Integer.parseInt((String)vector3.firstElement());
                    continue;
                }
                if (string.equals("groupstree")) {
                    bl = true;
                    vector2 = vector3;
                    continue;
                }
                if (string.equals("groups")) {
                    vector = vector3;
                    continue;
                }
                this.putData(string, vector3);
            }
        }
        if (bl) {
            this.putGroups(vector2, bibtexDatabase, n);
        }
        if (!bl && vector != null) {
            try {
                this.groupsRoot = VersionHandling.importFlatGroups(vector);
                this.groupTreeValid = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.groupTreeValid = true;
            }
        }
    }

    public MetaData() {
    }

    public void initializeNewDatabase() {
        this.metaData.put("selector_keywords", new Vector());
        this.metaData.put("selector_author", new Vector());
        this.metaData.put("selector_journal", new Vector());
        this.metaData.put("selector_publisher", new Vector());
        this.metaData.put("selector_review", new Vector());
    }

    @Override
    public Iterator<String> iterator() {
        return this.metaData.keySet().iterator();
    }

    public Vector<String> getData(String string) {
        return this.metaData.get(string);
    }

    public void remove(String string) {
        this.metaData.remove(string);
    }

    public void putData(String string, Vector<String> vector) {
        this.metaData.put(string, vector);
    }

    public String[] getFileDirectory(String string) {
        String string2 = Globals.prefs.get("userFileDirIndividual");
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector<String> vector = this.getData(string2);
        if (vector == null) {
            string2 = Globals.prefs.get("userFileDir");
            vector = this.getData(string2);
        }
        if (vector != null && vector.size() > 0) {
            String string3;
            String string4 = vector.get(0);
            if (!new File(string4).isAbsolute() && this.file != null && new File(string3 = string4.equals(".") ? this.file.getParent() : this.file.getParent() + System.getProperty("file.separator") + string4).exists()) {
                string4 = string3;
            }
            arrayList.add(string4);
        } else {
            String string5 = Globals.prefs.get(string + "Directory");
            if (string5 != null) {
                arrayList.add(string5);
            }
        }
        if (Globals.prefs.getBoolean("bibLocationAsFileDir") && this.getFile() != null) {
            if (Globals.prefs.getBoolean("bibLocAsPrimaryDir")) {
                arrayList.add(0, this.getFile().getParent());
            } else {
                arrayList.add(this.getFile().getParent());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void putGroups(Vector<String> vector, BibtexDatabase bibtexDatabase, int n) {
        try {
            this.groupsRoot = VersionHandling.importGroups(vector, bibtexDatabase, n);
            this.groupTreeValid = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.groupTreeValid = false;
        }
    }

    public GroupTreeNode getGroups() {
        return this.groupsRoot;
    }

    public void setGroups(GroupTreeNode groupTreeNode) {
        this.groupsRoot = groupTreeNode;
        this.groupTreeValid = true;
    }

    public void writeMetaData(Writer writer) throws IOException {
        StringBuffer stringBuffer;
        TreeSet<String> treeSet = new TreeSet<String>(this.metaData.keySet());
        for (String object : treeSet) {
            stringBuffer = new StringBuffer();
            Vector<String> vector = this.metaData.get(object);
            stringBuffer.append("@comment{").append("jabref-meta: ").append(object).append(":");
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(StringUtil.quote(vector.elementAt(i), ";", '\\')).append(";");
            }
            stringBuffer.append("}");
            stringBuffer.append(Globals.NEWLINE);
            stringBuffer.append(Globals.NEWLINE);
            writer.write(stringBuffer.toString());
        }
        if (this.groupsRoot != null && this.groupsRoot.getChildCount() > 0) {
            Object object2 = new StringBuffer();
            ((StringBuffer)object2).append("@comment{").append("jabref-meta: ").append("groupsversion:");
            ((StringBuffer)object2).append("3;");
            ((StringBuffer)object2).append("}");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            ((StringBuffer)object2).append(Globals.NEWLINE);
            writer.write(((StringBuffer)object2).toString());
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("@comment{").append("jabref-meta: ").append("groupstree:");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            StringTokenizer stringTokenizer = new StringTokenizer(this.groupsRoot.getTreeAsString(), Globals.NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer = new StringBuffer(StringUtil.quote(stringTokenizer.nextToken(), ";", '\\') + ";");
                ((StringBuffer)object2).append(stringBuffer);
                ((StringBuffer)object2).append(Globals.NEWLINE);
            }
            ((StringBuffer)object2).append("}");
            ((StringBuffer)object2).append(Globals.NEWLINE);
            ((StringBuffer)object2).append(Globals.NEWLINE);
            writer.write(((StringBuffer)object2).toString());
        }
    }

    private String getNextUnit(Reader reader) throws IOException {
        int n;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            if (bl) {
                stringBuilder.append((char)n);
                bl = false;
                continue;
            }
            if (n == 92) {
                bl = true;
                continue;
            }
            if (n == 59) break;
            stringBuilder.append((char)n);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public DBStrings getDBStrings() {
        return this.dbStrings;
    }

    public void setDBStrings(DBStrings dBStrings) {
        this.dbStrings = dBStrings;
    }

    public boolean isGroupTreeValid() {
        return this.groupTreeValid;
    }

    public LabelPattern getLabelPattern() {
        if (this.labelPattern != null) {
            return this.labelPattern;
        }
        this.labelPattern = new LabelPattern();
        this.labelPattern.setParent(Globals.prefs.getKeyPattern());
        for (String string : this) {
            if (!string.startsWith(PREFIX_KEYPATTERN)) continue;
            Vector<String> vector = this.getData(string);
            String string2 = string.substring(PREFIX_KEYPATTERN.length());
            this.labelPattern.addLabelPattern(string2, vector.get(0));
        }
        Vector<String> vector = this.getData(KEYPATTERNDEFAULT);
        if (vector != null) {
            this.labelPattern.setDefaultValue((String)vector.get(0));
        }
        return this.labelPattern;
    }

    public void setLabelPattern(LabelPattern labelPattern) {
        Object object;
        Iterator<String> iterator = this.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((String)object).startsWith(PREFIX_KEYPATTERN)) continue;
            iterator.remove();
        }
        for (String string : labelPattern.keySet()) {
            String string2 = PREFIX_KEYPATTERN + string;
            ArrayList arrayList = (ArrayList)labelPattern.get(string);
            if (arrayList == null) continue;
            Vector<String> vector = new Vector<String>();
            vector.add((String)arrayList.get(0));
            this.putData(string2, vector);
        }
        if (labelPattern.getDefaultValue() == null) {
            this.remove(KEYPATTERNDEFAULT);
        } else {
            object = new Vector<String>();
            ((Vector)object).add(labelPattern.getDefaultValue().get(0));
            this.putData(KEYPATTERNDEFAULT, (Vector<String>)object);
        }
        this.labelPattern = labelPattern;
    }
}

